/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModFixs {
    private static final Logger LOGGER = LogManager.getLogger();
    final String mod;
    final int version;
    private final Map<IFixType, List<IFixableData>> fixes = Maps.newHashMap();

    ModFixs(String mod, int version) {
        this.mod = mod;
        this.version = version;
    }

    public List<IFixableData> getFixes(IFixType type) {
        return this.fixes.computeIfAbsent(type, k -> Lists.newArrayList());
    }

    public void registerFix(IFixType type, IFixableData fixer) {
        List<IFixableData> list = this.getFixes(type);
        int ver = fixer.getFixVersion();
        if (ver > this.version) {
            LOGGER.warn("[{}] Ignored fix registered for version: {} as the DataVersion of the game is: {}", (Object)this.mod, (Object)ver, (Object)this.version);
            return;
        }
        if (!list.isEmpty() && list.get(list.size() - 1).getFixVersion() > ver) {
            for (int x = 0; x < list.size(); ++x) {
                if (list.get(x).getFixVersion() <= ver) continue;
                list.add(x, fixer);
                break;
            }
        } else {
            list.add(fixer);
        }
    }
}

