/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.cleanroommc.hackery.ReflectionHackery;
import com.cleanroommc.hackery.enums.EnumHackery;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.ArrayUtils;

public class EnumHelper {
    private static Class<?>[][] commonTypes = new Class[][]{{EnumAction.class}, {ItemArmor.ArmorMaterial.class, String.class, Integer.TYPE, int[].class, Integer.TYPE, SoundEvent.class, Float.TYPE}, {EntityPainting.EnumArt.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {EnumCreatureAttribute.class}, {EnumCreatureType.class, Class.class, Integer.TYPE, Material.class, Boolean.TYPE, Boolean.TYPE}, {StructureStrongholdPieces.Stronghold.Door.class}, {EnumEnchantmentType.class, Predicate.class}, {BlockPressurePlate.Sensitivity.class}, {RayTraceResult.Type.class}, {EnumSkyBlock.class, Integer.TYPE}, {EntityPlayer.SleepResult.class}, {Item.ToolMaterial.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}, {EnumRarity.class, TextFormatting.class, String.class}, {HorseArmorType.class, String.class, Integer.TYPE}, {EntityLiving.SpawnPlacementType.class, BiPredicate.class}};

    @Nullable
    public static EnumAction addAction(String name) {
        return EnumHackery.addEnumEntry(EnumAction.class, name);
    }

    @Nullable
    public static ItemArmor.ArmorMaterial addArmorMaterial(String name, String textureName, int durability, int[] reductionAmounts, int enchantability, SoundEvent soundOnEquip, float toughness) {
        return EnumHackery.addEnumEntry(ItemArmor.ArmorMaterial.class, name, new Class[]{String.class, Integer.TYPE, int[].class, Integer.TYPE, SoundEvent.class, Float.TYPE}, new Object[]{textureName, durability, reductionAmounts, enchantability, soundOnEquip, Float.valueOf(toughness)});
    }

    @Nullable
    public static EntityPainting.EnumArt addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        return EnumHackery.addEnumEntry(EntityPainting.EnumArt.class, name, new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{tile, sizeX, sizeY, offsetX, offsetY});
    }

    @Nullable
    public static EnumCreatureAttribute addCreatureAttribute(String name) {
        return EnumHackery.addEnumEntry(EnumCreatureAttribute.class, name);
    }

    @Nullable
    public static EnumCreatureType addCreatureType(String name, Class<? extends IAnimals> typeClass, int maxNumber, Material material, boolean peaceful, boolean animal) {
        return EnumHackery.addEnumEntry(EnumCreatureType.class, name, new Class[]{Class.class, Integer.TYPE, Material.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{typeClass, maxNumber, material, peaceful, animal});
    }

    @Nullable
    public static StructureStrongholdPieces.Stronghold.Door addDoor(String name) {
        return EnumHackery.addEnumEntry(StructureStrongholdPieces.Stronghold.Door.class, name);
    }

    @Nullable
    public static EnumEnchantmentType addEnchantmentType(String name, Predicate<Item> delegate) {
        return EnumHackery.addEnumEntry(EnumEnchantmentType.class, name, new Class[]{Predicate.class}, new Object[]{delegate});
    }

    @Nullable
    public static BlockPressurePlate.Sensitivity addSensitivity(String name) {
        return EnumHackery.addEnumEntry(BlockPressurePlate.Sensitivity.class, name);
    }

    @Nullable
    public static RayTraceResult.Type addMovingObjectType(String name) {
        return EnumHackery.addEnumEntry(RayTraceResult.Type.class, name);
    }

    @Nullable
    public static EnumSkyBlock addSkyBlock(String name, int lightValue) {
        return EnumHackery.addEnumEntry(EnumSkyBlock.class, name, new Class[]{Integer.TYPE}, new Object[]{lightValue});
    }

    @Nullable
    public static EntityPlayer.SleepResult addStatus(String name) {
        return EnumHackery.addEnumEntry(EntityPlayer.SleepResult.class, name);
    }

    @Nullable
    public static Item.ToolMaterial addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability) {
        return EnumHackery.addEnumEntry(Item.ToolMaterial.class, name, new Class[]{Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}, new Object[]{harvestLevel, maxUses, Float.valueOf(efficiency), Float.valueOf(damage), enchantability});
    }

    @Nullable
    @Deprecated
    public static EnumRarity addRarity(String name, TextFormatting color, String displayName) {
        return EnumHackery.addEnumEntry(EnumRarity.class, name, new Class[]{TextFormatting.class, String.class}, new Object[]{color, displayName});
    }

    @Nullable
    public static EntityLiving.SpawnPlacementType addSpawnPlacementType(String name, BiPredicate<IBlockAccess, BlockPos> predicate) {
        return EnumHackery.addEnumEntry(EntityLiving.SpawnPlacementType.class, name, new Class[]{BiPredicate.class}, new Object[]{predicate});
    }

    @Nullable
    public static HorseArmorType addHorseArmor(String name, String textureLocation, int armorStrength) {
        return EnumHackery.addEnumEntry(HorseArmorType.class, name, new Class[]{String.class, Integer.TYPE}, new Object[]{textureLocation, armorStrength});
    }

    public static void setFailsafeFieldValue(Field field, @Nullable Object target, @Nullable Object value) throws Exception {
        if (Modifier.isStatic(field.getModifiers())) {
            ReflectionHackery.unsafe.putObject(ReflectionHackery.unsafe.staticFieldBase(field), ReflectionHackery.unsafe.staticFieldOffset(field), value);
        } else {
            ReflectionHackery.unsafe.putObject(target, ReflectionHackery.unsafe.objectFieldOffset(field), value);
        }
    }

    public static void testEnum(final Class<? extends Enum<?>> enumType, final Class<?>[] paramTypes) {
        Field[] fields;
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = (FMLForgePlugin.RUNTIME_DEOBF ? 1 : 2) | 8 | 0x10 | 0x1000;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            final ArrayList lines = Lists.newArrayList();
            lines.add(String.format("Could not find $VALUES field for enum: %s", enumType.getName()));
            lines.add(String.format("Runtime Deobf: %s", FMLForgePlugin.RUNTIME_DEOBF));
            lines.add(String.format("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0')));
            lines.add("Fields:");
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                lines.add(String.format("       %s %s: %s", mods, field.getName(), field.getType().getName()));
            }
            for (String line : lines) {
                FMLLog.log.fatal(line);
            }
            throw new EnhancedRuntimeException("Could not find $VALUES field for enum: " + enumType.getName()){

                @Override
                protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                    for (String line : lines) {
                        stream.println(line);
                    }
                }
            };
        }
        Constructor<? extends Enum<?>> ctr = null;
        Exception ex = null;
        try {
            Object[] prefixedParamTypes = new Class[]{String.class, Integer.TYPE};
            ctr = enumType.getDeclaredConstructor((Class[])ArrayUtils.addAll((Object[])prefixedParamTypes, (Object[])paramTypes));
        }
        catch (Exception e) {
            ex = e;
        }
        if (ctr == null || ex != null) {
            throw new EnhancedRuntimeException(String.format("Could not find constructor for Enum %s", enumType.getName()), (Throwable)ex){

                private String toString(Class<?>[] cls) {
                    StringBuilder b = new StringBuilder();
                    for (int x = 0; x < cls.length; ++x) {
                        b.append(cls[x].getName());
                        if (x == cls.length - 1) continue;
                        b.append(", ");
                    }
                    return b.toString();
                }

                @Override
                protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                    stream.println("Target Arguments:");
                    stream.println("    java.lang.String, int, " + this.toString(paramTypes));
                    stream.println("Found Constructors:");
                    for (Constructor<?> ctr : enumType.getDeclaredConstructors()) {
                        stream.println("    " + this.toString(ctr.getParameterTypes()));
                    }
                }
            };
        }
    }

    @Nullable
    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object ... paramValues) {
        return EnumHackery.addEnumEntry(enumType, enumName, paramTypes, paramValues);
    }
}

