/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.property;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class Properties {
    public static final PropertyBool StaticProperty = PropertyBool.create("static");
    public static final IUnlistedProperty<IModelState> AnimationProperty = new IUnlistedProperty<IModelState>(){

        @Override
        public String getName() {
            return "forge_animation";
        }

        @Override
        public boolean isValid(IModelState state) {
            return true;
        }

        @Override
        public Class<IModelState> getType() {
            return IModelState.class;
        }

        @Override
        public String valueToString(IModelState state) {
            return state.toString();
        }
    };

    public static <V extends Comparable<V>> IUnlistedProperty<V> toUnlisted(IProperty<V> property) {
        return new PropertyAdapter<V>(property);
    }

    public static class PropertyAdapter<V extends Comparable<V>>
    implements IUnlistedProperty<V> {
        private final IProperty<V> parent;

        public PropertyAdapter(IProperty<V> parent) {
            this.parent = parent;
        }

        @Override
        public String getName() {
            return this.parent.getName();
        }

        @Override
        public boolean isValid(V value) {
            return this.parent.getAllowedValues().contains(value);
        }

        @Override
        public Class<V> getType() {
            return this.parent.getValueClass();
        }

        @Override
        public String valueToString(V value) {
            return this.parent.getName(value);
        }
    }
}

