/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.command;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntitySelector;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraftforge.common.command.SelectorHandler;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.ArrayUtils;

public class SelectorHandlerManager {
    public static final NavigableMap<String, SelectorHandler> selectorHandlers = new TreeMap(Collections.reverseOrder());
    public static final NavigableMap<String, String> registeringMods = new TreeMap(Collections.reverseOrder());
    private static final SelectorHandler vanillaHandler = new SelectorHandler(){

        @Override
        public <T extends Entity> List<T> matchEntities(ICommandSender sender, String token, Class<? extends T> targetClass) throws CommandException {
            return EntitySelector.matchEntitiesDefault(sender, token, targetClass);
        }

        @Override
        public boolean matchesMultiplePlayers(String selectorStr) throws CommandException {
            return EntitySelector.matchesMultiplePlayersDefault(selectorStr);
        }

        @Override
        public boolean isSelector(String selectorStr) {
            return EntitySelector.isSelectorDefault(selectorStr);
        }
    };

    private SelectorHandlerManager() {
    }

    public static void register(String prefix, SelectorHandler handler) {
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("Prefix must not be empty");
        }
        String modId = Loader.instance().activeModContainer().getModId();
        selectorHandlers.put(prefix, handler);
        registeringMods.put(prefix, modId);
    }

    public static SelectorHandler getHandler(String selectorStr) {
        if (!selectorStr.isEmpty()) {
            for (Map.Entry handler : selectorHandlers.subMap(selectorStr, true, selectorStr.substring(0, 1), true).entrySet()) {
                if (!selectorStr.startsWith((String)handler.getKey())) continue;
                return (SelectorHandler)handler.getValue();
            }
        }
        return vanillaHandler;
    }

    public static <T extends Entity> List<T> matchEntities(ICommandSender sender, String token, Class<? extends T> targetClass) throws CommandException {
        return SelectorHandlerManager.getHandler(token).matchEntities(sender, token, targetClass);
    }

    public static boolean matchesMultiplePlayers(String selectorStr) throws CommandException {
        return SelectorHandlerManager.getHandler(selectorStr).matchesMultiplePlayers(selectorStr);
    }

    public static boolean isSelector(String selectorStr) {
        return SelectorHandlerManager.getHandler(selectorStr).isSelector(selectorStr);
    }

    static {
        for (String prefix : (String[])ArrayUtils.toArray((Object[])new String[]{"@p", "@a", "@r", "@e", "@s"})) {
            selectorHandlers.put(prefix, vanillaHandler);
            registeringMods.put(prefix, "minecraft");
        }
    }
}

