/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class VanillaBrewingRecipe
implements IBrewingRecipe {
    @Override
    public boolean isInput(@Nonnull ItemStack stack) {
        Item item = stack.getItem();
        return item == Items.POTIONITEM || item == Items.SPLASH_POTION || item == Items.LINGERING_POTION || item == Items.GLASS_BOTTLE;
    }

    @Override
    public boolean isIngredient(@Nonnull ItemStack stack) {
        return PotionHelper.isReagent(stack);
    }

    @Override
    @Nonnull
    public ItemStack getOutput(@Nonnull ItemStack input, @Nonnull ItemStack ingredient) {
        if (!input.isEmpty() && !ingredient.isEmpty() && this.isIngredient(ingredient)) {
            ItemStack result = PotionHelper.doReaction(ingredient, input);
            if (result != input) {
                return result;
            }
            return ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }
}

