/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.common.FMLLog;

public class WorldSpecificSaveHandler
implements ISaveHandler {
    private WorldServer world;
    private ISaveHandler parent;
    private File dataDir;

    public WorldSpecificSaveHandler(WorldServer world, ISaveHandler parent) {
        this.world = world;
        this.parent = parent;
    }

    @Override
    public WorldInfo loadWorldInfo() {
        return this.parent.loadWorldInfo();
    }

    @Override
    public void checkSessionLock() throws MinecraftException {
        this.parent.checkSessionLock();
    }

    @Override
    public IChunkLoader getChunkLoader(WorldProvider var1) {
        return this.parent.getChunkLoader(var1);
    }

    @Override
    public void saveWorldInfoWithPlayer(WorldInfo var1, NBTTagCompound var2) {
        this.parent.saveWorldInfoWithPlayer(var1, var2);
    }

    @Override
    public void saveWorldInfo(WorldInfo var1) {
        this.parent.saveWorldInfo(var1);
    }

    @Override
    public IPlayerFileData getPlayerNBTManager() {
        return this.parent.getPlayerNBTManager();
    }

    @Override
    public void flush() {
        this.parent.flush();
    }

    @Override
    public File getWorldDirectory() {
        return this.parent.getWorldDirectory();
    }

    @Override
    public File getMapFileFromName(String name) {
        File file;
        if (this.dataDir == null) {
            this.dataDir = new File(this.world.getChunkSaveLocation(), "data");
            this.dataDir.mkdirs();
        }
        if (!(file = new File(this.dataDir, name + ".dat")).exists()) {
            switch (this.world.provider.getDimension()) {
                case -1: {
                    if (!name.equalsIgnoreCase("FORTRESS")) break;
                    this.copyFile(name, file);
                    break;
                }
                case 1: {
                    if (!name.equalsIgnoreCase("VILLAGES_END")) break;
                    this.copyFile(name, file);
                }
            }
        }
        return file;
    }

    private void copyFile(String name, File to) {
        File parentFile = this.parent.getMapFileFromName(name);
        if (parentFile.exists()) {
            try {
                Files.copy((File)parentFile, (File)to);
            }
            catch (IOException e) {
                FMLLog.log.error("A critical error occurred copying {} to world specific dat folder - new file will be created.", (Object)parentFile.getName(), (Object)e);
            }
        }
    }

    @Override
    public TemplateManager getStructureTemplateManager() {
        return this.parent.getStructureTemplateManager();
    }
}

