/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.common.ticket.ChunkTicketManager;
import net.minecraftforge.common.ticket.SimpleTicket;
import net.minecraftforge.fml.common.FMLLog;

public class FarmlandWaterManager {
    private static boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugFarmlandWaterManager", "false"));
    private static final Int2ObjectMap<Map<ChunkPos, ChunkTicketManager<Vec3d>>> customWaterHandler = new Int2ObjectOpenHashMap();

    @Deprecated
    public static <T extends SimpleTicket<Vec3d>> T addCustomTicket(World world, T ticket, ChunkPos ... chunkPoses) {
        return FarmlandWaterManager.addCustomTicket(world, ticket, chunkPoses[0], Arrays.copyOfRange(chunkPoses, 1, chunkPoses.length));
    }

    public static <T extends SimpleTicket<Vec3d>> T addCustomTicket(World world, T ticket, ChunkPos masterChunk, ChunkPos ... additionalChunks) {
        Preconditions.checkArgument((!world.isRemote ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map ticketMap = (Map)customWaterHandler.computeIfAbsent(world.provider.getDimension(), id -> new MapMaker().weakValues().makeMap());
        ChunkTicketManager[] additionalTickets = new ChunkTicketManager[additionalChunks.length];
        for (int i = 0; i < additionalChunks.length; ++i) {
            additionalTickets[i] = ticketMap.computeIfAbsent(additionalChunks[i], ChunkTicketManager::new);
        }
        ticket.setManager(ticketMap.computeIfAbsent(masterChunk, ChunkTicketManager::new), additionalTickets);
        ticket.validate();
        return ticket;
    }

    public static AABBTicket addAABBTicket(World world, AxisAlignedBB aabb) {
        if (DEBUG) {
            FMLLog.log.info("FarmlandWaterManager: New AABBTicket, aabb={}", (Object)aabb);
        }
        ChunkPos leftUp = new ChunkPos((int)aabb.minX >> 4, (int)aabb.minZ >> 4);
        ChunkPos rightDown = new ChunkPos((int)aabb.maxX >> 4, (int)aabb.maxZ >> 4);
        HashSet<ChunkPos> posSet = new HashSet<ChunkPos>();
        for (int x = leftUp.x; x <= rightDown.x; ++x) {
            for (int z = leftUp.z; z <= rightDown.z; ++z) {
                posSet.add(new ChunkPos(x, z));
            }
        }
        ChunkPos masterPos = null;
        double masterDistance = Double.MAX_VALUE;
        for (ChunkPos pos : posSet) {
            Vec3d center;
            double distToCenter = FarmlandWaterManager.getDistanceSq(pos, center = new Vec3d(aabb.minX + (aabb.maxX - aabb.minX) * 0.5, aabb.minY + (aabb.maxY - aabb.minY) * 0.5, aabb.minZ + (aabb.maxZ - aabb.minZ) * 0.5));
            if (!(distToCenter < masterDistance)) continue;
            if (DEBUG) {
                FMLLog.log.info("FarmlandWaterManager: New better pos then {}: {}, prev dist {}, new dist {}", (Object)masterPos, (Object)pos, (Object)masterDistance, (Object)distToCenter);
            }
            masterPos = pos;
            masterDistance = distToCenter;
        }
        posSet.remove(masterPos);
        if (DEBUG) {
            FMLLog.log.info("FarmlandWaterManager: {} center pos, {} dummy posses. Dist to center {}", masterPos, (Object)posSet.toArray(new ChunkPos[0]), (Object)masterDistance);
        }
        return FarmlandWaterManager.addCustomTicket(world, new AABBTicket(aabb), masterPos, posSet.toArray(new ChunkPos[0]));
    }

    private static double getDistanceSq(ChunkPos pos, Vec3d vec3d) {
        double d0 = pos.x * 16 + 8;
        double d1 = pos.z * 16 + 8;
        double d2 = d0 - vec3d.x;
        double d3 = d1 - vec3d.z;
        return d2 * d2 + d3 * d3;
    }

    public static boolean hasBlockWaterTicket(World world, BlockPos pos) {
        ChunkTicketManager<Vec3d> ticketManager = FarmlandWaterManager.getTicketManager(new ChunkPos(pos.getX() >> 4, pos.getZ() >> 4), world);
        if (ticketManager != null) {
            Vec3d posAsVec3d = new Vec3d((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            for (SimpleTicket<Vec3d> ticket : ticketManager.getTickets()) {
                if (!ticket.matches(posAsVec3d)) continue;
                return true;
            }
        }
        return false;
    }

    static void removeTickets(Chunk chunk) {
        ChunkTicketManager<Vec3d> ticketManager = FarmlandWaterManager.getTicketManager(chunk.getPos(), chunk.getWorld());
        if (ticketManager != null) {
            if (DEBUG) {
                FMLLog.log.info("FarmlandWaterManager: got tickets {} at {} before", (Object)ticketManager.getTickets().size(), (Object)ticketManager.pos);
            }
            ticketManager.getTickets().removeIf(next -> next.unload(ticketManager));
            if (DEBUG) {
                FMLLog.log.info("FarmlandWaterManager: got tickets {} at {} after", (Object)ticketManager.getTickets().size(), (Object)ticketManager.pos);
            }
        }
    }

    private static ChunkTicketManager<Vec3d> getTicketManager(ChunkPos pos, World world) {
        Preconditions.checkArgument((!world.isRemote ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map ticketMap = (Map)customWaterHandler.get(world.provider.getDimension());
        if (ticketMap == null) {
            return null;
        }
        return (ChunkTicketManager)ticketMap.get(pos);
    }
}

