/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;

public class DimensionManager {
    private static boolean hasInit = false;
    private static int lastUsedId = 0;
    private static final Int2ObjectMap<WorldServer> worlds = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap());
    private static final Int2ObjectMap<Dimension> dimensions = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap());
    private static final IntSet keepLoaded = IntSets.synchronize((IntSet)new IntOpenHashSet());
    private static final IntSet unloadQueue = IntSets.synchronize((IntSet)new IntLinkedOpenHashSet());
    private static final IntSet usedIds = new IntOpenHashSet();
    private static final ConcurrentMap<World, World> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static final Multiset<Integer> leakedWorlds = HashMultiset.create();

    public static int[] getDimensions(DimensionType type) {
        int[] ret = new int[dimensions.size()];
        int x = 0;
        for (Int2ObjectMap.Entry ent : dimensions.int2ObjectEntrySet()) {
            if (((Dimension)ent.getValue()).type != type) continue;
            ret[x++] = ent.getIntKey();
        }
        return Arrays.copyOf(ret, x);
    }

    public static Map<DimensionType, IntSortedSet> getRegisteredDimensions() {
        IdentityHashMap<DimensionType, IntSortedSet> map = new IdentityHashMap<DimensionType, IntSortedSet>();
        for (Int2ObjectMap.Entry entry : dimensions.int2ObjectEntrySet()) {
            map.computeIfAbsent(((Dimension)entry.getValue()).type, k -> new IntRBTreeSet()).add(entry.getIntKey());
        }
        return map;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        DimensionManager.registerDimension(0, DimensionType.OVERWORLD);
        DimensionManager.registerDimension(-1, DimensionType.NETHER);
        DimensionManager.registerDimension(1, DimensionType.THE_END);
    }

    public static void registerDimension(int id, DimensionType type) {
        DimensionType.getById(type.getId());
        if (dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to register dimension for id %d, One is already registered", id));
        }
        dimensions.put(id, (Object)new Dimension(type));
        if (id >= 0) {
            usedIds.add(id);
        }
    }

    public static void unregisterDimension(int id) {
        if (!dimensions.containsKey(id)) {
            throw new IllegalArgumentException(String.format("Failed to unregister dimension for id %d; No provider registered", id));
        }
        dimensions.remove(id);
    }

    public static boolean isDimensionRegistered(int dim) {
        return dimensions.containsKey(dim);
    }

    public static DimensionType getProviderType(int dim) {
        if (!dimensions.containsKey(dim)) {
            throw new IllegalArgumentException(String.format("Could not get provider type for dimension %d, does not exist", dim));
        }
        return ((Dimension)DimensionManager.dimensions.get((int)dim)).type;
    }

    public static WorldProvider getProvider(int dim) {
        return DimensionManager.getWorld((int)dim).provider;
    }

    public static Integer[] getIDs(boolean check) {
        if (check) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll((Collection<?>)worlds.values());
            ListIterator li = allWorlds.listIterator();
            while (li.hasNext()) {
                World w = (World)li.next();
                leakedWorlds.add((Object)System.identityHashCode(w));
            }
            for (World w : allWorlds) {
                int leakCount = leakedWorlds.count((Object)System.identityHashCode(w));
                if (leakCount == 5) {
                    FMLLog.log.debug("The world {} ({}) may have leaked: first encounter (5 occurrences).\n", (Object)Integer.toHexString(System.identityHashCode(w)), (Object)w.getWorldInfo().getWorldName());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                FMLLog.log.debug("The world {} ({}) may have leaked: seen {} times.\n", (Object)Integer.toHexString(System.identityHashCode(w)), (Object)w.getWorldInfo().getWorldName(), (Object)leakCount);
            }
        }
        return DimensionManager.getIDs();
    }

    public static Integer[] getIDs() {
        return (Integer[])worlds.keySet().toArray((Object[])new Integer[0]);
    }

    public static void setWorld(int id, @Nullable WorldServer world, MinecraftServer server) {
        if (world != null) {
            worlds.put(id, (Object)world);
            weakWorldMap.put(world, world);
            server.worldTickTimes.put(id, new long[100]);
            FMLLog.log.info("Loading dimension {} ({}) ({})", (Object)id, (Object)world.getWorldInfo().getWorldName(), (Object)world.getMinecraftServer());
        } else {
            worlds.remove(id);
            server.worldTickTimes.remove(id);
            FMLLog.log.info("Unloading dimension {}", (Object)id);
        }
        ArrayList<WorldServer> tmp = new ArrayList<WorldServer>();
        if (worlds.get(0) != null) {
            tmp.add((WorldServer)worlds.get(0));
        }
        if (worlds.get(-1) != null) {
            tmp.add((WorldServer)worlds.get(-1));
        }
        if (worlds.get(1) != null) {
            tmp.add((WorldServer)worlds.get(1));
        }
        for (Int2ObjectMap.Entry entry : worlds.int2ObjectEntrySet()) {
            int dim = entry.getIntKey();
            if (dim >= -1 && dim <= 1) continue;
            tmp.add((WorldServer)entry.getValue());
        }
        server.worlds = tmp.toArray(new WorldServer[0]);
    }

    public static void initDimension(int dim) {
        WorldServer overworld = DimensionManager.getWorld(0);
        if (overworld == null) {
            throw new RuntimeException("Cannot Hotload Dim: Overworld is not Loaded!");
        }
        try {
            DimensionManager.getProviderType(dim);
        }
        catch (Exception e) {
            FMLLog.log.error("Cannot Hotload Dim: {}", (Object)dim, (Object)e);
            return;
        }
        MinecraftServer mcServer = overworld.getMinecraftServer();
        ISaveHandler savehandler = overworld.getSaveHandler();
        WorldServer world = dim == 0 ? overworld : (WorldServer)new WorldServerMulti(mcServer, savehandler, dim, overworld, mcServer.profiler).init();
        world.addEventListener(new ServerWorldEventHandler(mcServer, world));
        MinecraftForge.EVENT_BUS.post(new WorldEvent.Load(world));
        if (!mcServer.isSinglePlayer()) {
            world.getWorldInfo().setGameType(mcServer.getGameType());
        }
        mcServer.setDifficultyForAllWorlds(mcServer.getDifficulty());
    }

    public static WorldServer getWorld(int id) {
        return DimensionManager.getWorld(id, false);
    }

    public static WorldServer getWorld(int id, boolean resetUnloadDelay) {
        if (resetUnloadDelay && unloadQueue.contains(id)) {
            ((Dimension)DimensionManager.dimensions.get((int)id)).ticksWaited = 0;
        }
        return (WorldServer)worlds.get(id);
    }

    public static WorldServer[] getWorlds() {
        return (WorldServer[])worlds.values().toArray((Object[])new WorldServer[0]);
    }

    public static Integer[] getStaticDimensionIDs() {
        return (Integer[])dimensions.keySet().toArray((Object[])new Integer[0]);
    }

    public static WorldProvider createProviderFor(int dim) {
        try {
            if (dimensions.containsKey(dim)) {
                WorldProvider ret = DimensionManager.getProviderType(dim).createDimension();
                ret.setDimension(dim);
                return ret;
            }
            throw new RuntimeException(String.format("No WorldProvider bound for dimension %d", dim));
        }
        catch (Exception e) {
            FMLLog.log.error("An error occurred trying to create an instance of WorldProvider {} ({})", (Object)dim, (Object)DimensionManager.getProviderType(dim), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean keepDimensionLoaded(int dim, boolean keep) {
        return keep ? keepLoaded.add(dim) : keepLoaded.remove(dim);
    }

    private static boolean canUnloadWorld(WorldServer world) {
        return ForgeChunkManager.getPersistentChunksFor(world).isEmpty() && world.playerEntities.isEmpty() && !world.provider.getDimensionType().shouldLoadSpawn() && !keepLoaded.contains(world.provider.getDimension());
    }

    public static void unloadWorld(int id) {
        WorldServer world = (WorldServer)worlds.get(id);
        if (world == null || !DimensionManager.canUnloadWorld(world)) {
            return;
        }
        if (unloadQueue.add(id)) {
            FMLLog.log.debug("Queueing dimension {} to unload", (Object)id);
        }
    }

    public static boolean isWorldQueuedToUnload(int id) {
        return unloadQueue.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(Hashtable<Integer, long[]> worldTickTimes) {
        IntIterator queueIterator = unloadQueue.iterator();
        while (queueIterator.hasNext()) {
            int id = queueIterator.nextInt();
            Dimension dimension = (Dimension)dimensions.get(id);
            if (dimension.ticksWaited < ForgeModContainer.dimensionUnloadQueueDelay) {
                ++dimension.ticksWaited;
                continue;
            }
            WorldServer w = (WorldServer)worlds.get(id);
            queueIterator.remove();
            dimension.ticksWaited = 0;
            if (w == null || !DimensionManager.canUnloadWorld(w)) {
                FMLLog.log.debug("Aborting unload for dimension {} as status changed", (Object)id);
                continue;
            }
            try {
                w.saveAllChunks(true, null);
            }
            catch (MinecraftException e) {
                FMLLog.log.error("Caught an exception while saving all chunks:", (Throwable)e);
            }
            finally {
                MinecraftForge.EVENT_BUS.post(new WorldEvent.Unload(w));
                w.flush();
                DimensionManager.setWorld(id, null, w.getMinecraftServer());
            }
        }
    }

    public static int getNextFreeDimId() {
        int next = lastUsedId;
        while (usedIds.contains(next) || !DimensionManager.checkAvailable(next)) {
            ++next;
        }
        lastUsedId = next;
        return lastUsedId;
    }

    private static boolean checkAvailable(int id) {
        if (dimensions.containsKey(id)) {
            usedIds.add(id);
            return false;
        }
        return true;
    }

    public static NBTTagCompound saveDimensionDataMap() {
        NBTTagCompound dimMap = new NBTTagCompound();
        dimMap.setIntArray("UsedIDs", usedIds.toIntArray());
        return dimMap;
    }

    public static void loadDimensionDataMap(@Nullable NBTTagCompound compoundTag) {
        usedIds.clear();
        lastUsedId = 0;
        if (compoundTag == null) {
            IntIterator iterator = dimensions.keySet().iterator();
            while (iterator.hasNext()) {
                int id = iterator.nextInt();
                if (id < 0) continue;
                usedIds.add(id);
            }
        } else {
            for (int id : compoundTag.getIntArray("UsedIDs")) {
                usedIds.add(id);
            }
            int[] intArray = compoundTag.getIntArray("DimensionArray");
            for (int i = 0; i < intArray.length; ++i) {
                int data = intArray[i];
                if (data == 0) continue;
                for (int j = 0; j < 32; ++j) {
                    if ((data & 1 << j) == 0) continue;
                    usedIds.add(i * 32 + j);
                }
            }
        }
    }

    @Nullable
    public static File getCurrentSaveRootDirectory() {
        if (DimensionManager.getWorld(0) != null) {
            return DimensionManager.getWorld(0).getSaveHandler().getWorldDirectory();
        }
        return null;
    }

    static {
        DimensionManager.init();
    }

    private static class Dimension {
        private final DimensionType type;
        private int ticksWaited;

        private Dimension(DimensionType type) {
            this.type = type;
            this.ticksWaited = 0;
        }
    }
}

