/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.common.ForgeModContainer;

public class ForgeBlockModelRenderer
extends BlockModelRenderer {
    private final ThreadLocal<VertexLighterFlat> lighterFlat;
    private final ThreadLocal<VertexLighterSmoothAo> lighterSmooth;
    private final ThreadLocal<VertexBufferConsumer> consumerFlat = ThreadLocal.withInitial(VertexBufferConsumer::new);
    private final ThreadLocal<VertexBufferConsumer> consumerSmooth = ThreadLocal.withInitial(VertexBufferConsumer::new);

    public ForgeBlockModelRenderer(BlockColors colors) {
        super(colors);
        this.lighterFlat = ThreadLocal.withInitial(() -> new VertexLighterFlat(colors));
        this.lighterSmooth = ThreadLocal.withInitial(() -> new VertexLighterSmoothAo(colors));
    }

    @Override
    public boolean renderModelFlat(IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long rand) {
        if (ForgeModContainer.forgeLightPipelineEnabled) {
            VertexBufferConsumer consumer = this.consumerFlat.get();
            consumer.setBuffer(buffer);
            consumer.setOffset(pos);
            VertexLighterFlat lighter = this.lighterFlat.get();
            lighter.setParent(consumer);
            return ForgeBlockModelRenderer.render(lighter, world, model, state, pos, buffer, checkSides, rand);
        }
        return super.renderModelFlat(world, model, state, pos, buffer, checkSides, rand);
    }

    @Override
    public boolean renderModelSmooth(IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder buffer, boolean checkSides, long rand) {
        if (ForgeModContainer.forgeLightPipelineEnabled) {
            VertexBufferConsumer consumer = this.consumerSmooth.get();
            consumer.setBuffer(buffer);
            consumer.setOffset(pos);
            VertexLighterSmoothAo lighter = this.lighterSmooth.get();
            lighter.setParent(consumer);
            return ForgeBlockModelRenderer.render(lighter, world, model, state, pos, buffer, checkSides, rand);
        }
        return super.renderModelSmooth(world, model, state, pos, buffer, checkSides, rand);
    }

    public static boolean render(VertexLighterFlat lighter, IBlockAccess world, IBakedModel model, IBlockState state, BlockPos pos, BufferBuilder wr, boolean checkSides, long rand) {
        lighter.setWorld(world);
        lighter.setState(state);
        lighter.setBlockPos(pos);
        boolean empty = true;
        List<BakedQuad> quads = model.getQuads(state, null, rand);
        if (!quads.isEmpty()) {
            lighter.updateBlockInfo();
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe(lighter);
            }
        }
        for (EnumFacing side : EnumFacing.values()) {
            quads = model.getQuads(state, side, rand);
            if (quads.isEmpty() || checkSides && !state.shouldSideBeRendered(world, pos, side)) continue;
            if (empty) {
                lighter.updateBlockInfo();
            }
            empty = false;
            for (BakedQuad quad : quads) {
                quad.pipe(lighter);
            }
        }
        lighter.resetBlockInfo();
        return !empty;
    }
}

