/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.animation.IEventHandler;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.animation.CapabilityAnimation;
import net.minecraftforge.common.model.animation.IAnimationStateMachine;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import org.apache.commons.lang3.tuple.Pair;

public class AnimationTESR<T extends TileEntity>
extends FastTESR<T>
implements IEventHandler<T> {
    protected static BlockRendererDispatcher blockRenderer;

    @Override
    public void renderTileEntityFast(T te, double x, double y, double z, float partialTick, int breakStage, float partial, BufferBuilder renderer) {
        IExtendedBlockState exState;
        if (!((TileEntity)((Object)te)).hasCapability(CapabilityAnimation.ANIMATION_CAPABILITY, null)) {
            return;
        }
        if (blockRenderer == null) {
            blockRenderer = Minecraft.getMinecraft().getBlockRendererDispatcher();
        }
        BlockPos pos = ((TileEntity)((Object)te)).getPos();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache(((TileEntity)((Object)te)).getWorld(), pos);
        IBlockState state = world.getBlockState(pos);
        if (state.getPropertyKeys().contains(Properties.StaticProperty)) {
            state = state.withProperty(Properties.StaticProperty, false);
        }
        if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty)) {
            float time = Animation.getWorldTime(this.getWorld(), partialTick);
            IAnimationStateMachine capability = ((TileEntity)((Object)te)).getCapability(CapabilityAnimation.ANIMATION_CAPABILITY, null);
            if (capability != null) {
                Pair<IModelState, Iterable<Event>> pair = capability.apply(time);
                this.handleEvents(te, time, (Iterable<Event>)((Iterable)pair.getRight()));
                IBakedModel model = blockRenderer.getBlockModelShapes().getModelForState(exState.getClean());
                exState = exState.withProperty(Properties.AnimationProperty, (IModelState)pair.getLeft());
                renderer.setTranslation(x - (double)pos.getX(), y - (double)pos.getY(), z - (double)pos.getZ());
                blockRenderer.getBlockModelRenderer().renderModel(world, model, exState, pos, renderer, false);
            }
        }
    }

    @Override
    public void handleEvents(T te, float time, Iterable<Event> pastEvents) {
    }
}

