/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.animation;

import java.lang.ref.WeakReference;
import net.minecraft.world.World;

public enum Animation {
    INSTANCE;

    private float clientPartialTickTime;
    private static long epochTime;
    private static WeakReference<World> worldRef;

    public static float getWorldTime(World world) {
        return Animation.getWorldTime(world, 0.0f);
    }

    public static float getWorldTime(World world, float tickProgress) {
        if (worldRef == null || worldRef.get() != world) {
            epochTime = world.getTotalWorldTime();
            worldRef = new WeakReference<World>(world);
        }
        return ((float)(world.getTotalWorldTime() - epochTime) + tickProgress) / 20.0f;
    }

    public static float getPartialTickTime() {
        return Animation.INSTANCE.clientPartialTickTime;
    }

    public static void setClientPartialTickTime(float clientPartialTickTime) {
        Animation.INSTANCE.clientPartialTickTime = clientPartialTickTime;
    }
}

