/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

@Deprecated
public final class MultiModel
implements IModel {
    private final ResourceLocation location;
    @Nullable
    private final IModel base;
    private final Map<String, Pair<IModel, IModelState>> parts;

    @Deprecated
    public MultiModel(ResourceLocation location, @Nullable IModel base, IModelState baseState, ImmutableMap<String, Pair<IModel, IModelState>> parts) {
        this(location, base, parts);
    }

    public MultiModel(ResourceLocation location, @Nullable IModel base, ImmutableMap<String, Pair<IModel, IModelState>> parts) {
        this.location = location;
        this.base = base;
        this.parts = parts;
    }

    @Deprecated
    public MultiModel(ResourceLocation location, IModel base, IModelState baseState, Map<String, Pair<IModel, IModelState>> parts) {
        this(location, base, parts);
    }

    public MultiModel(ResourceLocation location, IModel base, Map<String, Pair<IModel, IModelState>> parts) {
        this(location, base, (ImmutableMap<String, Pair<IModel, IModelState>>)ImmutableMap.copyOf(parts));
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.getDependencies());
        }
        for (Pair<IModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IModel)pair.getLeft()).getDependencies());
        }
        return deps;
    }

    @Override
    public Collection<ResourceLocation> getTextures() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.getTextures());
        }
        for (Pair<IModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IModel)pair.getLeft()).getTextures());
        }
        return deps;
    }

    @Override
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel bakedBase = null;
        if (this.base != null) {
            bakedBase = this.base.bake(state, format, bakedTextureGetter);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Pair<IModel, IModelState>> entry : this.parts.entrySet()) {
            Pair<IModel, IModelState> pair = entry.getValue();
            mapBuilder.put((Object)entry.getKey(), (Object)((IModel)pair.getLeft()).bake(new ModelStateComposition(state, (IModelState)pair.getRight()), format, bakedTextureGetter));
        }
        if (bakedBase == null && this.parts.isEmpty()) {
            FMLLog.log.error("MultiModel {} is empty (no base model or parts were provided/resolved)", (Object)this.location);
            IModel missing = ModelLoaderRegistry.getMissingModel();
            return missing.bake(missing.getDefaultState(), format, bakedTextureGetter);
        }
        return new Baked(this.location, true, bakedBase, (ImmutableMap<String, IBakedModel>)mapBuilder.build());
    }

    private static final class Baked
    implements IBakedModel {
        private final ResourceLocation location;
        @Nullable
        private final IBakedModel base;
        private final ImmutableMap<String, IBakedModel> parts;
        private final IBakedModel internalBase;
        private final ImmutableMap<ItemCameraTransforms.TransformType, Pair<Baked, TRSRTransformation>> transforms;
        private final ItemOverrideList overrides = new ItemOverrideList(Lists.newArrayList()){

            @Override
            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (originalModel != this) {
                    return originalModel;
                }
                boolean dirty = false;
                IBakedModel newBase = null;
                if (base != null && base != (newBase = base.getOverrides().handleItemState(base, stack, world, entity))) {
                    dirty = true;
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : parts.entrySet()) {
                    IBakedModel newPart = ((IBakedModel)entry.getValue()).getOverrides().handleItemState((IBakedModel)entry.getValue(), stack, world, entity);
                    builder.put((Object)((String)entry.getKey()), (Object)newPart);
                    if (entry.getValue() == newPart) continue;
                    dirty = true;
                }
                if (dirty) {
                    return new Baked(location, true, newBase, (ImmutableMap<String, IBakedModel>)builder.build());
                }
                return this;
            }
        };

        public Baked(ResourceLocation location, boolean perspective, @Nullable IBakedModel base, ImmutableMap<String, IBakedModel> parts) {
            this.location = location;
            this.base = base;
            this.parts = parts;
            if (base != null) {
                this.internalBase = base;
            } else {
                UnmodifiableIterator iter = parts.values().iterator();
                if (iter.hasNext()) {
                    this.internalBase = (IBakedModel)iter.next();
                } else {
                    throw new IllegalArgumentException("No base model or submodel provided for MultiModel.Baked " + String.valueOf(location) + ".");
                }
            }
            if (base != null && perspective) {
                EnumMap<ItemCameraTransforms.TransformType, Pair> map = new EnumMap<ItemCameraTransforms.TransformType, Pair>(ItemCameraTransforms.TransformType.class);
                for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                    Pair<? extends IBakedModel, Matrix4f> p = base.handlePerspective(type);
                    IBakedModel newBase = (IBakedModel)p.getLeft();
                    Matrix4f matrix = (Matrix4f)p.getRight();
                    if (newBase == base && matrix == null) continue;
                    map.put(type, Pair.of((Object)new Baked(location, false, newBase, parts), (Object)new TRSRTransformation(matrix)));
                }
                this.transforms = ImmutableMap.copyOf(map);
            } else {
                this.transforms = ImmutableMap.of();
            }
        }

        @Override
        public boolean isAmbientOcclusion() {
            return this.internalBase.isAmbientOcclusion();
        }

        @Override
        public boolean isAmbientOcclusion(IBlockState state) {
            return this.internalBase.isAmbientOcclusion(state);
        }

        @Override
        public boolean isGui3d() {
            return this.internalBase.isGui3d();
        }

        @Override
        public boolean isBuiltInRenderer() {
            return this.internalBase.isBuiltInRenderer();
        }

        @Override
        public TextureAtlasSprite getParticleTexture() {
            return this.internalBase.getParticleTexture();
        }

        @Override
        public ItemCameraTransforms getItemCameraTransforms() {
            return this.internalBase.getItemCameraTransforms();
        }

        @Override
        public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            ImmutableList.Builder quads = ImmutableList.builder();
            if (this.base != null) {
                quads.addAll(this.base.getQuads(state, side, rand));
            }
            for (IBakedModel bakedPart : this.parts.values()) {
                quads.addAll(bakedPart.getQuads(state, side, rand));
            }
            return quads.build();
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair p = (Pair)this.transforms.get((Object)cameraTransformType);
            if (p == null) {
                return Pair.of((Object)this, null);
            }
            return Pair.of((Object)((Baked)p.getLeft()), (Object)((TRSRTransformation)p.getRight()).getMatrix());
        }

        @Override
        public ItemOverrideList getOverrides() {
            return this.overrides;
        }
    }
}

