/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.BlockPartRotation;
import net.minecraft.client.renderer.block.model.BuiltInModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.MultipartBakedModel;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantList;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.block.model.multipart.Multipart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.client.renderer.block.statemap.BlockStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.FancyMissingModel;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiModelState;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.animation.AnimationItemOverrideList;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.Models;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.vector.Vector3f;

public final class ModelLoader
extends ModelBakery {
    private final Map<ModelResourceLocation, IModel> stateModels = Maps.newHashMap();
    private final Map<ModelResourceLocation, ModelBlockDefinition> multipartDefinitions = Maps.newHashMap();
    private final Map<ModelBlockDefinition, IModel> multipartModels = Maps.newHashMap();
    private final Set<ModelResourceLocation> missingVariants = Sets.newHashSet();
    private final Map<ResourceLocation, Exception> loadingExceptions = Maps.newHashMap();
    private IModel missingModel = null;
    private boolean isLoading = false;
    private final boolean enableVerboseMissingInfo = FMLLaunchHandler.isDeobfuscatedEnvironment() || Boolean.parseBoolean(System.getProperty("forge.verboseMissingModelLogging", "false"));
    private final int verboseMissingInfoCount = Integer.parseInt(System.getProperty("forge.verboseMissingModelLoggingCount", "5"));
    private static final Map<IRegistryDelegate<Block>, IStateMapper> customStateMappers = Maps.newHashMap();
    private static final Map<IRegistryDelegate<Item>, ItemMeshDefinition> customMeshDefinitions = Maps.newHashMap();
    private static final Map<Pair<IRegistryDelegate<Item>, Integer>, ModelResourceLocation> customModels = Maps.newHashMap();

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(IResourceManager manager, TextureMap map, BlockModelShapes shapes) {
        super(manager, map, shapes);
        VanillaLoader.INSTANCE.setLoader(this);
        VariantLoader.INSTANCE.setLoader(this);
        ModelLoaderRegistry.clearModelCache(manager);
    }

    @Override
    @Nonnull
    public IRegistry<ModelResourceLocation, IBakedModel> setupModelRegistry() {
        if (FMLClientHandler.instance().hasError()) {
            return this.bakedRegistry;
        }
        this.isLoading = true;
        this.loadBlocks();
        this.loadVariantItemModels();
        this.missingModel = ModelLoaderRegistry.getMissingModel();
        this.stateModels.put(MODEL_MISSING, this.missingModel);
        HashSet textures = Sets.newHashSet(ModelLoaderRegistry.getTextures());
        textures.remove(TextureMap.LOCATION_MISSING_TEXTURE);
        textures.addAll(LOCATIONS_BUILTIN_TEXTURES);
        this.textureMap.loadSprites(this.resourceManager, map -> textures.forEach(map::registerSprite));
        IBakedModel missingBaked = this.missingModel.bake(this.missingModel.getDefaultState(), DefaultVertexFormats.ITEM, DefaultTextureGetter.INSTANCE);
        HashMap bakedModels = Maps.newHashMap();
        HashMultimap models = HashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap(this.stateModels), (Multimap)models);
        ProgressManager.ProgressBar bakeBar = ProgressManager.push("ModelLoader: baking", models.keySet().size());
        for (IModel iModel : models.keySet()) {
            String modelLocations = "[" + Joiner.on((String)", ").join((Iterable)models.get((Object)iModel)) + "]";
            bakeBar.step(modelLocations);
            if (iModel == this.getMissingModel()) {
                bakedModels.put(iModel, missingBaked);
                continue;
            }
            try {
                bakedModels.put(iModel, iModel.bake(iModel.getDefaultState(), DefaultVertexFormats.ITEM, DefaultTextureGetter.INSTANCE));
            }
            catch (Exception e) {
                FMLLog.log.error("Exception baking model for location(s) {}:", (Object)modelLocations, (Object)e);
                bakedModels.put(iModel, missingBaked);
            }
        }
        ProgressManager.pop(bakeBar);
        for (Map.Entry entry : this.stateModels.entrySet()) {
            this.bakedRegistry.putObject((ModelResourceLocation)entry.getKey(), (IBakedModel)bakedModels.get(entry.getValue()));
        }
        return this.bakedRegistry;
    }

    @Override
    protected void loadVariantModels() {
    }

    @Override
    protected void loadMultipartVariantModels() {
    }

    @Override
    protected void loadBlocks() {
        List blocks = StreamSupport.stream(Block.REGISTRY.spliterator(), false).filter(block -> block.getRegistryName() != null).sorted(Comparator.comparing(b -> b.getRegistryName().toString())).collect(Collectors.toList());
        ProgressManager.ProgressBar blockBar = ProgressManager.push("ModelLoader: blocks", blocks.size());
        BlockStateMapper mapper = this.blockModelShapes.getBlockStateMapper();
        for (Block block2 : blocks) {
            blockBar.step(block2.getRegistryName().toString());
            for (ResourceLocation location : mapper.getBlockstateLocations(block2)) {
                this.loadBlock(mapper, block2, location);
            }
        }
        ProgressManager.pop(blockBar);
    }

    @Override
    protected void registerVariant(@Nullable ModelBlockDefinition definition, ModelResourceLocation location) {
        IModel model;
        try {
            model = ModelLoaderRegistry.getModel(location);
        }
        catch (Exception e) {
            this.storeException(location, e);
            model = ModelLoaderRegistry.getMissingModel(location, e);
        }
        this.stateModels.put(location, model);
    }

    @Override
    protected void registerMultipartVariant(ModelBlockDefinition definition, Collection<ModelResourceLocation> locations) {
        for (ModelResourceLocation location : locations) {
            this.multipartDefinitions.put(location, definition);
            this.registerVariant(null, location);
        }
    }

    private void storeException(ResourceLocation location, Exception exception) {
        this.loadingExceptions.put(location, exception);
    }

    @Override
    protected ModelBlockDefinition getModelBlockDefinition(ResourceLocation location) {
        try {
            return super.getModelBlockDefinition(location);
        }
        catch (Exception exception) {
            this.storeException(location, new Exception("Could not load model definition for variant " + String.valueOf(location), exception));
            return new ModelBlockDefinition(new ArrayList<ModelBlockDefinition>());
        }
    }

    @Override
    protected void loadItemModels() {
        this.registerVariantNames();
        List items = StreamSupport.stream(Item.REGISTRY.spliterator(), false).filter(item -> item.getRegistryName() != null).sorted(Comparator.comparing(i -> i.getRegistryName().toString())).collect(Collectors.toList());
        ProgressManager.ProgressBar itemBar = ProgressManager.push("ModelLoader: items", items.size());
        for (Item item2 : items) {
            itemBar.step(item2.getRegistryName().toString());
            for (String s : this.getVariantNames(item2)) {
                ResourceLocation file = this.getItemLocation(s);
                ModelResourceLocation memory = ModelLoader.getInventoryVariant(s);
                IModel model = ModelLoaderRegistry.getMissingModel();
                ItemLoadingException exception = null;
                try {
                    model = ModelLoaderRegistry.getModel(memory);
                }
                catch (Exception blockstateException) {
                    try {
                        model = ModelLoaderRegistry.getModel(file);
                        ModelLoaderRegistry.addAlias(memory, file);
                    }
                    catch (Exception normalException) {
                        exception = new ItemLoadingException("Could not load item model either from the normal location " + String.valueOf(file) + " or from the blockstate", normalException, blockstateException);
                    }
                }
                if (exception != null) {
                    this.storeException(memory, exception);
                    model = ModelLoaderRegistry.getMissingModel(memory, exception);
                }
                this.stateModels.put(memory, model);
            }
        }
        ProgressManager.pop(itemBar);
    }

    public static ModelResourceLocation getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new ModelResourceLocation(s);
        }
        return new ModelResourceLocation(s, "inventory");
    }

    @Override
    protected ResourceLocation getModelLocation(ResourceLocation model) {
        return new ResourceLocation(model.getNamespace(), model.getPath() + ".json");
    }

    protected IModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = VanillaLoader.INSTANCE.loadModel(new ResourceLocation(MODEL_MISSING.getNamespace(), MODEL_MISSING.getPath()));
            }
            catch (Exception e) {
                throw new RuntimeException("Missing the missing model, this should never happen");
            }
        }
        return this.missingModel;
    }

    public void onPostBakeEvent(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry) {
        if (!this.isLoading) {
            return;
        }
        IBakedModel missingModel = modelRegistry.getObject(MODEL_MISSING);
        HashMap modelErrors = Maps.newHashMap();
        HashSet printedBlockStateErrors = Sets.newHashSet();
        HashMultimap reverseBlockMap = null;
        HashMultimap reverseItemMap = HashMultimap.create();
        if (this.enableVerboseMissingInfo) {
            reverseBlockMap = HashMultimap.create();
            for (Map.Entry entry : this.blockModelShapes.getBlockStateMapper().putAllStateModelLocations().entrySet()) {
                reverseBlockMap.put((Object)((ModelResourceLocation)entry.getValue()), (Object)((IBlockState)entry.getKey()));
            }
            ForgeRegistries.ITEMS.forEach(arg_0 -> this.lambda$onPostBakeEvent$5((Multimap)reverseItemMap, arg_0));
        }
        for (Map.Entry<Object, Object> entry : this.loadingExceptions.entrySet()) {
            if (!(entry.getKey() instanceof ModelResourceLocation)) continue;
            ModelResourceLocation location = (ModelResourceLocation)entry.getKey();
            IBakedModel model = modelRegistry.getObject(location);
            if (model == null || model == missingModel || model instanceof FancyMissingModel.BakedModel) {
                int errorCount;
                String domain = ((ResourceLocation)entry.getKey()).getNamespace();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < this.verboseMissingInfoCount) {
                    String errorMsg = "Exception loading model for variant " + String.valueOf(entry.getKey());
                    if (this.enableVerboseMissingInfo) {
                        Collection items;
                        Collection blocks = reverseBlockMap.get((Object)location);
                        if (!blocks.isEmpty()) {
                            errorMsg = blocks.size() == 1 ? errorMsg + " for blockstate \"" + String.valueOf(blocks.iterator().next()) + "\"" : errorMsg + " for blockstates [\"" + Joiner.on((String)"\", \"").join((Iterable)blocks) + "\"]";
                        }
                        if (!(items = reverseItemMap.get((Object)location)).isEmpty()) {
                            if (!blocks.isEmpty()) {
                                errorMsg = errorMsg + " and";
                            }
                            errorMsg = items.size() == 1 ? errorMsg + " for item \"" + (String)items.iterator().next() + "\"" : errorMsg + " for items [\"" + Joiner.on((String)"\", \"").join((Iterable)items) + "\"]";
                        }
                    }
                    if (entry.getValue() instanceof ItemLoadingException) {
                        ItemLoadingException ex = (ItemLoadingException)entry.getValue();
                        FMLLog.log.error("{}, normal location exception: ", (Object)errorMsg, (Object)ex.normalException);
                        FMLLog.log.error("{}, blockstate location exception: ", (Object)errorMsg, (Object)ex.blockstateException);
                    } else {
                        FMLLog.log.error(errorMsg, (Throwable)entry.getValue());
                    }
                    ResourceLocation blockstateLocation = new ResourceLocation(location.getNamespace(), location.getPath());
                    if (this.loadingExceptions.containsKey(blockstateLocation) && !printedBlockStateErrors.contains(blockstateLocation)) {
                        FMLLog.log.error("Exception loading blockstate for the variant {}: ", (Object)location, (Object)this.loadingExceptions.get(blockstateLocation));
                        printedBlockStateErrors.add(blockstateLocation);
                    }
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.putObject(location, missingModel);
        }
        for (ModelResourceLocation modelResourceLocation : this.missingVariants) {
            IBakedModel model = modelRegistry.getObject(modelResourceLocation);
            if (model == null || model == missingModel) {
                int errorCount;
                String domain = modelResourceLocation.getNamespace();
                Integer errorCountBox = (Integer)modelErrors.get(domain);
                int n = errorCount = errorCountBox == null ? 0 : errorCountBox;
                if (++errorCount < this.verboseMissingInfoCount) {
                    FMLLog.log.fatal("Model definition for location {} not found", (Object)modelResourceLocation);
                }
                modelErrors.put(domain, errorCount);
            }
            if (model != null) continue;
            modelRegistry.putObject(modelResourceLocation, missingModel);
        }
        for (Map.Entry entry : modelErrors.entrySet()) {
            if ((Integer)entry.getValue() < this.verboseMissingInfoCount) continue;
            FMLLog.log.fatal("Suppressed additional {} model loading errors for domain {}", (Object)((Integer)entry.getValue() - this.verboseMissingInfoCount), entry.getKey());
        }
        this.loadingExceptions.clear();
        this.missingVariants.clear();
        this.isLoading = false;
    }

    public static void setCustomStateMapper(Block block, IStateMapper mapper) {
        customStateMappers.put(block.delegate, mapper);
    }

    public static void onRegisterAllBlocks(BlockModelShapes shapes) {
        for (Map.Entry<IRegistryDelegate<Block>, IStateMapper> e : customStateMappers.entrySet()) {
            shapes.registerBlockWithStateMapper(e.getKey().get(), e.getValue());
        }
    }

    public static void setCustomModelResourceLocation(Item item, int metadata, ModelResourceLocation model) {
        customModels.put((Pair<IRegistryDelegate<Item>, Integer>)Pair.of((Object)item.delegate, (Object)metadata), model);
        ModelBakery.registerItemVariants(item, model);
    }

    public static void setCustomMeshDefinition(Item item, ItemMeshDefinition meshDefinition) {
        customMeshDefinitions.put(item.delegate, meshDefinition);
    }

    public static void setBucketModelDefinition(Item item) {
        ModelLoader.setCustomMeshDefinition(item, stack -> ModelDynBucket.LOCATION);
        ModelBakery.registerItemVariants(item, ModelDynBucket.LOCATION);
    }

    public static void onRegisterItems(ItemModelMesher mesher) {
        for (Map.Entry<IRegistryDelegate<Item>, ItemMeshDefinition> entry : customMeshDefinitions.entrySet()) {
            mesher.register(entry.getKey().get(), entry.getValue());
        }
        for (Map.Entry<IRegistryDelegate<Item>, Object> entry : customModels.entrySet()) {
            mesher.register((Item)((IRegistryDelegate)((Pair)entry.getKey()).getLeft()).get(), (Integer)((Pair)entry.getKey()).getRight(), (ModelResourceLocation)entry.getValue());
        }
    }

    public static Function<ResourceLocation, TextureAtlasSprite> defaultTextureGetter() {
        return DefaultTextureGetter.INSTANCE;
    }

    private /* synthetic */ void lambda$onPostBakeEvent$5(Multimap reverseItemMap, Item item) {
        for (String s : this.getVariantNames(item)) {
            ModelResourceLocation memory = ModelLoader.getInventoryVariant(s);
            reverseItemMap.put((Object)memory, (Object)item.getRegistryName().toString());
        }
    }

    protected static enum VanillaLoader implements ICustomModelLoader
    {
        INSTANCE;

        @Nullable
        private ModelLoader loader;
        private LoadingCache<BakedModelCacheKey, IBakedModel> modelCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(100L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<BakedModelCacheKey, IBakedModel>(this){

            public IBakedModel load(BakedModelCacheKey key) throws Exception {
                return key.model.bakeImpl(key.state, key.format, key.bakedTextureGetter);
            }
        });

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        @Nullable
        ModelLoader getLoader() {
            return this.loader;
        }

        @Override
        public void onResourceManagerReload(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return true;
        }

        @Override
        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            if (modelLocation.equals(ModelBakery.MODEL_MISSING) && this.loader.missingModel != null) {
                return this.loader.getMissingModel();
            }
            String modelPath = modelLocation.getPath();
            if (modelLocation.getPath().startsWith("models/")) {
                modelPath = modelPath.substring("models/".length());
            }
            ResourceLocation armatureLocation = new ResourceLocation(modelLocation.getNamespace(), "armatures/" + modelPath + ".json");
            ModelBlockAnimation animation = ModelBlockAnimation.loadVanillaAnimation(this.loader.resourceManager, armatureLocation);
            ModelBlock model = this.loader.loadModel(modelLocation);
            ModelLoader modelLoader = this.loader;
            Objects.requireNonNull(modelLoader);
            VanillaModelWrapper iModel = modelLoader.new VanillaModelWrapper(modelLocation, model, false, animation);
            if (this.loader.missingModel == null && modelLocation.equals(ModelBakery.MODEL_MISSING)) {
                this.loader.missingModel = iModel;
            }
            return iModel;
        }

        public String toString() {
            return "VanillaLoader.INSTANCE";
        }
    }

    protected static enum VariantLoader implements ICustomModelLoader
    {
        INSTANCE;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        @Override
        public void onResourceManagerReload(IResourceManager resourceManager) {
        }

        @Override
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation instanceof ModelResourceLocation;
        }

        @Override
        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            ModelResourceLocation variant = (ModelResourceLocation)modelLocation;
            ModelBlockDefinition definition = this.loader.getModelBlockDefinition(variant);
            try {
                VariantList variants = definition.getVariant(variant.getVariant());
                return new WeightedRandomModel(variant, variants);
            }
            catch (ModelBlockDefinition.MissingVariantException e) {
                if (definition.equals(this.loader.multipartDefinitions.get(variant))) {
                    IModel model = this.loader.multipartModels.get(definition);
                    if (model == null) {
                        model = new MultipartModel(new ResourceLocation(variant.getNamespace(), variant.getPath()), definition.getMultipartData());
                        this.loader.multipartModels.put(definition, model);
                    }
                    return model;
                }
                throw e;
            }
        }

        public String toString() {
            return "VariantLoader.INSTANCE";
        }
    }

    private static enum DefaultTextureGetter implements Function<ResourceLocation, TextureAtlasSprite>
    {
        INSTANCE;


        @Override
        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(location.toString());
        }
    }

    private static class ItemLoadingException
    extends ModelLoaderRegistry.LoaderException {
        private final Exception normalException;
        private final Exception blockstateException;

        public ItemLoadingException(String message, Exception normalException, Exception blockstateException) {
            super(message);
            this.normalException = normalException;
            this.blockstateException = blockstateException;
        }
    }

    private static class MultipartModel
    implements IModel {
        private final ResourceLocation location;
        private final Multipart multipart;
        private final ImmutableMap<Selector, IModel> partModels;

        public MultipartModel(ResourceLocation location, Multipart multipart) throws Exception {
            this.location = location;
            this.multipart = multipart;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Selector selector : multipart.getSelectors()) {
                builder.put((Object)selector, (Object)new WeightedRandomModel(location, selector.getVariantList()));
            }
            this.partModels = builder.build();
        }

        private MultipartModel(ResourceLocation location, Multipart multipart, ImmutableMap<Selector, IModel> partModels) {
            this.location = location;
            this.multipart = multipart;
            this.partModels = partModels;
        }

        @Override
        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            MultipartBakedModel.Builder builder = new MultipartBakedModel.Builder();
            for (Selector selector : this.multipart.getSelectors()) {
                builder.putModel(selector.getPredicate(this.multipart.getStateContainer()), ((IModel)this.partModels.get((Object)selector)).bake(((IModel)this.partModels.get((Object)selector)).getDefaultState(), format, bakedTextureGetter));
            }
            IBakedModel bakedModel = builder.makeMultipartModel();
            return bakedModel;
        }

        @Override
        public IModel retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry partModel : this.partModels.entrySet()) {
                builder.put((Object)((Selector)partModel.getKey()), (Object)((IModel)partModel.getValue()).retexture(textures));
            }
            return new MultipartModel(this.location, this.multipart, (ImmutableMap<Selector, IModel>)builder.build());
        }
    }

    public static final class White
    extends TextureAtlasSprite {
        public static final ResourceLocation LOCATION = new ResourceLocation("white");
        public static final White INSTANCE = new White();

        private White() {
            super(LOCATION.toString());
            this.height = 16;
            this.width = 16;
        }

        @Override
        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        @Override
        public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, this.getIconWidth(), this.getIconHeight());
            int[][] pixels = new int[Minecraft.getMinecraft().gameSettings.mipmapLevels + 1][];
            pixels[0] = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels[0], 0, image.getWidth());
            this.clearFramesTextureData();
            this.framesTextureData.add(pixels);
            return false;
        }

        public void register(TextureMap map) {
            map.setTextureEntry(INSTANCE);
        }
    }

    protected final class BakedModelCacheKey {
        private final VanillaModelWrapper model;
        private final IModelState state;
        private final VertexFormat format;
        private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;

        public BakedModelCacheKey(ModelLoader this$0, VanillaModelWrapper model, IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            this.model = model;
            this.state = state;
            this.format = format;
            this.bakedTextureGetter = bakedTextureGetter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BakedModelCacheKey that = (BakedModelCacheKey)o;
            return com.google.common.base.Objects.equal((Object)this.model, (Object)that.model) && com.google.common.base.Objects.equal((Object)this.state, (Object)that.state) && com.google.common.base.Objects.equal((Object)this.format, (Object)that.format) && com.google.common.base.Objects.equal(this.bakedTextureGetter, that.bakedTextureGetter);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.model, this.state, this.format, this.bakedTextureGetter});
        }
    }

    private static final class WeightedRandomModel
    implements IModel {
        private final List<Variant> variants;
        private final List<ResourceLocation> locations;
        private final Set<ResourceLocation> textures;
        private final List<IModel> models;
        private final IModelState defaultState;

        public WeightedRandomModel(ResourceLocation parent, VariantList variants) throws Exception {
            this.variants = variants.getVariantList();
            this.locations = new ArrayList<ResourceLocation>();
            this.textures = Sets.newHashSet();
            this.models = new ArrayList<IModel>();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Variant v : this.variants) {
                ResourceLocation loc = v.getModelLocation();
                this.locations.add(loc);
                IModel model = loc.equals(ModelBakery.MODEL_MISSING) ? ModelLoaderRegistry.getMissingModel() : ModelLoaderRegistry.getModel(loc);
                model = v.process(model);
                for (ResourceLocation location : model.getDependencies()) {
                    ModelLoaderRegistry.getModelOrMissing(location);
                }
                this.textures.addAll(model.getTextures());
                this.models.add(model);
                IModelState modelDefaultState = model.getDefaultState();
                Preconditions.checkNotNull((Object)modelDefaultState, (String)"Model %s returned null as default state", (Object)loc);
                builder.add((Object)Pair.of((Object)model, (Object)new ModelStateComposition(v.getState(), modelDefaultState)));
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoaderRegistry.getMissingModel();
                this.models.add(missing);
                builder.add((Object)Pair.of((Object)missing, (Object)TRSRTransformation.identity()));
            }
            this.defaultState = new MultiModelState(builder.build());
        }

        private WeightedRandomModel(List<Variant> variants, List<ResourceLocation> locations, Set<ResourceLocation> textures, List<IModel> models, IModelState defaultState) {
            this.variants = variants;
            this.locations = locations;
            this.textures = textures;
            this.models = models;
            this.defaultState = defaultState;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        @Override
        public Collection<ResourceLocation> getTextures() {
            return ImmutableSet.copyOf(this.textures);
        }

        @Override
        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + String.valueOf(format));
            }
            if (this.variants.size() == 1) {
                IModel model = this.models.get(0);
                return model.bake(MultiModelState.getPartState(state, model, 0), format, bakedTextureGetter);
            }
            WeightedBakedModel.Builder builder = new WeightedBakedModel.Builder();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel model = this.models.get(i);
                builder.add(model.bake(MultiModelState.getPartState(state, model, i), format, bakedTextureGetter), this.variants.get(i).getWeight());
            }
            return builder.build();
        }

        @Override
        public IModelState getDefaultState() {
            return this.defaultState;
        }

        @Override
        public WeightedRandomModel retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            HashSet modelTextures = Sets.newHashSet();
            ImmutableList.Builder builder = ImmutableList.builder();
            ArrayList retexturedModels = Lists.newArrayList();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel retextured = this.models.get(i).retexture(textures);
                modelTextures.addAll(retextured.getTextures());
                retexturedModels.add(retextured);
                builder.add((Object)Pair.of((Object)retextured, (Object)this.variants.get(i).getState()));
            }
            return new WeightedRandomModel(this.variants, this.locations, modelTextures, retexturedModels, new MultiModelState(builder.build()));
        }
    }

    private final class VanillaModelWrapper
    implements IModel {
        private final ResourceLocation location;
        private final ModelBlock model;
        private final boolean uvlock;
        private final ModelBlockAnimation animation;

        public VanillaModelWrapper(ResourceLocation location, ModelBlock model, boolean uvlock, ModelBlockAnimation animation) {
            this.location = location;
            this.model = model;
            this.uvlock = uvlock;
            this.animation = animation;
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            HashSet set = Sets.newHashSet();
            for (ResourceLocation dep : this.model.getOverrideLocations()) {
                if (this.location.equals(dep)) continue;
                set.add(dep);
                ModelLoader.this.stateModels.put(ModelLoader.getInventoryVariant(dep.toString()), ModelLoaderRegistry.getModelOrLogError(dep, "Could not load override model " + String.valueOf(dep) + " for model " + String.valueOf(this.location)));
            }
            if (this.model.getParentLocation() != null && !this.model.getParentLocation().getPath().startsWith("builtin/")) {
                set.add(this.model.getParentLocation());
            }
            return ImmutableSet.copyOf((Collection)set);
        }

        @Override
        public Collection<ResourceLocation> getTextures() {
            ResourceLocation parentLocation = this.model.getParentLocation();
            if (parentLocation != null && this.model.parent == null) {
                this.model.parent = parentLocation.getPath().equals("builtin/generated") ? MODEL_GENERATED : ModelLoaderRegistry.getModelOrLogError(parentLocation, "Could not load vanilla model parent '" + String.valueOf(parentLocation) + "' for '" + String.valueOf(this.model) + "'").asVanillaModel().orElseThrow(() -> new IllegalStateException("vanilla model '" + String.valueOf(this.model) + "' can't have non-vanilla parent"));
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ModelLoader.this.hasItemModel(this.model)) {
                for (String s : ItemModelGenerator.LAYERS) {
                    String r = this.model.resolveTextureName(s);
                    ResourceLocation loc = new ResourceLocation(r);
                    if (r.equals(s)) continue;
                    builder.add((Object)loc);
                }
            }
            for (String s : this.model.textures.values()) {
                if (s.startsWith("#")) continue;
                builder.add((Object)new ResourceLocation(s));
            }
            return builder.build();
        }

        @Override
        public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            return (IBakedModel)VanillaLoader.INSTANCE.modelCache.getUnchecked((Object)new BakedModelCacheKey(ModelLoader.this, this, state, format, bakedTextureGetter));
        }

        public IBakedModel bakeImpl(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + String.valueOf(format));
            }
            ModelBlock model = this.model;
            if (model == null) {
                return ModelLoader.this.getMissingModel().bake(ModelLoader.this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
            }
            ArrayList newTransforms = Lists.newArrayList();
            for (int i = 0; i < model.getElements().size(); ++i) {
                BlockPart part = model.getElements().get(i);
                newTransforms.add(this.animation.getPartTransform(state, part, i));
            }
            ItemCameraTransforms transforms = model.getAllTransforms();
            EnumMap tMap = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
            tMap.putAll(PerspectiveMapWrapper.getTransforms(transforms));
            tMap.putAll(PerspectiveMapWrapper.getTransforms(state));
            SimpleModelState perState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf((Map)tMap), state.apply(Optional.empty()));
            if (ModelLoader.this.hasItemModel(model)) {
                return new ItemLayerModel(model).bake(perState, format, bakedTextureGetter);
            }
            if (ModelLoader.this.isCustomRenderer(model)) {
                return new BuiltInModel(transforms, model.createOverrides());
            }
            return this.bakeNormal(model, perState, state, newTransforms, format, bakedTextureGetter, this.uvlock);
        }

        private IBakedModel bakeNormal(ModelBlock model, IModelState perState, final IModelState modelState, List<TRSRTransformation> newTransforms, final VertexFormat format, final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, boolean uvLocked) {
            TRSRTransformation baseState = modelState.apply(Optional.empty()).orElse(TRSRTransformation.identity());
            TextureAtlasSprite particle = bakedTextureGetter.apply(new ResourceLocation(model.resolveTextureName("particle")));
            SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, model.createOverrides()).setTexture(particle);
            for (int i = 0; i < model.getElements().size(); ++i) {
                if (modelState.apply(Optional.of(Models.getHiddenModelPart((ImmutableList<String>)ImmutableList.of((Object)Integer.toString(i))))).isPresent()) continue;
                BlockPart part = model.getElements().get(i);
                TRSRTransformation transformation = baseState;
                if (newTransforms.get(i) != null) {
                    transformation = transformation.compose(newTransforms.get(i));
                    BlockPartRotation rot = part.partRotation;
                    if (rot == null) {
                        rot = new BlockPartRotation(new Vector3f(), EnumFacing.Axis.Y, 0.0f, false);
                    }
                    part = new BlockPart(part.positionFrom, part.positionTo, part.mapFaces, rot, part.shade);
                }
                for (Map.Entry<EnumFacing, BlockPartFace> e : part.mapFaces.entrySet()) {
                    TextureAtlasSprite textureatlassprite1 = bakedTextureGetter.apply(new ResourceLocation(model.resolveTextureName(e.getValue().texture)));
                    if (e.getValue().cullFace == null || !TRSRTransformation.isInteger(transformation.getMatrix())) {
                        builder.addGeneralQuad(ModelLoader.this.makeBakedQuad(part, e.getValue(), textureatlassprite1, e.getKey(), transformation, uvLocked));
                        continue;
                    }
                    builder.addFaceQuad(baseState.rotate(e.getValue().cullFace), ModelLoader.this.makeBakedQuad(part, e.getValue(), textureatlassprite1, e.getKey(), transformation, uvLocked));
                }
            }
            return new PerspectiveMapWrapper(builder.makeBakedModel(), perState){
                private final ItemOverrideList overrides;
                {
                    super(parent, state);
                    this.overrides = new AnimationItemOverrideList((IModel)VanillaModelWrapper.this, modelState, format, (Function<ResourceLocation, TextureAtlasSprite>)bakedTextureGetter, super.getOverrides());
                }

                @Override
                public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
                    IExtendedBlockState exState;
                    if (state instanceof IExtendedBlockState && (exState = (IExtendedBlockState)state).getUnlistedNames().contains(Properties.AnimationProperty)) {
                        IModelState newState = exState.getValue(Properties.AnimationProperty);
                        IExtendedBlockState newExState = exState.withProperty(Properties.AnimationProperty, null);
                        if (newState != null) {
                            return VanillaModelWrapper.this.bake(new ModelStateComposition(modelState, newState), format, bakedTextureGetter).getQuads(newExState, side, rand);
                        }
                    }
                    return super.getQuads(state, side, rand);
                }

                @Override
                public ItemOverrideList getOverrides() {
                    return this.overrides;
                }
            };
        }

        @Override
        public VanillaModelWrapper retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ArrayList elements = Lists.newArrayList();
            for (BlockPart part : this.model.getElements()) {
                elements.add(new BlockPart(part.positionFrom, part.positionTo, Maps.newHashMap(part.mapFaces), part.partRotation, part.shade));
            }
            ModelBlock newModel = new ModelBlock(this.model.getParentLocation(), elements, Maps.newHashMap(this.model.textures), this.model.isAmbientOcclusion(), this.model.isGui3d(), this.model.getAllTransforms(), Lists.newArrayList(this.model.getOverrides()));
            newModel.name = this.model.name;
            newModel.parent = this.model.parent;
            HashSet removed = Sets.newHashSet();
            for (Map.Entry e : textures.entrySet()) {
                if ("".equals(e.getValue())) {
                    removed.add((String)e.getKey());
                    newModel.textures.remove(e.getKey());
                    continue;
                }
                newModel.textures.put((String)e.getKey(), (String)e.getValue());
            }
            HashMap remapped = Maps.newHashMap();
            for (Map.Entry<String, String> e : newModel.textures.entrySet()) {
                String key;
                if (!e.getValue().startsWith("#") || !newModel.textures.containsKey(key = e.getValue().substring(1))) continue;
                remapped.put(e.getKey(), newModel.textures.get(key));
            }
            newModel.textures.putAll(remapped);
            for (BlockPart part : newModel.getElements()) {
                part.mapFaces.entrySet().removeIf(entry -> removed.contains(((BlockPartFace)entry.getValue()).texture));
            }
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public Optional<? extends IClip> getClip(String name) {
            if (this.animation.getClips().containsKey((Object)name)) {
                return Optional.ofNullable((IClip)this.animation.getClips().get((Object)name));
            }
            return Optional.empty();
        }

        @Override
        public VanillaModelWrapper smoothLighting(boolean value) {
            if (this.model.ambientOcclusion == value) {
                return this;
            }
            ModelBlock newModel = new ModelBlock(this.model.getParentLocation(), this.model.getElements(), this.model.textures, value, this.model.isGui3d(), this.model.getAllTransforms(), Lists.newArrayList(this.model.getOverrides()));
            newModel.parent = this.model.parent;
            newModel.name = this.model.name;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public VanillaModelWrapper gui3d(boolean value) {
            if (this.model.isGui3d() == value) {
                return this;
            }
            ModelBlock newModel = new ModelBlock(this.model.getParentLocation(), this.model.getElements(), this.model.textures, this.model.ambientOcclusion, value, this.model.getAllTransforms(), Lists.newArrayList(this.model.getOverrides()));
            newModel.parent = this.model.parent;
            newModel.name = this.model.name;
            return new VanillaModelWrapper(this.location, newModel, this.uvlock, this.animation);
        }

        @Override
        public IModel uvlock(boolean value) {
            if (this.uvlock == value) {
                return this;
            }
            return new VanillaModelWrapper(this.location, this.model, value, this.animation);
        }

        @Override
        public Optional<ModelBlock> asVanillaModel() {
            return Optional.of(this.model);
        }
    }
}

