/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BlockStateLoader;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;

public class ForgeBlockStateV1
extends BlockStateLoader.Marker {
    Variant defaults;
    Multimap<String, Variant> variants = LinkedHashMultimap.create();

    public static class Transforms {
        private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
        private static final ImmutableMap<String, IModelState> transforms;

        public static TRSRTransformation convert(float tx, float ty, float tz, float ax, float ay, float az, float s) {
            return Transforms.convert(tx, ty, tz, ax, ay, az, s, s, s);
        }

        public static TRSRTransformation convert(float tx, float ty, float tz, float ax, float ay, float az, float sx, float sy, float sz) {
            return TRSRTransformation.blockCenterToCorner(new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees(new Vector3f(ax, ay, az)), new Vector3f(sx, sy, sz), null));
        }

        public static TRSRTransformation leftify(TRSRTransformation transform) {
            return TRSRTransformation.blockCenterToCorner(flipX.compose(TRSRTransformation.blockCornerToCenter(transform)).compose(flipX));
        }

        public static Optional<IModelState> get(String name) {
            return Optional.ofNullable((IModelState)transforms.get((Object)name));
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"identity", (Object)TRSRTransformation.identity());
            EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> block = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
            TRSRTransformation thirdPersonBlock = Transforms.convert(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
            block.put(ItemCameraTransforms.TransformType.GUI, Transforms.convert(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
            block.put(ItemCameraTransforms.TransformType.GROUND, Transforms.convert(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
            block.put(ItemCameraTransforms.TransformType.FIXED, Transforms.convert(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
            block.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPersonBlock);
            block.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, Transforms.leftify(thirdPersonBlock));
            block.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, Transforms.convert(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
            block.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, Transforms.convert(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
            builder.put((Object)"forge:default-block", (Object)new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf(block)));
            EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> item = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
            TRSRTransformation thirdPersonItem = Transforms.convert(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
            TRSRTransformation firstPersonItem = Transforms.convert(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
            item.put(ItemCameraTransforms.TransformType.GROUND, Transforms.convert(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
            item.put(ItemCameraTransforms.TransformType.HEAD, Transforms.convert(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            item.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPersonItem);
            item.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, Transforms.leftify(thirdPersonItem));
            item.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, firstPersonItem);
            item.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, Transforms.leftify(firstPersonItem));
            item.put(ItemCameraTransforms.TransformType.FIXED, Transforms.convert(0.0f, 0.0f, 0.0f, 0.0f, 180.0f, 0.0f, 1.0f));
            builder.put((Object)"forge:default-item", (Object)new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf(item)));
            EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation> tool = new EnumMap<ItemCameraTransforms.TransformType, TRSRTransformation>(ItemCameraTransforms.TransformType.class);
            tool.putAll(item);
            tool.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, Transforms.convert(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
            tool.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, Transforms.convert(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
            tool.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, Transforms.convert(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
            tool.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, Transforms.convert(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
            builder.put((Object)"forge:default-tool", (Object)new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf(tool)));
            transforms = builder.build();
        }
    }

    public static class TRSRDeserializer
    implements JsonDeserializer<TRSRTransformation> {
        public static final TRSRDeserializer INSTANCE = new TRSRDeserializer();

        public TRSRTransformation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                String transform = json.getAsString();
                if (transform.equals("identity")) {
                    return TRSRTransformation.identity();
                }
                throw new JsonParseException("TRSR: unknown default string: " + transform);
            }
            if (json.isJsonArray()) {
                return new TRSRTransformation(TRSRDeserializer.parseMatrix(json));
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("TRSR: expected array or object, got: " + String.valueOf(json));
            }
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("matrix")) {
                TRSRTransformation ret = new TRSRTransformation(TRSRDeserializer.parseMatrix(obj.get("matrix")));
                obj.remove("matrix");
                if (obj.entrySet().size() != 0) {
                    throw new JsonParseException("TRSR: can't combine matrix and other keys");
                }
                return ret;
            }
            Vector3f translation = null;
            Quat4f leftRot = null;
            Vector3f scale = null;
            Quat4f rightRot = null;
            if (obj.has("translation")) {
                translation = new Vector3f(TRSRDeserializer.parseFloatArray(obj.get("translation"), 3, "Translation"));
                obj.remove("translation");
            }
            if (obj.has("rotation")) {
                leftRot = TRSRDeserializer.parseRotation(obj.get("rotation"));
                obj.remove("rotation");
            }
            if (obj.has("scale")) {
                if (!obj.get("scale").isJsonArray()) {
                    try {
                        float s = obj.get("scale").getAsNumber().floatValue();
                        scale = new Vector3f(s, s, s);
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("TRSR scale: expected number or array, got: " + String.valueOf(obj.get("scale")));
                    }
                } else {
                    scale = new Vector3f(TRSRDeserializer.parseFloatArray(obj.get("scale"), 3, "Scale"));
                }
                obj.remove("scale");
            }
            if (obj.has("post-rotation")) {
                rightRot = TRSRDeserializer.parseRotation(obj.get("post-rotation"));
                obj.remove("post-rotation");
            }
            if (!obj.entrySet().isEmpty()) {
                throw new JsonParseException("TRSR: can either have single 'matrix' key, or a combination of 'translation', 'rotation', 'scale', 'post-rotation'");
            }
            return new TRSRTransformation(translation, leftRot, scale, rightRot);
        }

        public static Matrix4f parseMatrix(JsonElement e) {
            if (!e.isJsonArray()) {
                throw new JsonParseException("Matrix: expected an array, got: " + String.valueOf(e));
            }
            JsonArray m = e.getAsJsonArray();
            if (m.size() != 3) {
                throw new JsonParseException("Matrix: expected an array of length 3, got: " + m.size());
            }
            Matrix4f ret = new Matrix4f();
            for (int i = 0; i < 3; ++i) {
                if (!m.get(i).isJsonArray()) {
                    throw new JsonParseException("Matrix row: expected an array, got: " + String.valueOf(m.get(i)));
                }
                JsonArray r = m.get(i).getAsJsonArray();
                if (r.size() != 4) {
                    throw new JsonParseException("Matrix row: expected an array of length 4, got: " + r.size());
                }
                for (int j = 0; j < 4; ++j) {
                    try {
                        ret.setElement(i, j, r.get(j).getAsNumber().floatValue());
                        continue;
                    }
                    catch (ClassCastException ex) {
                        throw new JsonParseException("Matrix element: expected number, got: " + String.valueOf(r.get(j)));
                    }
                }
            }
            return ret;
        }

        public static float[] parseFloatArray(JsonElement e, int length, String prefix) {
            if (!e.isJsonArray()) {
                throw new JsonParseException(prefix + ": expected an array, got: " + String.valueOf(e));
            }
            JsonArray t = e.getAsJsonArray();
            if (t.size() != length) {
                throw new JsonParseException(prefix + ": expected an array of length " + length + ", got: " + t.size());
            }
            float[] ret = new float[length];
            for (int i = 0; i < length; ++i) {
                try {
                    ret[i] = t.get(i).getAsNumber().floatValue();
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException(prefix + " element: expected number, got: " + String.valueOf(t.get(i)));
                }
            }
            return ret;
        }

        public static Quat4f parseAxisRotation(JsonElement e) {
            Quat4f ret;
            block7: {
                if (!e.isJsonObject()) {
                    throw new JsonParseException("Axis rotation: object expected, got: " + String.valueOf(e));
                }
                JsonObject obj = e.getAsJsonObject();
                if (obj.entrySet().size() != 1) {
                    throw new JsonParseException("Axis rotation: expected single axis object, got: " + String.valueOf(e));
                }
                Map.Entry entry = (Map.Entry)obj.entrySet().iterator().next();
                ret = new Quat4f();
                try {
                    if (((String)entry.getKey()).equals("x")) {
                        ret.set(new AxisAngle4d(1.0, 0.0, 0.0, Math.toRadians(((JsonElement)entry.getValue()).getAsNumber().floatValue())));
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("y")) {
                        ret.set(new AxisAngle4d(0.0, 1.0, 0.0, Math.toRadians(((JsonElement)entry.getValue()).getAsNumber().floatValue())));
                        break block7;
                    }
                    if (((String)entry.getKey()).equals("z")) {
                        ret.set(new AxisAngle4d(0.0, 0.0, 1.0, Math.toRadians(((JsonElement)entry.getValue()).getAsNumber().floatValue())));
                        break block7;
                    }
                    throw new JsonParseException("Axis rotation: expected single axis key, got: " + (String)entry.getKey());
                }
                catch (ClassCastException ex) {
                    throw new JsonParseException("Axis rotation value: expected number, got: " + String.valueOf(entry.getValue()));
                }
            }
            return ret;
        }

        public static Quat4f parseRotation(JsonElement e) {
            if (e.isJsonArray()) {
                if (e.getAsJsonArray().get(0).isJsonObject()) {
                    Quat4f ret = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
                    for (JsonElement a : e.getAsJsonArray()) {
                        ret.mul(TRSRDeserializer.parseAxisRotation(a));
                    }
                    return ret;
                }
                if (e.isJsonArray()) {
                    JsonArray array = e.getAsJsonArray();
                    if (array.size() == 3) {
                        return TRSRTransformation.quatFromXYZDegrees(new Vector3f(TRSRDeserializer.parseFloatArray(e, 3, "Rotation")));
                    }
                    return new Quat4f(TRSRDeserializer.parseFloatArray(e, 4, "Rotation"));
                }
                throw new JsonParseException("Rotation: expected array or object, got: " + String.valueOf(e));
            }
            if (e.isJsonObject()) {
                return TRSRDeserializer.parseAxisRotation(e);
            }
            throw new JsonParseException("Rotation: expected array or object, got: " + String.valueOf(e));
        }
    }

    public static class Variant {
        public static final Object SET_VALUE = new Object();
        @Nullable
        private ResourceLocation model = null;
        private boolean modelSet = false;
        private Optional<IModelState> state = Optional.empty();
        private Optional<Boolean> uvLock = Optional.empty();
        private Optional<Boolean> smooth = Optional.empty();
        private Optional<Boolean> gui3d = Optional.empty();
        private Optional<Integer> weight = Optional.empty();
        private Map<String, String> textures = Maps.newHashMap();
        private Map<String, List<Variant>> submodels = Maps.newHashMap();
        private Map<String, Object> simpleSubmodels = Maps.newHashMap();
        private Map<String, String> customData = Maps.newHashMap();

        private Variant() {
        }

        private Variant(Variant other) {
            this.model = other.model;
            this.modelSet = other.modelSet;
            this.state = other.state;
            this.uvLock = other.uvLock;
            this.smooth = other.smooth;
            this.gui3d = other.gui3d;
            this.weight = other.weight;
            this.textures.putAll(other.textures);
            this.mergeModelPartVariants(this.submodels, other.submodels);
            this.simpleSubmodels.putAll(other.simpleSubmodels);
            this.customData.putAll(other.customData);
        }

        Variant sync(Variant parent) {
            if (!this.modelSet) {
                this.model = parent.model;
                this.modelSet = parent.modelSet;
            }
            if (!this.state.isPresent()) {
                this.state = parent.state;
            }
            if (!this.uvLock.isPresent()) {
                this.uvLock = parent.uvLock;
            }
            if (!this.smooth.isPresent()) {
                this.smooth = parent.smooth;
            }
            if (!this.gui3d.isPresent()) {
                this.gui3d = parent.gui3d;
            }
            if (!this.weight.isPresent()) {
                this.weight = parent.weight;
            }
            for (Map.Entry<String, String> entry : parent.textures.entrySet()) {
                if (this.textures.containsKey(entry.getKey())) continue;
                this.textures.put(entry.getKey(), entry.getValue());
            }
            this.mergeModelPartVariants(this.submodels, parent.submodels);
            for (Map.Entry<String, Object> entry : parent.simpleSubmodels.entrySet()) {
                if (this.simpleSubmodels.containsKey(entry.getKey())) continue;
                this.simpleSubmodels.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : parent.customData.entrySet()) {
                if (this.customData.containsKey(entry.getKey())) continue;
                this.customData.put(entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        Map<String, List<Variant>> mergeModelPartVariants(Map<String, List<Variant>> output, Map<String, List<Variant>> input) {
            for (Map.Entry<String, List<Variant>> e : input.entrySet()) {
                String key = e.getKey();
                if (output.containsKey(key)) continue;
                List<Variant> variants = e.getValue();
                if (variants != null) {
                    ArrayList newVariants = Lists.newArrayListWithCapacity((int)variants.size());
                    for (Variant v : variants) {
                        newVariants.add(new Variant(v));
                    }
                    output.put(key, newVariants);
                    continue;
                }
                output.put(key, variants);
            }
            return output;
        }

        boolean isVanillaCompatible() {
            return this.model != null && this.submodels.isEmpty() && this.textures.isEmpty() && this.customData.isEmpty() && !this.smooth.isPresent() && !this.gui3d.isPresent() && this.state.orElse(ModelRotation.X0_Y0) instanceof ModelRotation;
        }

        protected BlockStateLoader.SubModel asGenericSubModel() {
            return new BlockStateLoader.SubModel(this.state.orElse(TRSRTransformation.identity()), this.uvLock.orElse(false), this.smooth.orElse(true), this.gui3d.orElse(true), this.getTextures(), this.model, this.getCustomData());
        }

        public ImmutableMap<String, BlockStateLoader.SubModel> getOnlyPartsVariant() {
            if (this.submodels.size() > 0) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, List<Variant>> entry : this.submodels.entrySet()) {
                    List<Variant> part = entry.getValue();
                    if (part == null) continue;
                    if (part.size() == 1) {
                        builder.put((Object)entry.getKey(), (Object)part.get(0).asGenericSubModel());
                        continue;
                    }
                    throw new RuntimeException("Something attempted to get the list of submodels for a variant with model \"" + String.valueOf(this.model) + "\", when this variant contains multiple variants for submodel " + entry.getKey());
                }
                return builder.build();
            }
            return ImmutableMap.of();
        }

        public Optional<Boolean> getSmooth() {
            return this.smooth;
        }

        public Optional<Boolean> getGui3d() {
            return this.gui3d;
        }

        @Nullable
        public ResourceLocation getModel() {
            return this.model;
        }

        public boolean isModelSet() {
            return this.modelSet;
        }

        public Optional<IModelState> getState() {
            return this.state;
        }

        public Optional<Boolean> getUvLock() {
            return this.uvLock;
        }

        public Optional<Integer> getWeight() {
            return this.weight;
        }

        public ImmutableMap<String, String> getTextures() {
            return ImmutableMap.copyOf(this.textures);
        }

        public ImmutableMap<String, List<Variant>> getSubmodels() {
            return ImmutableMap.copyOf(this.submodels);
        }

        public ImmutableMap<String, String> getCustomData() {
            return ImmutableMap.copyOf(this.customData);
        }

        public static class Deserializer
        implements JsonDeserializer<Variant> {
            static Deserializer INSTANCE = new Deserializer();
            public String simpleSubmodelKey = null;

            protected ResourceLocation getBlockLocation(String location) {
                ResourceLocation tmp = new ResourceLocation(location);
                return new ResourceLocation(tmp.getNamespace(), "block/" + tmp.getPath());
            }

            private void throwIfNestedSubmodels(Variant submodel) {
                if (submodel.submodels.size() > 0) {
                    throw new UnsupportedOperationException("Forge BlockStateLoader V1 does not support nested submodels.");
                }
            }

            public Variant deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                Variant ret = new Variant();
                JsonObject json = element.getAsJsonObject();
                if (json.has("model")) {
                    ret.model = json.get("model").isJsonNull() ? null : this.getBlockLocation(JsonUtils.getString(json, "model"));
                    ret.modelSet = true;
                }
                if (json.has("textures")) {
                    for (Map.Entry e : json.get("textures").getAsJsonObject().entrySet()) {
                        if (((JsonElement)e.getValue()).isJsonNull()) {
                            ret.textures.put((String)e.getKey(), "");
                            continue;
                        }
                        ret.textures.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    }
                }
                if (json.has("x") || json.has("y")) {
                    int x = JsonUtils.getInt(json, "x", 0);
                    int y = JsonUtils.getInt(json, "y", 0);
                    ret.state = Optional.ofNullable(ModelRotation.getModelRotation(x, y));
                    if (!ret.state.isPresent()) {
                        throw new JsonParseException("Invalid BlockModelRotation x: " + x + " y: " + y);
                    }
                }
                if (json.has("transform")) {
                    if (json.get("transform").isJsonPrimitive() && json.get("transform").getAsJsonPrimitive().isString()) {
                        transform = json.get("transform").getAsString();
                        ret.state = Transforms.get((String)transform);
                        if (!ret.state.isPresent()) {
                            throw new JsonParseException("transform: unknown default string: " + (String)transform);
                        }
                    } else if (!json.get("transform").isJsonObject()) {
                        try {
                            TRSRTransformation base = (TRSRTransformation)context.deserialize(json.get("transform"), TRSRTransformation.class);
                            ret.state = Optional.of(TRSRTransformation.blockCenterToCorner(base));
                        }
                        catch (JsonParseException e) {
                            throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + String.valueOf(json.get("transform")));
                        }
                    } else {
                        TRSRTransformation t;
                        transform = json.get("transform").getAsJsonObject();
                        EnumMap transforms = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
                        if (transform.has("thirdperson")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("thirdperson"), TRSRTransformation.class);
                            transform.remove("thirdperson");
                            transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("thirdperson_righthand")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("thirdperson_righthand"), TRSRTransformation.class);
                            transform.remove("thirdperson_righthand");
                            transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("thirdperson_lefthand")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("thirdperson_lefthand"), TRSRTransformation.class);
                            transform.remove("thirdperson_lefthand");
                            transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("firstperson")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("firstperson"), TRSRTransformation.class);
                            transform.remove("firstperson");
                            transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("firstperson_righthand")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("firstperson_righthand"), TRSRTransformation.class);
                            transform.remove("firstperson_righthand");
                            transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("firstperson_lefthand")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("firstperson_lefthand"), TRSRTransformation.class);
                            transform.remove("firstperson_lefthand");
                            transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("head")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("head"), TRSRTransformation.class);
                            transform.remove("head");
                            transforms.put(ItemCameraTransforms.TransformType.HEAD, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("gui")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("gui"), TRSRTransformation.class);
                            transform.remove("gui");
                            transforms.put(ItemCameraTransforms.TransformType.GUI, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("ground")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("ground"), TRSRTransformation.class);
                            transform.remove("ground");
                            transforms.put(ItemCameraTransforms.TransformType.GROUND, TRSRTransformation.blockCenterToCorner(t));
                        }
                        if (transform.has("fixed")) {
                            t = (TRSRTransformation)context.deserialize(transform.get("fixed"), TRSRTransformation.class);
                            transform.remove("fixed");
                            transforms.put(ItemCameraTransforms.TransformType.FIXED, TRSRTransformation.blockCenterToCorner(t));
                        }
                        int k = transform.entrySet().size();
                        if (transform.has("matrix")) {
                            --k;
                        }
                        if (transform.has("translation")) {
                            --k;
                        }
                        if (transform.has("rotation")) {
                            --k;
                        }
                        if (transform.has("scale")) {
                            --k;
                        }
                        if (transform.has("post-rotation")) {
                            --k;
                        }
                        if (k > 0) {
                            throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation'");
                        }
                        TRSRTransformation base = TRSRTransformation.identity();
                        if (!transform.entrySet().isEmpty()) {
                            base = (TRSRTransformation)context.deserialize((JsonElement)transform, TRSRTransformation.class);
                            base = TRSRTransformation.blockCenterToCorner(base);
                        }
                        IModelState state = transforms.isEmpty() ? base : new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)Maps.immutableEnumMap((Map)transforms), Optional.of(base));
                        ret.state = Optional.of(state);
                    }
                }
                if (json.has("uvlock")) {
                    ret.uvLock = Optional.of(JsonUtils.getBoolean(json, "uvlock"));
                }
                if (json.has("smooth_lighting")) {
                    ret.smooth = Optional.of(JsonUtils.getBoolean(json, "smooth_lighting"));
                }
                if (json.has("gui3d")) {
                    ret.gui3d = Optional.of(JsonUtils.getBoolean(json, "gui3d"));
                }
                if (json.has("weight")) {
                    ret.weight = Optional.of(JsonUtils.getInt(json, "weight"));
                }
                if (json.has("submodel")) {
                    JsonElement submodels = json.get("submodel");
                    if (submodels.isJsonPrimitive()) {
                        if (this.simpleSubmodelKey == null) {
                            throw new RuntimeException("Attempted to use a simple submodel declaration outside a valid state variant declaration.");
                        }
                        String key = this.simpleSubmodelKey;
                        this.simpleSubmodelKey = null;
                        ret.model = this.getBlockLocation(submodels.getAsString());
                        ret.modelSet = true;
                        Variant dummyVar = new Variant();
                        dummyVar.submodels.put(key, Collections.singletonList(ret));
                        dummyVar.simpleSubmodels = Collections.singletonMap(key, SET_VALUE);
                        return dummyVar;
                    }
                    this.simpleSubmodelKey = null;
                    for (Map.Entry submodel : submodels.getAsJsonObject().entrySet()) {
                        List<Object> submodelVariants;
                        JsonElement varEl = (JsonElement)submodel.getValue();
                        if (varEl.isJsonArray()) {
                            submodelVariants = Lists.newArrayList();
                            for (JsonElement e : varEl.getAsJsonArray()) {
                                submodelVariants.add((Variant)context.deserialize(e, Variant.class));
                            }
                        } else {
                            submodelVariants = varEl.isJsonNull() ? null : Collections.singletonList((Variant)context.deserialize(varEl, Variant.class));
                        }
                        if (submodelVariants != null) {
                            for (Variant part : submodelVariants) {
                                this.throwIfNestedSubmodels(part);
                            }
                        }
                        ret.submodels.put((String)submodel.getKey(), submodelVariants);
                        ret.simpleSubmodels.put((String)submodel.getKey(), null);
                    }
                }
                if (json.has("custom")) {
                    for (Map.Entry e : json.get("custom").getAsJsonObject().entrySet()) {
                        if (((JsonElement)e.getValue()).isJsonNull()) {
                            ret.customData.put((String)e.getKey(), null);
                            continue;
                        }
                        ret.customData.put((String)e.getKey(), ((JsonElement)e.getValue()).toString());
                    }
                }
                this.simpleSubmodelKey = null;
                return ret;
            }
        }
    }

    public static class Deserializer
    implements JsonDeserializer<ForgeBlockStateV1> {
        static Deserializer INSTANCE = new Deserializer();

        public ForgeBlockStateV1 deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ForgeBlockStateV1 ret = new ForgeBlockStateV1();
            ret.forge_marker = JsonUtils.getInt(json, "forge_marker");
            if (json.has("defaults")) {
                ret.defaults = (Variant)context.deserialize(json.get("defaults"), Variant.class);
                if (ret.defaults.simpleSubmodels.size() > 0) {
                    throw new RuntimeException("\"defaults\" variant cannot contain a simple \"submodel\" definition.");
                }
            }
            LinkedHashMap condensed = Maps.newLinkedHashMap();
            LinkedHashMultimap specified = LinkedHashMultimap.create();
            for (Map.Entry e : JsonUtils.getJsonObject(json, "variants").entrySet()) {
                if (((JsonElement)e.getValue()).isJsonArray()) {
                    for (JsonElement a : ((JsonElement)e.getValue()).getAsJsonArray()) {
                        Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey();
                        specified.put((Object)((String)e.getKey()), (Object)((Variant)context.deserialize(a, Variant.class)));
                    }
                    continue;
                }
                JsonObject obj = ((JsonElement)e.getValue()).getAsJsonObject();
                if (((JsonElement)((Map.Entry)obj.entrySet().iterator().next()).getValue()).isJsonObject()) {
                    LinkedHashMap subs = Maps.newLinkedHashMap();
                    condensed.put((String)e.getKey(), subs);
                    for (Map.Entry entry : ((JsonElement)e.getValue()).getAsJsonObject().entrySet()) {
                        Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey() + "=" + (String)entry.getKey();
                        subs.put((String)entry.getKey(), (Variant)context.deserialize((JsonElement)entry.getValue(), Variant.class));
                    }
                    continue;
                }
                Variant.Deserializer.INSTANCE.simpleSubmodelKey = (String)e.getKey();
                specified.put((Object)((String)e.getKey()), (Object)((Variant)context.deserialize((JsonElement)e.getValue(), Variant.class)));
            }
            Multimap<String, Variant> permutations = this.getPermutations(condensed);
            for (Map.Entry e : specified.asMap().entrySet()) {
                Collection baseVars = permutations.get((Object)((String)e.getKey()));
                ArrayList addVars = Lists.newArrayList();
                for (Variant specVar : (Collection)e.getValue()) {
                    if (!baseVars.isEmpty()) {
                        for (Variant variant : baseVars) {
                            addVars.add(new Variant(specVar).sync(variant));
                        }
                        continue;
                    }
                    addVars.add(specVar);
                }
                baseVars.clear();
                baseVars.addAll(addVars);
            }
            for (Map.Entry e : permutations.entries()) {
                Variant v = (Variant)e.getValue();
                if (ret.defaults != null) {
                    v.sync(ret.defaults);
                    for (Map.Entry entry : v.simpleSubmodels.entrySet()) {
                        if (entry.getValue() == null) continue;
                        if (!v.submodels.containsKey(entry.getKey())) {
                            throw new RuntimeException("This should never happen! Simple submodel is not contained in the submodel map!");
                        }
                        List<Variant> partList = v.submodels.get(entry.getKey());
                        if (partList.size() > 1) {
                            throw new RuntimeException("This should never happen! Simple submodel has multiple variants!");
                        }
                        Variant part = partList.get(0);
                        Optional<IModelState> optional = part.state;
                        part.sync(v);
                        part.simpleSubmodels.clear();
                        part.state = optional;
                    }
                }
                v.submodels.values().removeIf(Objects::isNull);
                if (v.textures != null) {
                    for (Map.Entry entry : v.textures.entrySet()) {
                        if (entry.getValue() == null || ((String)entry.getValue()).charAt(0) != '#') continue;
                        String value = v.textures.get(((String)entry.getValue()).substring(1));
                        if (value == null) {
                            FMLLog.log.fatal("Could not resolve texture name \"{}\" for permutation \"{}\"", entry.getValue(), e.getKey());
                            for (Map.Entry entry2 : v.textures.entrySet()) {
                                FMLLog.log.fatal("{}={}", entry2.getKey(), entry2.getValue());
                            }
                            throw new JsonParseException("Could not resolve texture name \"" + (String)entry.getValue() + "\" for permutation \"" + (String)e.getKey() + "\"");
                        }
                        v.textures.put((String)entry.getKey(), value);
                    }
                    for (List list : v.submodels.values()) {
                        for (Variant partVar : list) {
                            for (Map.Entry<String, String> texEntry : v.textures.entrySet()) {
                                if (partVar.textures.containsKey(texEntry.getKey())) continue;
                                partVar.textures.put(texEntry.getKey(), texEntry.getValue());
                            }
                        }
                    }
                }
                if (!v.submodels.isEmpty()) {
                    ret.variants.putAll((Object)((String)e.getKey()), this.getSubmodelPermutations(v, v.submodels));
                    continue;
                }
                ret.variants.put((Object)((String)e.getKey()), (Object)v);
            }
            return ret;
        }

        private Multimap<String, Variant> getPermutations(List<String> sorted, Map<String, Map<String, Variant>> base, int depth, String prefix, Multimap<String, Variant> ret, @Nullable Variant parent) {
            if (depth == sorted.size()) {
                if (parent != null) {
                    ret.put((Object)prefix, (Object)parent);
                }
                return ret;
            }
            String name = sorted.get(depth);
            for (Map.Entry<String, Variant> e : base.get(name).entrySet()) {
                Variant newHead = parent == null ? new Variant(e.getValue()) : new Variant(parent).sync(e.getValue());
                this.getPermutations(sorted, base, depth + 1, prefix + (depth == 0 ? "" : ",") + name + "=" + e.getKey(), ret, newHead);
            }
            return ret;
        }

        private Multimap<String, Variant> getPermutations(Map<String, Map<String, Variant>> base) {
            ArrayList sorted = Lists.newArrayList(base.keySet());
            Collections.sort(sorted);
            return this.getPermutations(sorted, base, 0, "", (Multimap<String, Variant>)LinkedHashMultimap.create(), null);
        }

        private List<Variant> getSubmodelPermutations(Variant baseVar, List<String> sorted, Map<String, List<Variant>> map, int depth, Map<String, Variant> parts, List<Variant> ret) {
            if (depth >= sorted.size()) {
                Variant add = new Variant(baseVar);
                for (Map.Entry<String, Variant> part : parts.entrySet()) {
                    add.submodels.put(part.getKey(), Collections.singletonList(part.getValue()));
                }
                ret.add(add);
                return ret;
            }
            String name = sorted.get(depth);
            List<Variant> vars = map.get(sorted.get(depth));
            if (vars != null) {
                for (Variant v : vars) {
                    if (v == null) continue;
                    parts.put(name, v);
                    this.getSubmodelPermutations(baseVar, sorted, map, depth + 1, parts, ret);
                    parts.remove(name);
                }
            } else {
                this.getSubmodelPermutations(baseVar, sorted, map, depth + 1, parts, ret);
            }
            return ret;
        }

        private List<Variant> getSubmodelPermutations(Variant baseVar, Map<String, List<Variant>> variants) {
            ArrayList sorted = Lists.newArrayList(variants.keySet());
            Collections.sort(sorted);
            return this.getSubmodelPermutations(baseVar, sorted, variants, 0, new LinkedHashMap<String, Variant>(), new ArrayList<Variant>());
        }
    }
}

