/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class NotificationModUpdateScreen
extends GuiScreen {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private final GuiButton modButton;
    private ForgeVersion.Status showNotification = null;
    private ForgeVersion.Status showBetaNotification = null;
    private boolean hasCheckedForUpdates = false;

    public NotificationModUpdateScreen(GuiButton modButton) {
        this.modButton = modButton;
    }

    @Override
    public void initGui() {
        if (!this.hasCheckedForUpdates) {
            if (this.modButton != null) {
                if (ForgeVersion.hasOutdatedMods()) {
                    this.showNotification = ForgeVersion.Status.OUTDATED;
                }
                if (ForgeVersion.hasOutdatedBetaMods()) {
                    this.showBetaNotification = ForgeVersion.Status.BETA_OUTDATED;
                }
            }
            this.hasCheckedForUpdates = true;
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        if (ForgeModContainer.disableVersionCheck || this.showNotification == null && this.showBetaNotification == null) {
            return;
        }
        ForgeVersion.Status notification = ForgeVersion.Status.FAILED;
        notification = this.showNotification == null || this.showBetaNotification == null ? (this.showNotification == null ? this.showBetaNotification : this.showNotification) : ((System.currentTimeMillis() / 3200L & 1L) == 1L ? this.showBetaNotification : this.showNotification);
        Minecraft.getMinecraft().getTextureManager().bindTexture(VERSION_CHECK_ICONS);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.pushMatrix();
        int x = this.modButton.x;
        int y = this.modButton.y;
        int w = this.modButton.width;
        int h = this.modButton.height;
        NotificationModUpdateScreen.drawModalRectWithCustomSizedTexture(x + w - (h / 2 + 4), y + (h / 2 - 4), notification.getSheetOffset() * 8, notification.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f, 8, 8, 64.0f, 16.0f);
        GlStateManager.popMatrix();
    }

    public static NotificationModUpdateScreen init(GuiMainMenu guiMainMenu, GuiButton modButton) {
        NotificationModUpdateScreen notificationModUpdateScreen = new NotificationModUpdateScreen(modButton);
        notificationModUpdateScreen.setGuiSize(guiMainMenu.width, guiMainMenu.height);
        notificationModUpdateScreen.initGui();
        return notificationModUpdateScreen;
    }
}

