/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IRegistryDelegate;

public class ItemModelMesherForge
extends ItemModelMesher {
    final Map<IRegistryDelegate<Item>, Int2ObjectMap<ModelResourceLocation>> locations = Maps.newHashMap();
    final Map<IRegistryDelegate<Item>, Int2ObjectMap<IBakedModel>> models = Maps.newHashMap();

    public ItemModelMesherForge(ModelManager manager) {
        super(manager);
    }

    @Override
    @Nullable
    protected IBakedModel getItemModel(Item item, int meta) {
        Int2ObjectMap<IBakedModel> map = this.models.get(item.delegate);
        return map == null ? null : (IBakedModel)map.get(meta);
    }

    @Override
    public void register(Item item, int meta, ModelResourceLocation location) {
        IRegistryDelegate key = item.delegate;
        Int2ObjectOpenHashMap locs = this.locations.get(key);
        Int2ObjectOpenHashMap mods = this.models.get(key);
        if (locs == null) {
            locs = new Int2ObjectOpenHashMap();
            this.locations.put(key, (Int2ObjectMap<ModelResourceLocation>)locs);
        }
        if (mods == null) {
            mods = new Int2ObjectOpenHashMap();
            this.models.put(key, (Int2ObjectMap<IBakedModel>)mods);
        }
        locs.put(meta, (Object)location);
        mods.put(meta, (Object)this.getModelManager().getModel(location));
    }

    @Override
    public void rebuildCache() {
        ModelManager manager = this.getModelManager();
        for (Map.Entry<IRegistryDelegate<Item>, Int2ObjectMap<ModelResourceLocation>> e : this.locations.entrySet()) {
            Int2ObjectOpenHashMap mods = this.models.get(e.getKey());
            if (mods != null) {
                mods.clear();
            } else {
                mods = new Int2ObjectOpenHashMap();
                this.models.put(e.getKey(), (Int2ObjectMap<IBakedModel>)mods);
            }
            Int2ObjectOpenHashMap map = mods;
            e.getValue().int2ObjectEntrySet().forEach(arg_0 -> ItemModelMesherForge.lambda$rebuildCache$0((Int2ObjectMap)map, manager, arg_0));
        }
    }

    public ModelResourceLocation getLocation(@Nonnull ItemStack stack) {
        ItemMeshDefinition definition;
        Item item = stack.getItem();
        ModelResourceLocation location = null;
        Int2ObjectMap<ModelResourceLocation> map = this.locations.get(item.delegate);
        if (map != null) {
            location = (ModelResourceLocation)map.get(this.getMetadata(stack));
        }
        if (location == null && (definition = (ItemMeshDefinition)this.shapers.get(item)) != null) {
            location = definition.getModelLocation(stack);
        }
        if (location == null) {
            location = ModelBakery.MODEL_MISSING;
        }
        return location;
    }

    private static /* synthetic */ void lambda$rebuildCache$0(Int2ObjectMap map, ModelManager manager, Int2ObjectMap.Entry entry) {
        map.put(entry.getIntKey(), (Object)manager.getModel((ModelResourceLocation)entry.getValue()));
    }
}

