/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiOverlayDebug;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class GuiIngameForge
extends GuiIngame {
    private static final int WHITE = 0xFFFFFF;
    public static boolean renderVignette = true;
    public static boolean renderHelmet = true;
    public static boolean renderPortal = true;
    public static boolean renderHotbar = true;
    public static boolean renderCrosshairs = true;
    public static boolean renderBossHealth = true;
    public static boolean renderHealth = true;
    public static boolean renderArmor = true;
    public static boolean renderFood = true;
    public static boolean renderHealthMount = true;
    public static boolean renderAir = true;
    public static boolean renderExperiance = true;
    public static boolean renderJumpBar = true;
    public static boolean renderObjective = true;
    public static int left_height = 39;
    public static int right_height = 39;
    private ScaledResolution res = null;
    private FontRenderer fontrenderer = null;
    private RenderGameOverlayEvent eventParent;
    private GuiOverlayDebugForge debugOverlay;

    public GuiIngameForge(Minecraft mc) {
        super(mc);
        this.debugOverlay = new GuiOverlayDebugForge(this, mc);
    }

    @Override
    public void renderGameOverlay(float partialTicks) {
        ScoreObjective scoreobjective1;
        int slot;
        this.res = new ScaledResolution(this.mc);
        this.eventParent = new RenderGameOverlayEvent(partialTicks, this.res);
        int width = this.res.getScaledWidth();
        int height = this.res.getScaledHeight();
        renderHealthMount = this.mc.player.getRidingEntity() instanceof EntityLivingBase;
        renderFood = this.mc.player.getRidingEntity() == null;
        renderJumpBar = this.mc.player.isRidingHorse();
        right_height = 39;
        left_height = 39;
        if (this.pre(RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.fontrenderer = this.mc.fontRenderer;
        this.mc.entityRenderer.setupOverlayRendering();
        GlStateManager.enableBlend();
        if (renderVignette && Minecraft.isFancyGraphicsEnabled()) {
            this.renderVignette(this.mc.player.getBrightness(), this.res);
        } else {
            GlStateManager.enableDepth();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        }
        if (renderHelmet) {
            this.renderHelmet(this.res, partialTicks);
        }
        if (renderPortal && !this.mc.player.isPotionActive(MobEffects.NAUSEA)) {
            this.renderPortal(this.res, partialTicks);
        }
        if (renderHotbar) {
            this.renderHotbar(this.res, partialTicks);
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.zLevel = -90.0f;
        this.rand.setSeed(this.updateCounter * 312871);
        if (renderCrosshairs) {
            this.renderCrosshairs(partialTicks);
        }
        if (renderBossHealth) {
            this.renderBossHealth();
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.mc.playerController.shouldDrawHUD() && this.mc.getRenderViewEntity() instanceof EntityPlayer) {
            if (renderHealth) {
                this.renderHealth(width, height);
            }
            if (renderArmor) {
                this.renderArmor(width, height);
            }
            if (renderFood) {
                this.renderFood(width, height);
            }
            if (renderHealthMount) {
                this.renderHealthMount(width, height);
            }
            if (renderAir) {
                this.renderAir(width, height);
            }
        }
        this.renderSleepFade(width, height);
        if (renderJumpBar) {
            this.renderJumpBar(width, height);
        } else if (renderExperiance) {
            this.renderExperience(width, height);
        }
        this.renderToolHighlight(this.res);
        this.renderHUDText(width, height);
        this.renderFPSGraph();
        this.renderPotionIcons(this.res);
        this.renderRecordOverlay(width, height, partialTicks);
        this.renderSubtitles(this.res);
        this.renderTitle(width, height, partialTicks);
        Scoreboard scoreboard = this.mc.world.getScoreboard();
        ScoreObjective objective = null;
        ScorePlayerTeam scoreplayerteam = scoreboard.getPlayersTeam(this.mc.player.getName());
        if (scoreplayerteam != null && (slot = scoreplayerteam.getColor().getColorIndex()) >= 0) {
            objective = scoreboard.getObjectiveInDisplaySlot(3 + slot);
        }
        ScoreObjective scoreObjective = scoreobjective1 = objective != null ? objective : scoreboard.getObjectiveInDisplaySlot(1);
        if (renderObjective && scoreobjective1 != null) {
            this.renderScoreboard(scoreobjective1, this.res);
        }
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GlStateManager.disableAlpha();
        this.renderChat(width, height);
        this.renderPlayerList(width, height);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableLighting();
        GlStateManager.enableAlpha();
        this.post(RenderGameOverlayEvent.ElementType.ALL);
    }

    public ScaledResolution getResolution() {
        return this.res;
    }

    protected void renderCrosshairs(float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.CROSSHAIRS)) {
            return;
        }
        this.bind(Gui.ICONS);
        GlStateManager.enableBlend();
        super.renderAttackIndicator(partialTicks, this.res);
        this.post(RenderGameOverlayEvent.ElementType.CROSSHAIRS);
    }

    protected void renderPotionIcons(ScaledResolution resolution) {
        if (this.pre(RenderGameOverlayEvent.ElementType.POTION_ICONS)) {
            return;
        }
        super.renderPotionEffects(resolution);
        this.post(RenderGameOverlayEvent.ElementType.POTION_ICONS);
    }

    protected void renderSubtitles(ScaledResolution resolution) {
        if (this.pre(RenderGameOverlayEvent.ElementType.SUBTITLES)) {
            return;
        }
        this.overlaySubtitle.renderSubtitles(this.res);
        this.post(RenderGameOverlayEvent.ElementType.SUBTITLES);
    }

    protected void renderBossHealth() {
        if (this.pre(RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            return;
        }
        this.bind(Gui.ICONS);
        GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        this.mc.profiler.startSection("bossHealth");
        GlStateManager.enableBlend();
        this.overlayBoss.renderBossHealth();
        GlStateManager.disableBlend();
        this.mc.profiler.endSection();
        this.post(RenderGameOverlayEvent.ElementType.BOSSHEALTH);
    }

    @Override
    protected void renderVignette(float lightLevel, ScaledResolution scaledRes) {
        if (this.pre(RenderGameOverlayEvent.ElementType.VIGNETTE)) {
            GlStateManager.enableDepth();
            GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
            return;
        }
        super.renderVignette(lightLevel, scaledRes);
        this.post(RenderGameOverlayEvent.ElementType.VIGNETTE);
    }

    private void renderHelmet(ScaledResolution res, float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HELMET)) {
            return;
        }
        ItemStack itemstack = this.mc.player.inventory.armorItemInSlot(3);
        if (this.mc.gameSettings.thirdPersonView == 0 && !itemstack.isEmpty()) {
            Item item = itemstack.getItem();
            if (item == Item.getItemFromBlock(Blocks.PUMPKIN)) {
                this.renderPumpkinOverlay(res);
            } else {
                item.renderHelmetOverlay(itemstack, this.mc.player, res, partialTicks);
            }
        }
        this.post(RenderGameOverlayEvent.ElementType.HELMET);
    }

    protected void renderArmor(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.ARMOR)) {
            return;
        }
        this.mc.profiler.startSection("armor");
        GlStateManager.enableBlend();
        int left = width / 2 - 91;
        int top = height - left_height;
        int level = ForgeHooks.getTotalArmorValue(this.mc.player);
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                this.drawTexturedModalRect(left, top, 34, 9, 9, 9);
            } else if (i == level) {
                this.drawTexturedModalRect(left, top, 25, 9, 9, 9);
            } else if (i > level) {
                this.drawTexturedModalRect(left, top, 16, 9, 9, 9);
            }
            left += 8;
        }
        left_height += 10;
        GlStateManager.disableBlend();
        this.mc.profiler.endSection();
        this.post(RenderGameOverlayEvent.ElementType.ARMOR);
    }

    protected void renderPortal(ScaledResolution res, float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.PORTAL)) {
            return;
        }
        float f1 = this.mc.player.prevTimeInPortal + (this.mc.player.timeInPortal - this.mc.player.prevTimeInPortal) * partialTicks;
        if (f1 > 0.0f) {
            this.renderPortal(f1, res);
        }
        this.post(RenderGameOverlayEvent.ElementType.PORTAL);
    }

    @Override
    protected void renderHotbar(ScaledResolution res, float partialTicks) {
        if (this.pre(RenderGameOverlayEvent.ElementType.HOTBAR)) {
            return;
        }
        if (this.mc.playerController.isSpectator()) {
            this.spectatorGui.renderTooltip(res, partialTicks);
        } else {
            super.renderHotbar(res, partialTicks);
        }
        this.post(RenderGameOverlayEvent.ElementType.HOTBAR);
    }

    @Override
    public void setOverlayMessage(ITextComponent component, boolean animateColor) {
        this.setOverlayMessage(component.getFormattedText(), animateColor);
    }

    protected void renderAir(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.AIR)) {
            return;
        }
        this.mc.profiler.startSection("air");
        EntityPlayer player = (EntityPlayer)this.mc.getRenderViewEntity();
        GlStateManager.enableBlend();
        int left = width / 2 + 91;
        int top = height - right_height;
        if (player.isInsideOfMaterial(Material.WATER)) {
            int air = player.getAir();
            int full = MathHelper.ceil((double)(air - 2) * 10.0 / 300.0);
            int partial = MathHelper.ceil((double)air * 10.0 / 300.0) - full;
            for (int i = 0; i < full + partial; ++i) {
                this.drawTexturedModalRect(left - i * 8 - 9, top, i < full ? 16 : 25, 18, 9, 9);
            }
            right_height += 10;
        }
        GlStateManager.disableBlend();
        this.mc.profiler.endSection();
        this.post(RenderGameOverlayEvent.ElementType.AIR);
    }

    public void renderHealth(int width, int height) {
        boolean highlight;
        this.bind(ICONS);
        if (this.pre(RenderGameOverlayEvent.ElementType.HEALTH)) {
            return;
        }
        this.mc.profiler.startSection("health");
        GlStateManager.enableBlend();
        EntityPlayer player = (EntityPlayer)this.mc.getRenderViewEntity();
        int health = MathHelper.ceil(player.getHealth());
        boolean bl = highlight = this.healthUpdateCounter > (long)this.updateCounter && (this.healthUpdateCounter - (long)this.updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.hurtResistantTime > 0) {
            this.lastSystemTime = Minecraft.getSystemTime();
            this.healthUpdateCounter = this.updateCounter + 20;
        } else if (health > this.playerHealth && player.hurtResistantTime > 0) {
            this.lastSystemTime = Minecraft.getSystemTime();
            this.healthUpdateCounter = this.updateCounter + 10;
        }
        if (Minecraft.getSystemTime() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Minecraft.getSystemTime();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        IAttributeInstance attrMaxHealth = player.getEntityAttribute(SharedMonsterAttributes.MAX_HEALTH);
        float healthMax = (float)attrMaxHealth.getAttributeValue();
        float absorb = MathHelper.ceil(player.getAbsorptionAmount());
        int healthRows = MathHelper.ceil((healthMax + absorb) / 2.0f / 10.0f);
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed(this.updateCounter * 312871);
        int left = width / 2 - 91;
        int top = height - left_height;
        left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.isPotionActive(MobEffects.REGENERATION)) {
            regen = this.updateCounter % 25;
        }
        int TOP = 9 * (this.mc.world.getWorldInfo().isHardcoreModeEnabled() ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        if (player.isPotionActive(MobEffects.POISON)) {
            MARGIN += 36;
        } else if (player.isPotionActive(MobEffects.WITHER)) {
            MARGIN += 72;
        }
        float absorbRemaining = absorb;
        for (int i = MathHelper.ceil((healthMax + absorb) / 2.0f) - 1; i >= 0; --i) {
            int row = MathHelper.ceil((float)(i + 1) / 10.0f) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            this.drawTexturedModalRect(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.drawTexturedModalRect(x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.drawTexturedModalRect(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.drawTexturedModalRect(x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.drawTexturedModalRect(x, y, MARGIN + 144, TOP, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.drawTexturedModalRect(x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.drawTexturedModalRect(x, y, MARGIN + 45, TOP, 9, 9);
        }
        GlStateManager.disableBlend();
        this.mc.profiler.endSection();
        this.post(RenderGameOverlayEvent.ElementType.HEALTH);
    }

    public void renderFood(int width, int height) {
        if (this.pre(RenderGameOverlayEvent.ElementType.FOOD)) {
            return;
        }
        this.mc.profiler.startSection("food");
        EntityPlayer player = (EntityPlayer)this.mc.getRenderViewEntity();
        GlStateManager.enableBlend();
        int left = width / 2 + 91;
        int top = height - right_height;
        right_height += 10;
        boolean unused = false;
        FoodStats stats = this.mc.player.getFoodStats();
        int level = stats.getFoodLevel();
        for (int i = 0; i < 10; ++i) {
            int idx = i * 2 + 1;
            int x = left - i * 8 - 9;
            int y = top;
            int icon = 16;
            int background = 0;
            if (this.mc.player.isPotionActive(MobEffects.HUNGER)) {
                icon += 36;
                background = 13;
            }
            if (unused) {
                background = 1;
            }
            if (player.getFoodStats().getSaturationLevel() <= 0.0f && this.updateCounter % (level * 3 + 1) == 0) {
                y = top + (this.rand.nextInt(3) - 1);
            }
            this.drawTexturedModalRect(x, y, 16 + background * 9, 27, 9, 9);
            if (idx < level) {
                this.drawTexturedModalRect(x, y, icon + 36, 27, 9, 9);
                continue;
            }
            if (idx != level) continue;
            this.drawTexturedModalRect(x, y, icon + 45, 27, 9, 9);
        }
        GlStateManager.disableBlend();
        this.mc.profiler.endSection();
        this.post(RenderGameOverlayEvent.ElementType.FOOD);
    }

    protected void renderSleepFade(int width, int height) {
        if (this.mc.player.getSleepTimer() > 0) {
            this.mc.profiler.startSection("sleep");
            GlStateManager.disableDepth();
            GlStateManager.disableAlpha();
            int sleepTime = this.mc.player.getSleepTimer();
            float opacity = (float)sleepTime / 100.0f;
            if (opacity > 1.0f) {
                opacity = 1.0f - (float)(sleepTime - 100) / 10.0f;
            }
            int color = (int)(220.0f * opacity) << 24 | 0x101020;
            GuiIngameForge.drawRect(0, 0, width, height, color);
            GlStateManager.enableAlpha();
            GlStateManager.enableDepth();
            this.mc.profiler.endSection();
        }
    }

    protected void renderExperience(int width, int height) {
        this.bind(ICONS);
        if (this.pre(RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableBlend();
        if (this.mc.playerController.gameIsSurvivalOrAdventure()) {
            this.mc.profiler.startSection("expBar");
            int cap = this.mc.player.xpBarCap();
            int left = width / 2 - 91;
            if (cap > 0) {
                int barWidth = 182;
                int filled = (int)(this.mc.player.experience * (float)(barWidth + 1));
                int top = height - 32 + 3;
                this.drawTexturedModalRect(left, top, 0, 64, barWidth, 5);
                if (filled > 0) {
                    this.drawTexturedModalRect(left, top, 0, 69, filled, 5);
                }
            }
            this.mc.profiler.endSection();
            if (this.mc.playerController.gameIsSurvivalOrAdventure() && this.mc.player.experienceLevel > 0) {
                this.mc.profiler.startSection("expLevel");
                boolean flag1 = false;
                int color = flag1 ? 0xFFFFFF : 8453920;
                String text = "" + this.mc.player.experienceLevel;
                int x = (width - this.fontrenderer.getStringWidth(text)) / 2;
                int y = height - 31 - 4;
                this.fontrenderer.drawString(text, x + 1, y, 0);
                this.fontrenderer.drawString(text, x - 1, y, 0);
                this.fontrenderer.drawString(text, x, y + 1, 0);
                this.fontrenderer.drawString(text, x, y - 1, 0);
                this.fontrenderer.drawString(text, x, y, color);
                this.mc.profiler.endSection();
            }
        }
        GlStateManager.enableBlend();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.post(RenderGameOverlayEvent.ElementType.EXPERIENCE);
    }

    protected void renderJumpBar(int width, int height) {
        this.bind(ICONS);
        if (this.pre(RenderGameOverlayEvent.ElementType.JUMPBAR)) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableBlend();
        this.mc.profiler.startSection("jumpBar");
        float charge = this.mc.player.getHorseJumpPower();
        int barWidth = 182;
        int x = width / 2 - 91;
        int filled = (int)(charge * 183.0f);
        int top = height - 32 + 3;
        this.drawTexturedModalRect(x, top, 0, 84, 182, 5);
        if (filled > 0) {
            this.drawTexturedModalRect(x, top, 0, 89, filled, 5);
        }
        GlStateManager.enableBlend();
        this.mc.profiler.endSection();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.post(RenderGameOverlayEvent.ElementType.JUMPBAR);
    }

    protected void renderToolHighlight(ScaledResolution res) {
        if (this.mc.gameSettings.heldItemTooltips && !this.mc.playerController.isSpectator()) {
            this.mc.profiler.startSection("toolHighlight");
            if (this.remainingHighlightTicks > 0 && !this.highlightingItemStack.isEmpty()) {
                Object name = this.highlightingItemStack.getDisplayName();
                if (this.highlightingItemStack.hasDisplayName()) {
                    name = String.valueOf((Object)TextFormatting.ITALIC) + (String)name;
                }
                name = this.highlightingItemStack.getItem().getHighlightTip(this.highlightingItemStack, (String)name);
                int opacity = (int)((float)this.remainingHighlightTicks * 256.0f / 10.0f);
                if (opacity > 255) {
                    opacity = 255;
                }
                if (opacity > 0) {
                    int y = res.getScaledHeight() - 59;
                    if (!this.mc.playerController.shouldDrawHUD()) {
                        y += 14;
                    }
                    GlStateManager.pushMatrix();
                    GlStateManager.enableBlend();
                    GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                    FontRenderer font = this.highlightingItemStack.getItem().getFontRenderer(this.highlightingItemStack);
                    if (font != null) {
                        int x = (res.getScaledWidth() - font.getStringWidth((String)name)) / 2;
                        font.drawStringWithShadow((String)name, x, y, 0xFFFFFF | opacity << 24);
                    } else {
                        int x = (res.getScaledWidth() - this.fontrenderer.getStringWidth((String)name)) / 2;
                        this.fontrenderer.drawStringWithShadow((String)name, x, y, 0xFFFFFF | opacity << 24);
                    }
                    GlStateManager.disableBlend();
                    GlStateManager.popMatrix();
                }
            }
            this.mc.profiler.endSection();
        } else if (this.mc.player.isSpectator()) {
            this.spectatorGui.renderSelectedItem(res);
        }
    }

    protected void renderHUDText(int width, int height) {
        RenderGameOverlayEvent.Text event;
        this.mc.profiler.startSection("forgeHudText");
        OpenGlHelper.glBlendFunc(770, 771, 1, 0);
        ArrayList<String> listL = new ArrayList<String>();
        ArrayList<String> listR = new ArrayList<String>();
        if (this.mc.isDemo()) {
            long time = this.mc.world.getTotalWorldTime();
            if (time >= 120500L) {
                listR.add(I18n.format("demo.demoExpired", new Object[0]));
            } else {
                listR.add(I18n.format("demo.remainingTime", StringUtils.ticksToElapsedTime((int)(120500L - time))));
            }
        }
        if (this.mc.gameSettings.showDebugInfo && !this.pre(RenderGameOverlayEvent.ElementType.DEBUG)) {
            listL.addAll(this.debugOverlay.getLeft());
            listR.addAll(this.debugOverlay.getRight());
            this.post(RenderGameOverlayEvent.ElementType.DEBUG);
        }
        if (!MinecraftForge.EVENT_BUS.post(event = new RenderGameOverlayEvent.Text(this.eventParent, listL, listR))) {
            int top = 2;
            for (String msg : listL) {
                if (msg == null) continue;
                GuiIngameForge.drawRect(1, top - 1, 2 + this.fontrenderer.getStringWidth(msg) + 1, top + this.fontrenderer.FONT_HEIGHT - 1, -1873784752);
                this.fontrenderer.drawString(msg, 2, top, 0xE0E0E0);
                top += this.fontrenderer.FONT_HEIGHT;
            }
            top = 2;
            for (String msg : listR) {
                if (msg == null) continue;
                int w = this.fontrenderer.getStringWidth(msg);
                int left = width - 2 - w;
                GuiIngameForge.drawRect(left - 1, top - 1, left + w + 1, top + this.fontrenderer.FONT_HEIGHT - 1, -1873784752);
                this.fontrenderer.drawString(msg, left, top, 0xE0E0E0);
                top += this.fontrenderer.FONT_HEIGHT;
            }
        }
        this.mc.profiler.endSection();
        this.post(RenderGameOverlayEvent.ElementType.TEXT);
    }

    protected void renderFPSGraph() {
        if (this.mc.gameSettings.showDebugInfo && this.mc.gameSettings.showLagometer && !this.pre(RenderGameOverlayEvent.ElementType.FPS_GRAPH)) {
            this.debugOverlay.renderLagometer();
            this.post(RenderGameOverlayEvent.ElementType.FPS_GRAPH);
        }
    }

    protected void renderRecordOverlay(int width, int height, float partialTicks) {
        if (this.overlayMessageTime > 0) {
            this.mc.profiler.startSection("overlayMessage");
            float hue = (float)this.overlayMessageTime - partialTicks;
            int opacity = (int)(hue * 256.0f / 20.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (opacity > 0) {
                GlStateManager.pushMatrix();
                GlStateManager.translate(width / 2, height - 68, 0.0f);
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                int color = this.animateOverlayMessageColor ? Color.HSBtoRGB(hue / 50.0f, 0.7f, 0.6f) & 0xFFFFFF : 0xFFFFFF;
                this.fontrenderer.drawString(this.overlayMessage, -this.fontrenderer.getStringWidth(this.overlayMessage) / 2, -4, color | opacity << 24);
                GlStateManager.disableBlend();
                GlStateManager.popMatrix();
            }
            this.mc.profiler.endSection();
        }
    }

    protected void renderTitle(int width, int height, float partialTicks) {
        if (this.titlesTimer > 0) {
            this.mc.profiler.startSection("titleAndSubtitle");
            float age = (float)this.titlesTimer - partialTicks;
            int opacity = 255;
            if (this.titlesTimer > this.titleFadeOut + this.titleDisplayTime) {
                float f3 = (float)(this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut) - age;
                opacity = (int)(f3 * 255.0f / (float)this.titleFadeIn);
            }
            if (this.titlesTimer <= this.titleFadeOut) {
                opacity = (int)(age * 255.0f / (float)this.titleFadeOut);
            }
            if ((opacity = MathHelper.clamp(opacity, 0, 255)) > 8) {
                GlStateManager.pushMatrix();
                GlStateManager.translate(width / 2, height / 2, 0.0f);
                GlStateManager.enableBlend();
                GlStateManager.tryBlendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
                GlStateManager.pushMatrix();
                GlStateManager.scale(4.0f, 4.0f, 4.0f);
                int l = opacity << 24 & 0xFF000000;
                this.getFontRenderer().drawString(this.displayedTitle, -this.getFontRenderer().getStringWidth(this.displayedTitle) / 2, -10.0f, 0xFFFFFF | l, true);
                GlStateManager.popMatrix();
                GlStateManager.pushMatrix();
                GlStateManager.scale(2.0f, 2.0f, 2.0f);
                this.getFontRenderer().drawString(this.displayedSubTitle, -this.getFontRenderer().getStringWidth(this.displayedSubTitle) / 2, 5.0f, 0xFFFFFF | l, true);
                GlStateManager.popMatrix();
                GlStateManager.disableBlend();
                GlStateManager.popMatrix();
            }
            this.mc.profiler.endSection();
        }
    }

    protected void renderChat(int width, int height) {
        this.mc.profiler.startSection("chat");
        RenderGameOverlayEvent.Chat event = new RenderGameOverlayEvent.Chat(this.eventParent, 0, height - 48);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translate(event.getPosX(), event.getPosY(), 0.0f);
        this.persistantChatGUI.drawChat(this.updateCounter);
        GlStateManager.popMatrix();
        this.post(RenderGameOverlayEvent.ElementType.CHAT);
        this.mc.profiler.endSection();
    }

    protected void renderPlayerList(int width, int height) {
        ScoreObjective scoreobjective = this.mc.world.getScoreboard().getObjectiveInDisplaySlot(0);
        NetHandlerPlayClient handler = this.mc.player.connection;
        if (this.mc.gameSettings.keyBindPlayerList.isKeyDown() && (!this.mc.isIntegratedServerRunning() || handler.getPlayerInfoMap().size() > 1 || scoreobjective != null)) {
            this.overlayPlayerList.updatePlayerList(true);
            if (this.pre(RenderGameOverlayEvent.ElementType.PLAYER_LIST)) {
                return;
            }
            this.overlayPlayerList.renderPlayerlist(width, this.mc.world.getScoreboard(), scoreobjective);
            this.post(RenderGameOverlayEvent.ElementType.PLAYER_LIST);
        } else {
            this.overlayPlayerList.updatePlayerList(false);
        }
    }

    protected void renderHealthMount(int width, int height) {
        EntityPlayer player = (EntityPlayer)this.mc.getRenderViewEntity();
        Entity tmp = player.getRidingEntity();
        if (!(tmp instanceof EntityLivingBase)) {
            return;
        }
        this.bind(ICONS);
        if (this.pre(RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
            return;
        }
        boolean unused = false;
        int left_align = width / 2 + 91;
        this.mc.profiler.endStartSection("mountHealth");
        GlStateManager.enableBlend();
        EntityLivingBase mount = (EntityLivingBase)tmp;
        int health = (int)Math.ceil(mount.getHealth());
        float healthMax = mount.getMaxHealth();
        int hearts = (int)(healthMax + 0.5f) / 2;
        if (hearts > 30) {
            hearts = 30;
        }
        int MARGIN = 52;
        int BACKGROUND = 52 + (unused ? 1 : 0);
        int HALF = 97;
        int FULL = 88;
        int heart = 0;
        while (hearts > 0) {
            int top = height - right_height;
            int rowCount = Math.min(hearts, 10);
            hearts -= rowCount;
            for (int i = 0; i < rowCount; ++i) {
                int x = left_align - i * 8 - 9;
                this.drawTexturedModalRect(x, top, BACKGROUND, 9, 9, 9);
                if (i * 2 + 1 + heart < health) {
                    this.drawTexturedModalRect(x, top, 88, 9, 9, 9);
                    continue;
                }
                if (i * 2 + 1 + heart != health) continue;
                this.drawTexturedModalRect(x, top, 97, 9, 9, 9);
            }
            right_height += 10;
            heart += 20;
        }
        GlStateManager.disableBlend();
        this.post(RenderGameOverlayEvent.ElementType.HEALTHMOUNT);
    }

    private boolean pre(RenderGameOverlayEvent.ElementType type) {
        return MinecraftForge.EVENT_BUS.post(new RenderGameOverlayEvent.Pre(this.eventParent, type));
    }

    private void post(RenderGameOverlayEvent.ElementType type) {
        MinecraftForge.EVENT_BUS.post(new RenderGameOverlayEvent.Post(this.eventParent, type));
    }

    private void bind(ResourceLocation res) {
        this.mc.getTextureManager().bindTexture(res);
    }

    private class GuiOverlayDebugForge
    extends GuiOverlayDebug {
        private Minecraft mc;

        private GuiOverlayDebugForge(GuiIngameForge guiIngameForge, Minecraft mc) {
            super(mc);
            this.mc = mc;
        }

        @Override
        protected void renderDebugInfoLeft() {
        }

        @Override
        protected void renderDebugInfoRight(ScaledResolution res) {
        }

        private List<String> getLeft() {
            List<String> ret = this.call();
            ret.add("");
            ret.add("Debug: Pie [shift]: " + (this.mc.gameSettings.showDebugProfilerChart ? "visible" : "hidden") + " FPS [alt]: " + (this.mc.gameSettings.showLagometer ? "visible" : "hidden"));
            ret.add("For help: press F3 + Q");
            return ret;
        }

        private List<String> getRight() {
            return this.getDebugInfoRight();
        }
    }
}

