/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MapDecoration {
    private final Type type;
    private byte x;
    private byte y;
    private byte rotation;

    public MapDecoration(Type typeIn, byte xIn, byte yIn, byte rotationIn) {
        this.type = typeIn;
        this.x = xIn;
        this.y = yIn;
        this.rotation = rotationIn;
    }

    public byte getImage() {
        return this.type.getIcon();
    }

    public Type getType() {
        return this.type;
    }

    public byte getX() {
        return this.x;
    }

    public byte getY() {
        return this.y;
    }

    public byte getRotation() {
        return this.rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderOnFrame() {
        return this.type.isRenderedOnFrame();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof MapDecoration)) {
            return false;
        }
        MapDecoration mapdecoration = (MapDecoration)p_equals_1_;
        if (this.type != mapdecoration.type) {
            return false;
        }
        if (this.rotation != mapdecoration.rotation) {
            return false;
        }
        if (this.x != mapdecoration.x) {
            return false;
        }
        return this.y == mapdecoration.y;
    }

    public int hashCode() {
        int i = this.type.getIcon();
        i = 31 * i + this.x;
        i = 31 * i + this.y;
        i = 31 * i + this.rotation;
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean render(int index) {
        return false;
    }

    public static enum Type {
        PLAYER(false),
        FRAME(true),
        RED_MARKER(false),
        BLUE_MARKER(false),
        TARGET_X(true),
        TARGET_POINT(true),
        PLAYER_OFF_MAP(false),
        PLAYER_OFF_LIMITS(false),
        MANSION(true, 5393476),
        MONUMENT(true, 3830373);

        private final byte icon = (byte)this.ordinal();
        private final boolean renderedOnFrame;
        private final int mapColor;

        private Type(boolean p_i47343_3_) {
            this(p_i47343_3_, -1);
        }

        private Type(boolean p_i47344_3_, int p_i47344_4_) {
            this.renderedOnFrame = p_i47344_3_;
            this.mapColor = p_i47344_4_;
        }

        public byte getIcon() {
            return this.icon;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean isRenderedOnFrame() {
            return this.renderedOnFrame;
        }

        public boolean hasMapColor() {
            return this.mapColor >= 0;
        }

        public int getMapColor() {
            return this.mapColor;
        }

        public static Type byIcon(byte p_191159_0_) {
            return Type.values()[MathHelper.clamp(p_191159_0_, 0, Type.values().length - 1)];
        }
    }
}

