/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStatePaletteRegistry
implements IBlockStatePalette {
    @Override
    public int idFor(IBlockState state) {
        int i = Block.BLOCK_STATE_IDS.get(state);
        return i == -1 ? 0 : i;
    }

    @Override
    public IBlockState getBlockState(int indexKey) {
        IBlockState iblockstate = Block.BLOCK_STATE_IDS.getByValue(indexKey);
        return iblockstate == null ? Blocks.AIR.getDefaultState() : iblockstate;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void read(PacketBuffer buf) {
        buf.readVarInt();
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeVarInt(0);
    }

    @Override
    public int getSerializedSize() {
        return PacketBuffer.getVarIntSize(0);
    }
}

