/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;

public class BiomeCache {
    private final BiomeProvider provider;
    private long lastCleanupTime;
    private final Long2ObjectMap<Block> cacheMap = new Long2ObjectOpenHashMap(4096);
    private final List<Block> cache = Lists.newArrayList();

    public BiomeCache(BiomeProvider provider) {
        this.provider = provider;
    }

    public Block getEntry(int x, int z) {
        long i = (long)(x >>= 4) & 0xFFFFFFFFL | ((long)(z >>= 4) & 0xFFFFFFFFL) << 32;
        Block biomecache$block = (Block)this.cacheMap.get(i);
        if (biomecache$block == null) {
            biomecache$block = new Block(this, x, z);
            this.cacheMap.put(i, (Object)biomecache$block);
            this.cache.add(biomecache$block);
        }
        biomecache$block.lastAccessTime = MinecraftServer.getCurrentTimeMillis();
        return biomecache$block;
    }

    public Biome getBiome(int x, int z, Biome defaultValue) {
        Biome biome = this.getEntry(x, z).getBiome(x, z);
        return biome == null ? defaultValue : biome;
    }

    public void cleanupCache() {
        long i = MinecraftServer.getCurrentTimeMillis();
        long j = i - this.lastCleanupTime;
        if (j > 7500L || j < 0L) {
            this.lastCleanupTime = i;
            for (int k = 0; k < this.cache.size(); ++k) {
                Block biomecache$block = this.cache.get(k);
                long l = i - biomecache$block.lastAccessTime;
                if (l <= 30000L && l >= 0L) continue;
                this.cache.remove(k--);
                long i1 = (long)biomecache$block.x & 0xFFFFFFFFL | ((long)biomecache$block.z & 0xFFFFFFFFL) << 32;
                this.cacheMap.remove(i1);
            }
        }
    }

    public Biome[] getCachedBiomes(int x, int z) {
        return this.getEntry((int)x, (int)z).biomes;
    }

    public class Block {
        public Biome[] biomes = new Biome[256];
        public int x;
        public int z;
        public long lastAccessTime;

        public Block(BiomeCache this$0, int x, int z) {
            this.x = x;
            this.z = z;
            this$0.provider.getBiomes(this.biomes, x << 4, z << 4, 16, 16, false);
        }

        public Biome getBiome(int x, int z) {
            return this.biomes[x & 0xF | (z & 0xF) << 4];
        }
    }
}

