/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.server.SPacketRecipeBook;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeBookServer
extends RecipeBook {
    private static final Logger LOGGER = LogManager.getLogger();

    public void add(List<IRecipe> recipesIn, EntityPlayerMP player) {
        ArrayList list = Lists.newArrayList();
        for (IRecipe irecipe : recipesIn) {
            if (this.recipes.get(RecipeBookServer.getRecipeId(irecipe)) || irecipe.isDynamic()) continue;
            this.unlock(irecipe);
            this.markNew(irecipe);
            list.add(irecipe);
            CriteriaTriggers.RECIPE_UNLOCKED.trigger(player, irecipe);
        }
        this.sendPacket(SPacketRecipeBook.State.ADD, player, list);
    }

    public void remove(List<IRecipe> recipesIn, EntityPlayerMP player) {
        ArrayList list = Lists.newArrayList();
        for (IRecipe irecipe : recipesIn) {
            if (!this.recipes.get(RecipeBookServer.getRecipeId(irecipe))) continue;
            this.lock(irecipe);
            list.add(irecipe);
        }
        this.sendPacket(SPacketRecipeBook.State.REMOVE, player, list);
    }

    private void sendPacket(SPacketRecipeBook.State state, EntityPlayerMP player, List<IRecipe> recipesIn) {
        ForgeHooks.sendRecipeBook(player.connection, state, recipesIn, Collections.emptyList(), this.isGuiOpen, this.isFilteringCraftable);
    }

    public NBTTagCompound write() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setBoolean("isGuiOpen", this.isGuiOpen);
        nbttagcompound.setBoolean("isFilteringCraftable", this.isFilteringCraftable);
        NBTTagList nbttaglist = new NBTTagList();
        for (IRecipe irecipe : this.getRecipes()) {
            nbttaglist.appendTag(new NBTTagString(CraftingManager.REGISTRY.getNameForObject(irecipe).toString()));
        }
        nbttagcompound.setTag("recipes", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (IRecipe irecipe1 : this.getDisplayedRecipes()) {
            nbttaglist1.appendTag(new NBTTagString(CraftingManager.REGISTRY.getNameForObject(irecipe1).toString()));
        }
        nbttagcompound.setTag("toBeDisplayed", nbttaglist1);
        return nbttagcompound;
    }

    public void read(NBTTagCompound tag) {
        this.isGuiOpen = tag.getBoolean("isGuiOpen");
        this.isFilteringCraftable = tag.getBoolean("isFilteringCraftable");
        NBTTagList nbttaglist = tag.getTagList("recipes", 8);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            ResourceLocation resourcelocation = new ResourceLocation(nbttaglist.getStringTagAt(i));
            IRecipe irecipe = CraftingManager.getRecipe(resourcelocation);
            if (irecipe == null) {
                LOGGER.info("Tried to load unrecognized recipe: {} removed now.", (Object)resourcelocation);
                continue;
            }
            this.unlock(irecipe);
        }
        NBTTagList nbttaglist1 = tag.getTagList("toBeDisplayed", 8);
        for (int j = 0; j < nbttaglist1.tagCount(); ++j) {
            ResourceLocation resourcelocation1 = new ResourceLocation(nbttaglist1.getStringTagAt(j));
            IRecipe irecipe1 = CraftingManager.getRecipe(resourcelocation1);
            if (irecipe1 == null) {
                LOGGER.info("Tried to load unrecognized recipe: {} removed now.", (Object)resourcelocation1);
                continue;
            }
            this.markNew(irecipe1);
        }
    }

    private List<IRecipe> getRecipes() {
        ArrayList list = Lists.newArrayList();
        int i = this.recipes.nextSetBit(0);
        while (i >= 0) {
            list.add(CraftingManager.REGISTRY.getObjectById(i));
            i = this.recipes.nextSetBit(i + 1);
        }
        return list;
    }

    private List<IRecipe> getDisplayedRecipes() {
        ArrayList list = Lists.newArrayList();
        int i = this.newRecipes.nextSetBit(0);
        while (i >= 0) {
            list.add(CraftingManager.REGISTRY.getObjectById(i));
            i = this.newRecipes.nextSetBit(i + 1);
        }
        return list;
    }

    public void init(EntityPlayerMP player) {
        ForgeHooks.sendRecipeBook(player.connection, SPacketRecipeBook.State.INIT, this.getRecipes(), this.getDisplayedRecipes(), this.isGuiOpen, this.isFilteringCraftable);
    }
}

