/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PlayerInteractionManager {
    public World world;
    public EntityPlayerMP player;
    private GameType gameType = GameType.NOT_SET;
    private boolean isDestroyingBlock;
    private int initialDamage;
    private BlockPos destroyPos = BlockPos.ORIGIN;
    private int curblockDamage;
    private boolean receivedFinishDiggingPacket;
    private BlockPos delayedDestroyPos = BlockPos.ORIGIN;
    private int initialBlockDamage;
    private int durabilityRemainingOnBlock = -1;

    public PlayerInteractionManager(World worldIn) {
        this.world = worldIn;
    }

    public void setGameType(GameType type) {
        this.gameType = type;
        type.configurePlayerCapabilities(this.player.capabilities);
        this.player.sendPlayerAbilities();
        this.player.server.getPlayerList().sendPacketToAllPlayers(new SPacketPlayerListItem(SPacketPlayerListItem.Action.UPDATE_GAME_MODE, this.player));
        this.world.updateAllPlayersSleepingFlag();
    }

    public GameType getGameType() {
        return this.gameType;
    }

    public boolean survivalOrAdventure() {
        return this.gameType.isSurvivalOrAdventure();
    }

    public boolean isCreative() {
        return this.gameType.isCreative();
    }

    public void initializeGameType(GameType type) {
        if (this.gameType == GameType.NOT_SET) {
            this.gameType = type;
        }
        this.setGameType(this.gameType);
    }

    public void updateBlockRemoving() {
        ++this.curblockDamage;
        if (this.receivedFinishDiggingPacket) {
            int i = this.curblockDamage - this.initialBlockDamage;
            IBlockState iblockstate = this.world.getBlockState(this.delayedDestroyPos);
            if (iblockstate.getBlock().isAir(iblockstate, this.world, this.delayedDestroyPos)) {
                this.receivedFinishDiggingPacket = false;
            } else {
                float f = iblockstate.getPlayerRelativeBlockHardness(this.player, this.player.world, this.delayedDestroyPos) * (float)(i + 1);
                int j = (int)(f * 10.0f);
                if (j != this.durabilityRemainingOnBlock) {
                    this.world.sendBlockBreakProgress(this.player.getEntityId(), this.delayedDestroyPos, j);
                    this.durabilityRemainingOnBlock = j;
                }
                if (f >= 1.0f) {
                    this.receivedFinishDiggingPacket = false;
                    this.tryHarvestBlock(this.delayedDestroyPos);
                }
            }
        } else if (this.isDestroyingBlock) {
            IBlockState iblockstate1 = this.world.getBlockState(this.destroyPos);
            if (iblockstate1.getBlock().isAir(iblockstate1, this.world, this.destroyPos)) {
                this.world.sendBlockBreakProgress(this.player.getEntityId(), this.destroyPos, -1);
                this.durabilityRemainingOnBlock = -1;
                this.isDestroyingBlock = false;
            } else {
                int k = this.curblockDamage - this.initialDamage;
                float f1 = iblockstate1.getPlayerRelativeBlockHardness(this.player, this.player.world, this.destroyPos) * (float)(k + 1);
                int l = (int)(f1 * 10.0f);
                if (l != this.durabilityRemainingOnBlock) {
                    this.world.sendBlockBreakProgress(this.player.getEntityId(), this.destroyPos, l);
                    this.durabilityRemainingOnBlock = l;
                }
            }
        }
    }

    public void onBlockClicked(BlockPos pos, EnumFacing side) {
        double reachDist = this.player.getEntityAttribute(EntityPlayer.REACH_DISTANCE).getAttributeValue();
        PlayerInteractEvent.LeftClickBlock event = ForgeHooks.onLeftClickBlock(this.player, pos, side, ForgeHooks.rayTraceEyeHitVec(this.player, reachDist + 1.0));
        if (event.isCanceled()) {
            this.player.connection.sendPacket(new SPacketBlockChange(this.world, pos));
            this.world.notifyBlockUpdate(pos, this.world.getBlockState(pos), this.world.getBlockState(pos), 3);
            return;
        }
        if (this.isCreative()) {
            if (!this.world.extinguishFire(null, pos, side)) {
                this.tryHarvestBlock(pos);
            }
        } else {
            IBlockState iblockstate = this.world.getBlockState(pos);
            Block block = iblockstate.getBlock();
            if (this.gameType.hasLimitedInteractions()) {
                if (this.gameType == GameType.SPECTATOR) {
                    return;
                }
                if (!this.player.isAllowEdit()) {
                    ItemStack itemstack = this.player.getHeldItemMainhand();
                    if (itemstack.isEmpty()) {
                        return;
                    }
                    if (!itemstack.canDestroy(block)) {
                        return;
                    }
                }
            }
            this.initialDamage = this.curblockDamage;
            float f = 1.0f;
            if (!iblockstate.getBlock().isAir(iblockstate, this.world, pos)) {
                if (event.getUseBlock() != Event.Result.DENY) {
                    block.onBlockClicked(this.world, pos, this.player);
                    this.world.extinguishFire(null, pos, side);
                } else {
                    this.player.connection.sendPacket(new SPacketBlockChange(this.world, pos));
                    this.world.notifyBlockUpdate(pos, this.world.getBlockState(pos), this.world.getBlockState(pos), 3);
                }
                f = iblockstate.getPlayerRelativeBlockHardness(this.player, this.player.world, pos);
            }
            if (event.getUseItem() == Event.Result.DENY) {
                if (f >= 1.0f) {
                    this.player.connection.sendPacket(new SPacketBlockChange(this.world, pos));
                    this.world.notifyBlockUpdate(pos, this.world.getBlockState(pos), this.world.getBlockState(pos), 3);
                }
                return;
            }
            if (!iblockstate.getBlock().isAir(iblockstate, this.world, pos) && f >= 1.0f) {
                this.tryHarvestBlock(pos);
            } else {
                this.isDestroyingBlock = true;
                this.destroyPos = pos;
                int i = (int)(f * 10.0f);
                this.world.sendBlockBreakProgress(this.player.getEntityId(), pos, i);
                this.durabilityRemainingOnBlock = i;
            }
        }
    }

    public void blockRemoving(BlockPos pos) {
        if (pos.equals(this.destroyPos)) {
            int i = this.curblockDamage - this.initialDamage;
            IBlockState iblockstate = this.world.getBlockState(pos);
            if (!iblockstate.getBlock().isAir(iblockstate, this.world, pos)) {
                float f = iblockstate.getPlayerRelativeBlockHardness(this.player, this.player.world, pos) * (float)(i + 1);
                if (f >= 0.7f) {
                    this.isDestroyingBlock = false;
                    this.world.sendBlockBreakProgress(this.player.getEntityId(), pos, -1);
                    this.tryHarvestBlock(pos);
                } else if (!this.receivedFinishDiggingPacket) {
                    this.isDestroyingBlock = false;
                    this.receivedFinishDiggingPacket = true;
                    this.delayedDestroyPos = pos;
                    this.initialBlockDamage = this.initialDamage;
                }
            }
        }
    }

    public void cancelDestroyingBlock() {
        this.isDestroyingBlock = false;
        this.world.sendBlockBreakProgress(this.player.getEntityId(), this.destroyPos, -1);
    }

    private boolean removeBlock(BlockPos pos) {
        return this.removeBlock(pos, false);
    }

    private boolean removeBlock(BlockPos pos, boolean canHarvest) {
        IBlockState iblockstate = this.world.getBlockState(pos);
        boolean flag = iblockstate.getBlock().removedByPlayer(iblockstate, this.world, pos, this.player, canHarvest);
        if (flag) {
            iblockstate.getBlock().onPlayerDestroy(this.world, pos, iblockstate);
        }
        return flag;
    }

    public boolean tryHarvestBlock(BlockPos pos) {
        int exp = ForgeHooks.onBlockBreakEvent(this.world, this.gameType, this.player, pos);
        if (exp == -1) {
            return false;
        }
        IBlockState iblockstate = this.world.getBlockState(pos);
        TileEntity tileentity = this.world.getTileEntity(pos);
        Block block = iblockstate.getBlock();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !this.player.canUseCommandBlock()) {
            this.world.notifyBlockUpdate(pos, iblockstate, iblockstate, 3);
            return false;
        }
        ItemStack stack = this.player.getHeldItemMainhand();
        if (!stack.isEmpty() && stack.getItem().onBlockStartBreak(stack, pos, this.player)) {
            return false;
        }
        this.world.playEvent(this.player, 2001, pos, Block.getStateId(iblockstate));
        boolean flag1 = false;
        if (this.isCreative()) {
            flag1 = this.removeBlock(pos);
            this.player.connection.sendPacket(new SPacketBlockChange(this.world, pos));
        } else {
            ItemStack itemstack1 = this.player.getHeldItemMainhand();
            ItemStack itemstack2 = itemstack1.isEmpty() ? ItemStack.EMPTY : itemstack1.copy();
            boolean flag = iblockstate.getBlock().canHarvestBlock(this.world, pos, this.player);
            if (!itemstack1.isEmpty()) {
                itemstack1.onBlockDestroyed(this.world, iblockstate, pos, this.player);
                if (itemstack1.isEmpty()) {
                    ForgeEventFactory.onPlayerDestroyItem(this.player, itemstack2, EnumHand.MAIN_HAND);
                }
            }
            if ((flag1 = this.removeBlock(pos, flag)) && flag) {
                iblockstate.getBlock().harvestBlock(this.world, this.player, pos, iblockstate, tileentity, itemstack2);
            }
        }
        if (!this.isCreative() && flag1 && exp > 0) {
            iblockstate.getBlock().dropXpOnBlockBreak(this.world, pos, exp);
        }
        return flag1;
    }

    public EnumActionResult processRightClick(EntityPlayer player, World worldIn, ItemStack stack, EnumHand hand) {
        if (this.gameType == GameType.SPECTATOR) {
            return EnumActionResult.PASS;
        }
        if (player.getCooldownTracker().hasCooldown(stack.getItem())) {
            return EnumActionResult.PASS;
        }
        EnumActionResult cancelResult = ForgeHooks.onItemRightClick(player, hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        int i = stack.getCount();
        int j = stack.getMetadata();
        ItemStack copyBeforeUse = stack.copy();
        ActionResult<ItemStack> actionresult = stack.useItemRightClick(worldIn, player, hand);
        ItemStack itemstack = actionresult.getResult();
        if (itemstack == stack && itemstack.getCount() == i && itemstack.getMaxItemUseDuration() <= 0 && itemstack.getMetadata() == j) {
            return actionresult.getType();
        }
        if (actionresult.getType() == EnumActionResult.FAIL && itemstack.getMaxItemUseDuration() > 0 && !player.isHandActive()) {
            return actionresult.getType();
        }
        player.setHeldItem(hand, itemstack);
        if (this.isCreative()) {
            itemstack.setCount(i);
            if (itemstack.isItemStackDamageable()) {
                itemstack.setItemDamage(j);
            }
        }
        if (itemstack.isEmpty()) {
            ForgeEventFactory.onPlayerDestroyItem(player, copyBeforeUse, hand);
            player.setHeldItem(hand, ItemStack.EMPTY);
        }
        if (!player.isHandActive()) {
            ((EntityPlayerMP)player).sendContainerToPlayer(player.inventoryContainer);
        }
        return actionresult.getType();
    }

    public EnumActionResult processRightClickBlock(EntityPlayer player, World worldIn, ItemStack stack, EnumHand hand, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block;
        boolean bypass;
        if (this.gameType == GameType.SPECTATOR) {
            TileEntity tileentity = worldIn.getTileEntity(pos);
            if (tileentity instanceof ILockableContainer) {
                Block block1 = worldIn.getBlockState(pos).getBlock();
                ILockableContainer ilockablecontainer = (ILockableContainer)((Object)tileentity);
                if (ilockablecontainer instanceof TileEntityChest && block1 instanceof BlockChest) {
                    ilockablecontainer = ((BlockChest)block1).getLockableContainer(worldIn, pos);
                }
                if (ilockablecontainer != null) {
                    player.displayGUIChest(ilockablecontainer);
                    return EnumActionResult.SUCCESS;
                }
            } else if (tileentity instanceof IInventory) {
                player.displayGUIChest((IInventory)((Object)tileentity));
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        double reachDist = player.getEntityAttribute(EntityPlayer.REACH_DISTANCE).getAttributeValue();
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock(player, hand, pos, facing, ForgeHooks.rayTraceEyeHitVec(player, reachDist + 1.0));
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        EnumActionResult result = EnumActionResult.PASS;
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(player, worldIn, pos, hand, facing, hitX, hitY, hitZ)) != EnumActionResult.PASS) {
            return result;
        }
        boolean bl = bypass = player.getHeldItemMainhand().doesSneakBypassUse(worldIn, pos, player) && player.getHeldItemOffhand().doesSneakBypassUse(worldIn, pos, player);
        if (!player.isSneaking() || bypass || event.getUseBlock() == Event.Result.ALLOW) {
            IBlockState iblockstate = worldIn.getBlockState(pos);
            if (event.getUseBlock() != Event.Result.DENY && iblockstate.getBlock().onBlockActivated(worldIn, pos, iblockstate, player, hand, facing, hitX, hitY, hitZ)) {
                result = EnumActionResult.SUCCESS;
            }
        }
        if (stack.isEmpty()) {
            return EnumActionResult.PASS;
        }
        if (player.getCooldownTracker().hasCooldown(stack.getItem())) {
            return EnumActionResult.PASS;
        }
        if (stack.getItem() instanceof ItemBlock && !player.canUseCommandBlock() && ((block = ((ItemBlock)stack.getItem()).getBlock()) instanceof BlockCommandBlock || block instanceof BlockStructure)) {
            return EnumActionResult.FAIL;
        }
        if (this.isCreative()) {
            int j = stack.getMetadata();
            int i = stack.getCount();
            if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
                EnumActionResult enumactionresult = stack.onItemUse(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
                stack.setItemDamage(j);
                stack.setCount(i);
                return enumactionresult;
            }
            return result;
        }
        if (result != EnumActionResult.SUCCESS && event.getUseItem() != Event.Result.DENY || result == EnumActionResult.SUCCESS && event.getUseItem() == Event.Result.ALLOW) {
            ItemStack copyBeforeUse = stack.copy();
            result = stack.onItemUse(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
            if (stack.isEmpty()) {
                ForgeEventFactory.onPlayerDestroyItem(player, copyBeforeUse, hand);
            }
        }
        return result;
    }

    public void setWorld(WorldServer serverWorld) {
        this.world = serverWorld;
    }

    @Deprecated
    public double getBlockReachDistance() {
        return this.player.getEntityAttribute(EntityPlayer.REACH_DISTANCE).getAttributeValue();
    }

    @Deprecated
    public void setBlockReachDistance(double distance) {
        this.player.getEntityAttribute(EntityPlayer.REACH_DISTANCE).setBaseValue(distance);
    }
}

