/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.SERVER)
public class ServerEula {
    private static final Logger LOG = LogManager.getLogger();
    private final File eulaFile;
    private final boolean acceptedEULA;

    public ServerEula(File eulaFile) {
        this.eulaFile = eulaFile;
        this.acceptedEULA = this.loadEULAFile(eulaFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadEULAFile(File inFile) {
        FileInputStream fileinputstream = null;
        boolean flag = false;
        try {
            Properties properties = new Properties();
            fileinputstream = new FileInputStream(inFile);
            properties.load(fileinputstream);
            flag = Boolean.parseBoolean(properties.getProperty("eula", "false"));
        }
        catch (Exception exception) {
            try {
                LOG.warn("Failed to load {}", (Object)inFile);
                this.createEULAFile();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileinputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fileinputstream);
        }
        IOUtils.closeQuietly((InputStream)fileinputstream);
        return flag;
    }

    public boolean hasAcceptedEULA() {
        return this.acceptedEULA;
    }

    public void createEULAFile() {
        FileOutputStream fileoutputstream = null;
        try {
            Properties properties = new Properties();
            fileoutputstream = new FileOutputStream(this.eulaFile);
            properties.setProperty("eula", "false");
            properties.store(fileoutputstream, "By changing the setting below to TRUE you are indicating your agreement to our EULA (https://account.mojang.com/documents/minecraft_eula).");
        }
        catch (Exception exception) {
            try {
                LOG.warn("Failed to save {}", (Object)this.eulaFile, (Object)exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileoutputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fileoutputstream);
        }
        IOUtils.closeQuietly((OutputStream)fileoutputstream);
    }
}

