/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.FlyingNodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PathNavigateFlying
extends PathNavigate {
    public PathNavigateFlying(EntityLiving entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    @Override
    protected PathFinder getPathFinder() {
        this.nodeProcessor = new FlyingNodeProcessor();
        this.nodeProcessor.setCanEnterDoors(true);
        return new PathFinder(this.nodeProcessor);
    }

    @Override
    protected boolean canNavigate() {
        return this.canFloat() && this.isInLiquid() || !this.entity.isRiding();
    }

    @Override
    protected Vec3d getEntityPosition() {
        return new Vec3d(this.entity.posX, this.entity.posY, this.entity.posZ);
    }

    @Override
    public Path getPathToEntityLiving(Entity entityIn) {
        return this.getPathToPos(new BlockPos(entityIn));
    }

    @Override
    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (this.tryUpdatePath) {
            this.updatePath();
        }
        if (!this.noPath()) {
            if (this.canNavigate()) {
                this.pathFollow();
            } else if (this.currentPath != null && this.currentPath.getCurrentPathIndex() < this.currentPath.getCurrentPathLength()) {
                Vec3d vec3d = this.currentPath.getVectorFromIndex(this.entity, this.currentPath.getCurrentPathIndex());
                if (MathHelper.floor(this.entity.posX) == MathHelper.floor(vec3d.x) && MathHelper.floor(this.entity.posY) == MathHelper.floor(vec3d.y) && MathHelper.floor(this.entity.posZ) == MathHelper.floor(vec3d.z)) {
                    this.currentPath.setCurrentPathIndex(this.currentPath.getCurrentPathIndex() + 1);
                }
            }
            this.debugPathFinding();
            if (!this.noPath()) {
                Vec3d vec3d1 = this.currentPath.getPosition(this.entity);
                this.entity.getMoveHelper().setMoveTo(vec3d1.x, vec3d1.y, vec3d1.z, this.speed);
            }
        }
    }

    @Override
    protected boolean isDirectPathBetweenPoints(Vec3d posVec31, Vec3d posVec32, int sizeX, int sizeY, int sizeZ) {
        int i = MathHelper.floor(posVec31.x);
        int j = MathHelper.floor(posVec31.y);
        int k = MathHelper.floor(posVec31.z);
        double d0 = posVec32.x - posVec31.x;
        double d1 = posVec32.y - posVec31.y;
        double d2 = posVec32.z - posVec31.z;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        if (d3 < 1.0E-8) {
            return false;
        }
        double d4 = 1.0 / Math.sqrt(d3);
        double d5 = 1.0 / Math.abs(d0 *= d4);
        double d6 = 1.0 / Math.abs(d1 *= d4);
        double d7 = 1.0 / Math.abs(d2 *= d4);
        double d8 = (double)i - posVec31.x;
        double d9 = (double)j - posVec31.y;
        double d10 = (double)k - posVec31.z;
        if (d0 >= 0.0) {
            d8 += 1.0;
        }
        if (d1 >= 0.0) {
            d9 += 1.0;
        }
        if (d2 >= 0.0) {
            d10 += 1.0;
        }
        d8 /= d0;
        d9 /= d1;
        d10 /= d2;
        int l = d0 < 0.0 ? -1 : 1;
        int i1 = d1 < 0.0 ? -1 : 1;
        int j1 = d2 < 0.0 ? -1 : 1;
        int k1 = MathHelper.floor(posVec32.x);
        int l1 = MathHelper.floor(posVec32.y);
        int i2 = MathHelper.floor(posVec32.z);
        int j2 = k1 - i;
        int k2 = l1 - j;
        int l2 = i2 - k;
        while (j2 * l > 0 || k2 * i1 > 0 || l2 * j1 > 0) {
            if (d8 < d10 && d8 <= d9) {
                d8 += d5;
                j2 = k1 - (i += l);
                continue;
            }
            if (d9 < d8 && d9 <= d10) {
                d9 += d6;
                k2 = l1 - (j += i1);
                continue;
            }
            d10 += d7;
            l2 = i2 - (k += j1);
        }
        return true;
    }

    public void setCanOpenDoors(boolean canOpenDoorsIn) {
        this.nodeProcessor.setCanOpenDoors(canOpenDoorsIn);
    }

    public void setCanEnterDoors(boolean canEnterDoorsIn) {
        this.nodeProcessor.setCanEnterDoors(canEnterDoorsIn);
    }

    public void setCanFloat(boolean canFloatIn) {
        this.nodeProcessor.setCanSwim(canFloatIn);
    }

    public boolean canFloat() {
        return this.nodeProcessor.getCanSwim();
    }

    @Override
    public boolean canEntityStandOnPos(BlockPos pos) {
        return this.world.getBlockState(pos).isTopSolid();
    }
}

