/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketUpdateBossInfo
implements Packet<INetHandlerPlayClient> {
    private UUID uniqueId;
    private Operation operation;
    private ITextComponent name;
    private float percent;
    private BossInfo.Color color;
    private BossInfo.Overlay overlay;
    private boolean darkenSky;
    private boolean playEndBossMusic;
    private boolean createFog;

    public SPacketUpdateBossInfo() {
    }

    public SPacketUpdateBossInfo(Operation operationIn, BossInfo data) {
        this.operation = operationIn;
        this.uniqueId = data.getUniqueId();
        this.name = data.getName();
        this.percent = data.getPercent();
        this.color = data.getColor();
        this.overlay = data.getOverlay();
        this.darkenSky = data.shouldDarkenSky();
        this.playEndBossMusic = data.shouldPlayEndBossMusic();
        this.createFog = data.shouldCreateFog();
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.uniqueId = buf.readUniqueId();
        this.operation = buf.readEnumValue(Operation.class);
        switch (this.operation.ordinal()) {
            case 0: {
                this.name = buf.readTextComponent();
                this.percent = buf.readFloat();
                this.color = buf.readEnumValue(BossInfo.Color.class);
                this.overlay = buf.readEnumValue(BossInfo.Overlay.class);
                this.setFlags(buf.readUnsignedByte());
            }
            default: {
                break;
            }
            case 2: {
                this.percent = buf.readFloat();
                break;
            }
            case 3: {
                this.name = buf.readTextComponent();
                break;
            }
            case 4: {
                this.color = buf.readEnumValue(BossInfo.Color.class);
                this.overlay = buf.readEnumValue(BossInfo.Overlay.class);
                break;
            }
            case 5: {
                this.setFlags(buf.readUnsignedByte());
            }
        }
    }

    private void setFlags(int flags) {
        this.darkenSky = (flags & 1) > 0;
        this.playEndBossMusic = (flags & 2) > 0;
        this.createFog = (flags & 2) > 0;
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeUniqueId(this.uniqueId);
        buf.writeEnumValue(this.operation);
        switch (this.operation.ordinal()) {
            case 0: {
                buf.writeTextComponent(this.name);
                buf.writeFloat(this.percent);
                buf.writeEnumValue(this.color);
                buf.writeEnumValue(this.overlay);
                buf.writeByte(this.getFlags());
            }
            default: {
                break;
            }
            case 2: {
                buf.writeFloat(this.percent);
                break;
            }
            case 3: {
                buf.writeTextComponent(this.name);
                break;
            }
            case 4: {
                buf.writeEnumValue(this.color);
                buf.writeEnumValue(this.overlay);
                break;
            }
            case 5: {
                buf.writeByte(this.getFlags());
            }
        }
    }

    private int getFlags() {
        int i = 0;
        if (this.darkenSky) {
            i |= 1;
        }
        if (this.playEndBossMusic) {
            i |= 2;
        }
        if (this.createFog) {
            i |= 2;
        }
        return i;
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleUpdateBossInfo(this);
    }

    @SideOnly(value=Side.CLIENT)
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @SideOnly(value=Side.CLIENT)
    public Operation getOperation() {
        return this.operation;
    }

    @SideOnly(value=Side.CLIENT)
    public ITextComponent getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPercent() {
        return this.percent;
    }

    @SideOnly(value=Side.CLIENT)
    public BossInfo.Color getColor() {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public BossInfo.Overlay getOverlay() {
        return this.overlay;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldDarkenSky() {
        return this.darkenSky;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldPlayEndBossMusic() {
        return this.playEndBossMusic;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldCreateFog() {
        return this.createFog;
    }

    public static enum Operation {
        ADD,
        REMOVE,
        UPDATE_PCT,
        UPDATE_NAME,
        UPDATE_STYLE,
        UPDATE_PROPERTIES;

    }
}

