/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketPlayerListItem
implements Packet<INetHandlerPlayClient> {
    private Action action;
    private final List<AddPlayerData> players = Lists.newArrayList();

    public SPacketPlayerListItem() {
    }

    public SPacketPlayerListItem(Action actionIn, EntityPlayerMP ... playersIn) {
        this.action = actionIn;
        for (EntityPlayerMP entityplayermp : playersIn) {
            this.players.add(new AddPlayerData(this, entityplayermp.getGameProfile(), entityplayermp.ping, entityplayermp.interactionManager.getGameType(), entityplayermp.getTabListDisplayName()));
        }
    }

    public SPacketPlayerListItem(Action actionIn, Iterable<EntityPlayerMP> playersIn) {
        this.action = actionIn;
        for (EntityPlayerMP entityplayermp : playersIn) {
            this.players.add(new AddPlayerData(this, entityplayermp.getGameProfile(), entityplayermp.ping, entityplayermp.interactionManager.getGameType(), entityplayermp.getTabListDisplayName()));
        }
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.action = buf.readEnumValue(Action.class);
        int i = buf.readVarInt();
        for (int j = 0; j < i; ++j) {
            GameProfile gameprofile = null;
            int k = 0;
            GameType gametype = null;
            ITextComponent itextcomponent = null;
            switch (this.action.ordinal()) {
                case 0: {
                    gameprofile = new GameProfile(buf.readUniqueId(), buf.readString(16));
                    int l = buf.readVarInt();
                    for (int i1 = 0; i1 < l; ++i1) {
                        String s = buf.readString(Short.MAX_VALUE);
                        String s1 = buf.readString(Short.MAX_VALUE);
                        if (buf.readBoolean()) {
                            gameprofile.getProperties().put((Object)s, (Object)new Property(s, s1, buf.readString(Short.MAX_VALUE)));
                            continue;
                        }
                        gameprofile.getProperties().put((Object)s, (Object)new Property(s, s1));
                    }
                    gametype = GameType.getByID(buf.readVarInt());
                    k = buf.readVarInt();
                    if (!buf.readBoolean()) break;
                    itextcomponent = buf.readTextComponent();
                    break;
                }
                case 1: {
                    gameprofile = new GameProfile(buf.readUniqueId(), null);
                    gametype = GameType.getByID(buf.readVarInt());
                    break;
                }
                case 2: {
                    gameprofile = new GameProfile(buf.readUniqueId(), null);
                    k = buf.readVarInt();
                    break;
                }
                case 3: {
                    gameprofile = new GameProfile(buf.readUniqueId(), null);
                    if (!buf.readBoolean()) break;
                    itextcomponent = buf.readTextComponent();
                    break;
                }
                case 4: {
                    gameprofile = new GameProfile(buf.readUniqueId(), null);
                }
            }
            this.players.add(new AddPlayerData(this, gameprofile, k, gametype, itextcomponent));
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeEnumValue(this.action);
        buf.writeVarInt(this.players.size());
        for (AddPlayerData spacketplayerlistitem$addplayerdata : this.players) {
            switch (this.action.ordinal()) {
                case 0: {
                    buf.writeUniqueId(spacketplayerlistitem$addplayerdata.getProfile().getId());
                    buf.writeString(spacketplayerlistitem$addplayerdata.getProfile().getName());
                    buf.writeVarInt(spacketplayerlistitem$addplayerdata.getProfile().getProperties().size());
                    for (Property property : spacketplayerlistitem$addplayerdata.getProfile().getProperties().values()) {
                        buf.writeString(property.getName());
                        buf.writeString(property.getValue());
                        if (property.hasSignature()) {
                            buf.writeBoolean(true);
                            buf.writeString(property.getSignature());
                            continue;
                        }
                        buf.writeBoolean(false);
                    }
                    buf.writeVarInt(spacketplayerlistitem$addplayerdata.getGameMode().getID());
                    buf.writeVarInt(spacketplayerlistitem$addplayerdata.getPing());
                    if (spacketplayerlistitem$addplayerdata.getDisplayName() == null) {
                        buf.writeBoolean(false);
                        break;
                    }
                    buf.writeBoolean(true);
                    buf.writeTextComponent(spacketplayerlistitem$addplayerdata.getDisplayName());
                    break;
                }
                case 1: {
                    buf.writeUniqueId(spacketplayerlistitem$addplayerdata.getProfile().getId());
                    buf.writeVarInt(spacketplayerlistitem$addplayerdata.getGameMode().getID());
                    break;
                }
                case 2: {
                    buf.writeUniqueId(spacketplayerlistitem$addplayerdata.getProfile().getId());
                    buf.writeVarInt(spacketplayerlistitem$addplayerdata.getPing());
                    break;
                }
                case 3: {
                    buf.writeUniqueId(spacketplayerlistitem$addplayerdata.getProfile().getId());
                    if (spacketplayerlistitem$addplayerdata.getDisplayName() == null) {
                        buf.writeBoolean(false);
                        break;
                    }
                    buf.writeBoolean(true);
                    buf.writeTextComponent(spacketplayerlistitem$addplayerdata.getDisplayName());
                    break;
                }
                case 4: {
                    buf.writeUniqueId(spacketplayerlistitem$addplayerdata.getProfile().getId());
                }
            }
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handlePlayerListItem(this);
    }

    @SideOnly(value=Side.CLIENT)
    public List<AddPlayerData> getEntries() {
        return this.players;
    }

    @SideOnly(value=Side.CLIENT)
    public Action getAction() {
        return this.action;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("entries", this.players).toString();
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }

    public class AddPlayerData {
        private final int ping;
        private final GameType gamemode;
        private final GameProfile profile;
        private final ITextComponent displayName;

        public AddPlayerData(SPacketPlayerListItem this$0, GameProfile profileIn, @Nullable int latencyIn, @Nullable GameType gameModeIn, ITextComponent displayNameIn) {
            this.profile = profileIn;
            this.ping = latencyIn;
            this.gamemode = gameModeIn;
            this.displayName = displayNameIn;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public int getPing() {
            return this.ping;
        }

        public GameType getGameMode() {
            return this.gamemode;
        }

        @Nullable
        public ITextComponent getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("latency", this.ping).add("gameMode", (Object)this.gamemode).add("profile", (Object)this.profile).add("displayName", this.displayName == null ? null : ITextComponent.Serializer.componentToJson(this.displayName)).toString();
        }
    }
}

