/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntityEffect
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private byte effectId;
    private byte amplifier;
    private int duration;
    private byte flags;

    public SPacketEntityEffect() {
    }

    public SPacketEntityEffect(int entityIdIn, PotionEffect effect) {
        this.entityId = entityIdIn;
        this.effectId = (byte)(Potion.getIdFromPotion(effect.getPotion()) & 0xFF);
        this.amplifier = (byte)(effect.getAmplifier() & 0xFF);
        this.duration = effect.getDuration() > Short.MAX_VALUE ? Short.MAX_VALUE : effect.getDuration();
        this.flags = 0;
        if (effect.getIsAmbient()) {
            this.flags = (byte)(this.flags | 1);
        }
        if (effect.doesShowParticles()) {
            this.flags = (byte)(this.flags | 2);
        }
    }

    @Override
    public void readPacketData(PacketBuffer buf) throws IOException {
        this.entityId = buf.readVarInt();
        this.effectId = buf.readByte();
        this.amplifier = buf.readByte();
        this.duration = buf.readVarInt();
        this.flags = buf.readByte();
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.writeVarInt(this.entityId);
        buf.writeByte(this.effectId);
        buf.writeByte(this.amplifier);
        buf.writeVarInt(this.duration);
        buf.writeByte(this.flags);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isMaxDuration() {
        return this.duration == Short.MAX_VALUE;
    }

    @Override
    public void processPacket(INetHandlerPlayClient handler) {
        handler.handleEntityEffect(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getEffectId() {
        return this.effectId;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getAmplifier() {
        return this.amplifier;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDuration() {
        return this.duration;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesShowParticles() {
        return (this.flags & 2) == 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getIsAmbient() {
        return (this.flags & 1) == 1;
    }
}

