/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class RecipesMapExtending
extends ShapedRecipes {
    public RecipesMapExtending() {
        super("", 3, 3, NonNullList.from(Ingredient.EMPTY, Ingredient.fromItems(Items.PAPER), Ingredient.fromItems(Items.PAPER), Ingredient.fromItems(Items.PAPER), Ingredient.fromItems(Items.PAPER), Ingredient.fromItem(Items.FILLED_MAP), Ingredient.fromItems(Items.PAPER), Ingredient.fromItems(Items.PAPER), Ingredient.fromItems(Items.PAPER), Ingredient.fromItems(Items.PAPER)), new ItemStack(Items.MAP));
    }

    @Override
    public boolean matches(InventoryCrafting inv, World worldIn) {
        if (!super.matches(inv, worldIn)) {
            return false;
        }
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < inv.getSizeInventory() && itemstack.isEmpty(); ++i) {
            ItemStack itemstack1 = inv.getStackInSlot(i);
            if (itemstack1.getItem() != Items.FILLED_MAP) continue;
            itemstack = itemstack1;
        }
        if (itemstack.isEmpty()) {
            return false;
        }
        MapData mapdata = Items.FILLED_MAP.getMapData(itemstack, worldIn);
        if (mapdata == null) {
            return false;
        }
        return this.isExplorationMap(mapdata) ? false : mapdata.scale < 4;
    }

    private boolean isExplorationMap(MapData p_190934_1_) {
        if (p_190934_1_.mapDecorations != null) {
            for (MapDecoration mapdecoration : p_190934_1_.mapDecorations.values()) {
                if (mapdecoration.getType() != MapDecoration.Type.MANSION && mapdecoration.getType() != MapDecoration.Type.MONUMENT) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < inv.getSizeInventory() && itemstack.isEmpty(); ++i) {
            ItemStack itemstack1 = inv.getStackInSlot(i);
            if (itemstack1.getItem() != Items.FILLED_MAP) continue;
            itemstack = itemstack1;
        }
        itemstack = itemstack.copy();
        itemstack.setCount(1);
        if (itemstack.getTagCompound() == null) {
            itemstack.setTagCompound(new NBTTagCompound());
        }
        itemstack.getTagCompound().setInteger("map_scale_direction", 1);
        return itemstack;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }
}

