/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.base.Predicate;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class Ingredient
implements Predicate<ItemStack> {
    private static final Set<Ingredient> INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    public static final Ingredient EMPTY = new Ingredient(new ItemStack[0]){

        @Override
        public boolean apply(@Nullable ItemStack p_apply_1_) {
            return p_apply_1_.isEmpty();
        }
    };
    private final ItemStack[] matchingStacks;
    private final ItemStack[] matchingStacksExploded;
    private IntList matchingStacksPacked;
    private final boolean isSimple;

    protected Ingredient(int size) {
        this(new ItemStack[size]);
    }

    protected Ingredient(ItemStack ... p_i47503_1_) {
        boolean simple = true;
        this.matchingStacks = p_i47503_1_;
        NonNullList<ItemStack> lst = NonNullList.create();
        for (ItemStack s : p_i47503_1_) {
            if (s.isEmpty()) continue;
            if (s.getItem().isDamageable()) {
                simple = false;
            }
            if (s.getMetadata() == Short.MAX_VALUE) {
                s.getItem().getSubItems(CreativeTabs.SEARCH, lst);
                continue;
            }
            lst.add(s);
        }
        this.matchingStacksExploded = lst.toArray(new ItemStack[lst.size()]);
        this.isSimple = simple && this.matchingStacksExploded.length > 0;
        INSTANCES.add(this);
    }

    public ItemStack[] getMatchingStacks() {
        return this.matchingStacksExploded;
    }

    public boolean apply(@Nullable ItemStack p_apply_1_) {
        if (p_apply_1_ == null) {
            return false;
        }
        for (ItemStack itemstack : this.matchingStacks) {
            int i;
            if (itemstack.getItem() != p_apply_1_.getItem() || (i = itemstack.getMetadata()) != Short.MAX_VALUE && i != p_apply_1_.getMetadata()) continue;
            return true;
        }
        return false;
    }

    public IntList getValidItemStacksPacked() {
        if (this.matchingStacksPacked == null) {
            this.matchingStacksPacked = new IntArrayList(this.matchingStacksExploded.length);
            for (ItemStack itemstack : this.matchingStacksExploded) {
                this.matchingStacksPacked.add(RecipeItemHelper.pack(itemstack));
            }
            this.matchingStacksPacked.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.matchingStacksPacked;
    }

    public static void invalidateAll() {
        for (Ingredient ing : INSTANCES) {
            if (ing == null) continue;
            ing.invalidate();
        }
    }

    protected void invalidate() {
        this.matchingStacksPacked = null;
    }

    public static Ingredient fromItem(Item p_193367_0_) {
        return Ingredient.fromStacks(new ItemStack(p_193367_0_, 1, Short.MAX_VALUE));
    }

    public static Ingredient fromItems(Item ... items) {
        ItemStack[] aitemstack = new ItemStack[items.length];
        for (int i = 0; i < items.length; ++i) {
            aitemstack[i] = new ItemStack(items[i]);
        }
        return Ingredient.fromStacks(aitemstack);
    }

    public static Ingredient fromStacks(ItemStack ... stacks) {
        if (stacks.length > 0) {
            for (ItemStack itemstack : stacks) {
                if (itemstack.isEmpty()) continue;
                return new Ingredient(stacks);
            }
        }
        return EMPTY;
    }

    public static Ingredient merge(Collection<Ingredient> parts) {
        NonNullList<ItemStack> lst = NonNullList.create();
        for (Ingredient part : parts) {
            for (ItemStack stack : part.matchingStacks) {
                lst.add(stack);
            }
        }
        return new Ingredient(lst.toArray(new ItemStack[lst.size()]));
    }

    public boolean isSimple() {
        return this.isSimple || this == EMPTY;
    }
}

