/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;

public class ItemPickaxe
extends ItemTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.ACTIVATOR_RAIL, Blocks.COAL_ORE, Blocks.COBBLESTONE, Blocks.DETECTOR_RAIL, Blocks.DIAMOND_BLOCK, Blocks.DIAMOND_ORE, Blocks.DOUBLE_STONE_SLAB, Blocks.GOLDEN_RAIL, Blocks.GOLD_BLOCK, Blocks.GOLD_ORE, Blocks.ICE, Blocks.IRON_BLOCK, Blocks.IRON_ORE, Blocks.LAPIS_BLOCK, Blocks.LAPIS_ORE, Blocks.LIT_REDSTONE_ORE, Blocks.MOSSY_COBBLESTONE, Blocks.NETHERRACK, Blocks.PACKED_ICE, Blocks.RAIL, Blocks.REDSTONE_ORE, Blocks.SANDSTONE, Blocks.RED_SANDSTONE, Blocks.STONE, Blocks.STONE_SLAB, Blocks.STONE_BUTTON, Blocks.STONE_PRESSURE_PLATE});

    protected ItemPickaxe(Item.ToolMaterial material) {
        super(1.0f, -2.8f, material, EFFECTIVE_ON);
    }

    @Override
    public boolean canHarvestBlock(IBlockState blockIn) {
        Block block = blockIn.getBlock();
        if (block == Blocks.OBSIDIAN) {
            return this.toolMaterial.getHarvestLevel() == 3;
        }
        if (block == Blocks.DIAMOND_BLOCK || block == Blocks.DIAMOND_ORE) {
            return this.toolMaterial.getHarvestLevel() >= 2;
        }
        if (block == Blocks.EMERALD_ORE || block == Blocks.EMERALD_BLOCK) {
            return this.toolMaterial.getHarvestLevel() >= 2;
        }
        if (block == Blocks.GOLD_BLOCK || block == Blocks.GOLD_ORE) {
            return this.toolMaterial.getHarvestLevel() >= 2;
        }
        if (block == Blocks.IRON_BLOCK || block == Blocks.IRON_ORE) {
            return this.toolMaterial.getHarvestLevel() >= 1;
        }
        if (block == Blocks.LAPIS_BLOCK || block == Blocks.LAPIS_ORE) {
            return this.toolMaterial.getHarvestLevel() >= 1;
        }
        if (block != Blocks.REDSTONE_ORE && block != Blocks.LIT_REDSTONE_ORE) {
            Material material = blockIn.getMaterial();
            if (material == Material.ROCK) {
                return true;
            }
            return material == Material.IRON ? true : material == Material.ANVIL;
        }
        return this.toolMaterial.getHarvestLevel() >= 2;
    }

    @Override
    public float getDestroySpeed(ItemStack stack, IBlockState state) {
        Material material = state.getMaterial();
        return material != Material.IRON && material != Material.ANVIL && material != Material.ROCK ? super.getDestroySpeed(stack, state) : this.efficiency;
    }
}

