/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractIllager
extends EntityMob {
    protected static final DataParameter<Byte> AGGRESSIVE = EntityDataManager.createKey(AbstractIllager.class, DataSerializers.BYTE);

    public AbstractIllager(World p_i47509_1_) {
        super(p_i47509_1_);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataManager.register(AGGRESSIVE, (byte)0);
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean isAggressive(int mask) {
        byte i = this.dataManager.get(AGGRESSIVE);
        return (i & mask) != 0;
    }

    protected void setAggressive(int mask, boolean value) {
        int i = this.dataManager.get(AGGRESSIVE).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.dataManager.set(AGGRESSIVE, (byte)(i & 0xFF));
    }

    @Override
    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ILLAGER;
    }

    @SideOnly(value=Side.CLIENT)
    public IllagerArmPose getArmPose() {
        return IllagerArmPose.CROSSED;
    }

    @SideOnly(value=Side.CLIENT)
    public static enum IllagerArmPose {
        CROSSED,
        ATTACKING,
        SPELLCASTING,
        BOW_AND_ARROW;

    }
}

