/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.util.math.Vec3d;

public class EntityAILlamaFollowCaravan
extends EntityAIBase {
    public EntityLlama llama;
    private double speedModifier;
    private int distCheckCounter;

    public EntityAILlamaFollowCaravan(EntityLlama llamaIn, double speedModifierIn) {
        this.llama = llamaIn;
        this.speedModifier = speedModifierIn;
        this.setMutexBits(1);
    }

    @Override
    public boolean shouldExecute() {
        if (!this.llama.getLeashed() && !this.llama.inCaravan()) {
            List<?> list = this.llama.world.getEntitiesWithinAABB(this.llama.getClass(), this.llama.getEntityBoundingBox().grow(9.0, 4.0, 9.0));
            EntityLiving entityllama = null;
            double d0 = Double.MAX_VALUE;
            for (EntityLlama entityllama1 : list) {
                double d1;
                if (!entityllama1.inCaravan() || entityllama1.hasCaravanTrail() || (d1 = this.llama.getDistanceSq(entityllama1)) > d0) continue;
                d0 = d1;
                entityllama = entityllama1;
            }
            if (entityllama == null) {
                for (EntityLlama entityllama2 : list) {
                    double d2;
                    if (!entityllama2.getLeashed() || entityllama2.hasCaravanTrail() || (d2 = this.llama.getDistanceSq(entityllama2)) > d0) continue;
                    d0 = d2;
                    entityllama = entityllama2;
                }
            }
            if (entityllama == null) {
                return false;
            }
            if (d0 < 4.0) {
                return false;
            }
            if (!entityllama.getLeashed() && !this.firstIsLeashed((EntityLlama)entityllama, 1)) {
                return false;
            }
            this.llama.joinCaravan((EntityLlama)entityllama);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldContinueExecuting() {
        if (this.llama.inCaravan() && this.llama.getCaravanHead().isEntityAlive() && this.firstIsLeashed(this.llama, 0)) {
            double d0 = this.llama.getDistanceSq(this.llama.getCaravanHead());
            if (d0 > 676.0) {
                if (this.speedModifier <= 3.0) {
                    this.speedModifier *= 1.2;
                    this.distCheckCounter = 40;
                    return true;
                }
                if (this.distCheckCounter == 0) {
                    return false;
                }
            }
            if (this.distCheckCounter > 0) {
                --this.distCheckCounter;
            }
            return true;
        }
        return false;
    }

    @Override
    public void resetTask() {
        this.llama.leaveCaravan();
        this.speedModifier = 2.1;
    }

    @Override
    public void updateTask() {
        if (this.llama.inCaravan()) {
            EntityLlama entityllama = this.llama.getCaravanHead();
            double d0 = this.llama.getDistance(entityllama);
            float f = 2.0f;
            Vec3d vec3d = new Vec3d(entityllama.posX - this.llama.posX, entityllama.posY - this.llama.posY, entityllama.posZ - this.llama.posZ).normalize().scale(Math.max(d0 - 2.0, 0.0));
            this.llama.getNavigator().tryMoveToXYZ(this.llama.posX + vec3d.x, this.llama.posY + vec3d.y, this.llama.posZ + vec3d.z, this.speedModifier);
        }
    }

    private boolean firstIsLeashed(EntityLlama p_190858_1_, int p_190858_2_) {
        if (p_190858_2_ > 8) {
            return false;
        }
        if (p_190858_1_.inCaravan()) {
            return p_190858_1_.getCaravanHead().getLeashed() ? true : this.firstIsLeashed(p_190858_1_.getCaravanHead(), ++p_190858_2_);
        }
        return false;
    }
}

