/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityAIHarvestFarmland
extends EntityAIMoveToBlock {
    private final EntityVillager villager;
    private boolean hasFarmItem;
    private boolean wantsToReapStuff;
    private int currentTask;

    public EntityAIHarvestFarmland(EntityVillager villagerIn, double speedIn) {
        super(villagerIn, speedIn, 16);
        this.villager = villagerIn;
    }

    @Override
    public boolean shouldExecute() {
        if (this.runDelay <= 0) {
            if (!ForgeEventFactory.getMobGriefingEvent(this.villager.world, this.villager)) {
                return false;
            }
            this.currentTask = -1;
            this.hasFarmItem = this.villager.isFarmItemInInventory();
            this.wantsToReapStuff = this.villager.wantsMoreFood();
        }
        return super.shouldExecute();
    }

    @Override
    public boolean shouldContinueExecuting() {
        return this.currentTask >= 0 && super.shouldContinueExecuting();
    }

    @Override
    public void updateTask() {
        super.updateTask();
        this.villager.getLookHelper().setLookPosition((double)this.destinationBlock.getX() + 0.5, this.destinationBlock.getY() + 1, (double)this.destinationBlock.getZ() + 0.5, 10.0f, this.villager.getVerticalFaceSpeed());
        if (this.getIsAboveDestination()) {
            World world = this.villager.world;
            BlockPos blockpos = this.destinationBlock.up();
            IBlockState iblockstate = world.getBlockState(blockpos);
            Block block = iblockstate.getBlock();
            if (this.currentTask == 0 && block instanceof BlockCrops && ((BlockCrops)block).isMaxAge(iblockstate)) {
                world.destroyBlock(blockpos, true);
            } else if (this.currentTask == 1 && iblockstate.getMaterial() == Material.AIR) {
                InventoryBasic inventorybasic = this.villager.getVillagerInventory();
                for (int i = 0; i < inventorybasic.getSizeInventory(); ++i) {
                    ItemStack itemstack = inventorybasic.getStackInSlot(i);
                    boolean flag = false;
                    if (!itemstack.isEmpty()) {
                        if (itemstack.getItem() == Items.WHEAT_SEEDS) {
                            world.setBlockState(blockpos, Blocks.WHEAT.getDefaultState(), 3);
                            flag = true;
                        } else if (itemstack.getItem() == Items.POTATO) {
                            world.setBlockState(blockpos, Blocks.POTATOES.getDefaultState(), 3);
                            flag = true;
                        } else if (itemstack.getItem() == Items.CARROT) {
                            world.setBlockState(blockpos, Blocks.CARROTS.getDefaultState(), 3);
                            flag = true;
                        } else if (itemstack.getItem() == Items.BEETROOT_SEEDS) {
                            world.setBlockState(blockpos, Blocks.BEETROOTS.getDefaultState(), 3);
                            flag = true;
                        } else if (itemstack.getItem() instanceof IPlantable && ((IPlantable)((Object)itemstack.getItem())).getPlantType(world, blockpos) == EnumPlantType.Crop) {
                            world.setBlockState(blockpos, ((IPlantable)((Object)itemstack.getItem())).getPlant(world, blockpos), 3);
                            flag = true;
                        }
                    }
                    if (!flag) continue;
                    itemstack.shrink(1);
                    if (!itemstack.isEmpty()) break;
                    inventorybasic.setInventorySlotContents(i, ItemStack.EMPTY);
                    break;
                }
            }
            this.currentTask = -1;
            this.runDelay = 10;
        }
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        Block block = worldIn.getBlockState(pos).getBlock();
        if (block == Blocks.FARMLAND) {
            IBlockState iblockstate = worldIn.getBlockState(pos = pos.up());
            block = iblockstate.getBlock();
            if (block instanceof BlockCrops && ((BlockCrops)block).isMaxAge(iblockstate) && this.wantsToReapStuff && (this.currentTask == 0 || this.currentTask < 0)) {
                this.currentTask = 0;
                return true;
            }
            if (iblockstate.getMaterial() == Material.AIR && this.hasFarmItem && (this.currentTask == 1 || this.currentTask < 0)) {
                this.currentTask = 1;
                return true;
            }
        }
        return false;
    }
}

