/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class JsonException
extends IOException {
    private final List<Entry> entries = Lists.newArrayList();
    private final String message;

    public JsonException(String messageIn) {
        this.entries.add(new Entry());
        this.message = messageIn;
    }

    public JsonException(String messageIn, Throwable cause) {
        super(cause);
        this.entries.add(new Entry());
        this.message = messageIn;
    }

    public void prependJsonKey(String key) {
        this.entries.get(0).addJsonKey(key);
    }

    public void setFilenameAndFlush(String filenameIn) {
        this.entries.get((int)0).filename = filenameIn;
        this.entries.add(0, new Entry());
    }

    @Override
    public String getMessage() {
        return "Invalid " + String.valueOf(this.entries.get(this.entries.size() - 1)) + ": " + this.message;
    }

    public static JsonException forException(Exception exception) {
        if (exception instanceof JsonException) {
            return (JsonException)exception;
        }
        String s = exception.getMessage();
        if (exception instanceof FileNotFoundException) {
            s = "File not found";
        }
        return new JsonException(s, exception);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Entry {
        private String filename;
        private final List<String> jsonKeys = Lists.newArrayList();

        private Entry() {
        }

        private void addJsonKey(String key) {
            this.jsonKeys.add(0, key);
        }

        public String getJsonKeys() {
            return StringUtils.join(this.jsonKeys, (String)"->");
        }

        public String toString() {
            if (this.filename != null) {
                return this.jsonKeys.isEmpty() ? this.filename : this.filename + " " + this.getJsonKeys();
            }
            return this.jsonKeys.isEmpty() ? "(Unknown file)" : "(Unknown file) " + this.getJsonKeys();
        }
    }
}

