/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.settings;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class KeyBinding
implements Comparable<KeyBinding> {
    private static final Map<String, KeyBinding> KEYBIND_ARRAY = Maps.newHashMap();
    private static final KeyBindingMap HASH = new KeyBindingMap();
    private static final Set<String> KEYBIND_SET = Sets.newHashSet();
    private static final Map<String, Integer> CATEGORY_ORDER = Maps.newHashMap();
    private final String keyDescription;
    private final int keyCodeDefault;
    private final String keyCategory;
    private int keyCode;
    private boolean pressed;
    private int pressTime;
    private KeyModifier keyModifierDefault = KeyModifier.NONE;
    private KeyModifier keyModifier = KeyModifier.NONE;
    private IKeyConflictContext keyConflictContext = KeyConflictContext.UNIVERSAL;

    public static void onTick(int keyCode) {
        if (keyCode != 0) {
            HASH.lookupActives(keyCode).forEach($ -> ++$.pressTime);
        }
    }

    public static void setKeyBindState(int keyCode, boolean pressed) {
        if (keyCode != 0) {
            for (KeyBinding keybinding : HASH.lookupAll(keyCode)) {
                if (keybinding == null) continue;
                keybinding.pressed = pressed;
            }
        }
    }

    public static void updateKeyBindState() {
        for (KeyBinding keybinding : KEYBIND_ARRAY.values()) {
            try {
                KeyBinding.setKeyBindState(keybinding.keyCode, keybinding.keyCode < 256 && Keyboard.isKeyDown((int)keybinding.keyCode));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
    }

    public static void unPressAllKeys() {
        for (KeyBinding keybinding : KEYBIND_ARRAY.values()) {
            keybinding.unpressKey();
        }
    }

    public static void resetKeyBindingArrayAndHash() {
        HASH.clearMap();
        for (KeyBinding keybinding : KEYBIND_ARRAY.values()) {
            HASH.addKey(keybinding.keyCode, keybinding);
        }
    }

    public static Set<String> getKeybinds() {
        return KEYBIND_SET;
    }

    public KeyBinding(String description, int keyCode, String category) {
        this.keyDescription = description;
        this.keyCode = keyCode;
        this.keyCodeDefault = keyCode;
        this.keyCategory = category;
        KEYBIND_ARRAY.put(description, this);
        HASH.addKey(keyCode, this);
        KEYBIND_SET.add(category);
    }

    public boolean isKeyDown() {
        return this.pressed && this.getKeyConflictContext().isActive() && this.getKeyModifier().isActive(this.getKeyConflictContext());
    }

    public String getKeyCategory() {
        return this.keyCategory;
    }

    public boolean isPressed() {
        if (this.pressTime == 0) {
            return false;
        }
        --this.pressTime;
        return true;
    }

    private void unpressKey() {
        this.pressTime = 0;
        this.pressed = false;
    }

    public String getKeyDescription() {
        return this.keyDescription;
    }

    public int getKeyCodeDefault() {
        return this.keyCodeDefault;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }

    @Override
    public int compareTo(KeyBinding p_compareTo_1_) {
        if (this.keyCategory.equals(p_compareTo_1_.keyCategory)) {
            return I18n.format(this.keyDescription, new Object[0]).compareTo(I18n.format(p_compareTo_1_.keyDescription, new Object[0]));
        }
        Integer tCat = CATEGORY_ORDER.get(this.keyCategory);
        Integer oCat = CATEGORY_ORDER.get(p_compareTo_1_.keyCategory);
        if (tCat == null && oCat != null) {
            return 1;
        }
        if (tCat != null && oCat == null) {
            return -1;
        }
        if (tCat == null && oCat == null) {
            return I18n.format(this.keyCategory, new Object[0]).compareTo(I18n.format(p_compareTo_1_.keyCategory, new Object[0]));
        }
        return tCat.compareTo(oCat);
    }

    public KeyBinding(String description, IKeyConflictContext keyConflictContext, int keyCode, String category) {
        this(description, keyConflictContext, KeyModifier.NONE, keyCode, category);
    }

    public KeyBinding(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode, String category) {
        this.keyDescription = description;
        this.keyCode = keyCode;
        this.keyCodeDefault = keyCode;
        this.keyCategory = category;
        this.keyConflictContext = keyConflictContext;
        this.keyModifier = keyModifier;
        this.keyModifierDefault = keyModifier;
        if (this.keyModifier.matches(keyCode)) {
            this.keyModifier = KeyModifier.NONE;
        }
        KEYBIND_ARRAY.put(description, this);
        HASH.addKey(keyCode, this);
        KEYBIND_SET.add(category);
    }

    public boolean isActiveAndMatches(int keyCode) {
        return keyCode != 0 && keyCode == this.getKeyCode() && this.getKeyConflictContext().isActive() && this.getKeyModifier().isActive(this.getKeyConflictContext());
    }

    public void setKeyConflictContext(IKeyConflictContext keyConflictContext) {
        this.keyConflictContext = keyConflictContext;
    }

    public IKeyConflictContext getKeyConflictContext() {
        return this.keyConflictContext;
    }

    public KeyModifier getKeyModifierDefault() {
        return this.keyModifierDefault;
    }

    public KeyModifier getKeyModifier() {
        return this.keyModifier;
    }

    public void setKeyModifierAndCode(KeyModifier keyModifier, int keyCode) {
        this.keyCode = keyCode;
        if (keyModifier.matches(keyCode)) {
            keyModifier = KeyModifier.NONE;
        }
        HASH.removeKey(this);
        this.keyModifier = keyModifier;
        HASH.addKey(keyCode, this);
    }

    public void setToDefault() {
        this.setKeyModifierAndCode(this.getKeyModifierDefault(), this.getKeyCodeDefault());
    }

    public boolean isSetToDefaultValue() {
        return this.getKeyCode() == this.getKeyCodeDefault() && this.getKeyModifier() == this.getKeyModifierDefault();
    }

    public boolean conflicts(KeyBinding other) {
        if (this.getKeyConflictContext().conflicts(other.getKeyConflictContext()) || other.getKeyConflictContext().conflicts(this.getKeyConflictContext())) {
            KeyModifier keyModifier = this.getKeyModifier();
            KeyModifier otherKeyModifier = other.getKeyModifier();
            if (keyModifier.matches(other.getKeyCode()) || otherKeyModifier.matches(this.getKeyCode())) {
                return true;
            }
            if (this.getKeyCode() == other.getKeyCode()) {
                return keyModifier == otherKeyModifier || this.getKeyConflictContext().conflicts(KeyConflictContext.IN_GAME) && (keyModifier == KeyModifier.NONE || otherKeyModifier == KeyModifier.NONE);
            }
        }
        return false;
    }

    public boolean hasKeyCodeModifierConflict(KeyBinding other) {
        return !(!this.getKeyConflictContext().conflicts(other.getKeyConflictContext()) && !other.getKeyConflictContext().conflicts(this.getKeyConflictContext()) || !this.getKeyModifier().matches(other.getKeyCode()) && !other.getKeyModifier().matches(this.getKeyCode()));
    }

    public String getDisplayName() {
        return this.getKeyModifier().getLocalizedComboName(this.getKeyCode());
    }

    public static Supplier<String> getDisplayString(String key) {
        KeyBinding keybinding = KEYBIND_ARRAY.get(key);
        return keybinding == null ? () -> key : () -> keybinding.getDisplayName();
    }

    static {
        CATEGORY_ORDER.put("key.categories.movement", 1);
        CATEGORY_ORDER.put("key.categories.gameplay", 2);
        CATEGORY_ORDER.put("key.categories.inventory", 3);
        CATEGORY_ORDER.put("key.categories.creative", 4);
        CATEGORY_ORDER.put("key.categories.multiplayer", 5);
        CATEGORY_ORDER.put("key.categories.ui", 6);
        CATEGORY_ORDER.put("key.categories.misc", 7);
    }
}

