/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LegacyV2Adapter
implements IResourcePack {
    private final IResourcePack pack;

    public LegacyV2Adapter(IResourcePack packIn) {
        this.pack = packIn;
    }

    @Override
    public InputStream getInputStream(ResourceLocation location) throws IOException {
        return this.pack.getInputStream(this.fudgePath(location));
    }

    private ResourceLocation fudgePath(ResourceLocation p_191382_1_) {
        int i;
        String s = p_191382_1_.getPath();
        if (!"lang/swg_de.lang".equals(s) && s.startsWith("lang/") && s.endsWith(".lang") && (i = s.indexOf(95)) != -1) {
            final String s1 = s.substring(0, i + 1) + s.substring(i + 1, s.indexOf(46, i)).toUpperCase() + ".lang";
            return new ResourceLocation(this, p_191382_1_.getNamespace(), ""){

                @Override
                public String getPath() {
                    return s1;
                }
            };
        }
        return p_191382_1_;
    }

    @Override
    public boolean resourceExists(ResourceLocation location) {
        return this.pack.resourceExists(this.fudgePath(location));
    }

    @Override
    public Set<String> getResourceDomains() {
        return this.pack.getResourceDomains();
    }

    @Override
    @Nullable
    public <T extends IMetadataSection> T getPackMetadata(MetadataSerializer metadataSerializer, String metadataSectionName) throws IOException {
        return this.pack.getPackMetadata(metadataSerializer, metadataSectionName);
    }

    @Override
    public BufferedImage getPackImage() throws IOException {
        return this.pack.getPackImage();
    }

    @Override
    public String getPackName() {
        return this.pack.getPackName();
    }

    public IResourcePack getUnadaptedPack() {
        return this.pack;
    }
}

