/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.ResourcePackFileNotFoundException;
import net.minecraft.util.Util;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

@SideOnly(value=Side.CLIENT)
public class FolderResourcePack
extends AbstractResourcePack {
    private static final boolean ON_WINDOWS = Util.getOSType() == Util.EnumOS.WINDOWS;
    private static final CharMatcher BACKSLASH_MATCHER = CharMatcher.is((char)'\\');

    public FolderResourcePack(File resourcePackFileIn) {
        super(resourcePackFileIn);
    }

    protected static boolean validatePath(File p_191384_0_, String p_191384_1_) throws IOException {
        String s = p_191384_0_.getCanonicalPath();
        if (ON_WINDOWS) {
            s = BACKSLASH_MATCHER.replaceFrom((CharSequence)s, '/');
        }
        return s.endsWith(p_191384_1_);
    }

    @Override
    protected InputStream getInputStreamByName(String name) throws IOException {
        File file1 = this.getFile(name);
        if (file1 == null) {
            throw new ResourcePackFileNotFoundException(this.resourcePackFile, name);
        }
        return new BufferedInputStream(new FileInputStream(file1));
    }

    @Override
    protected boolean hasResourceName(String name) {
        return this.getFile(name) != null;
    }

    @Nullable
    private File getFile(String p_191385_1_) {
        try {
            File file1 = new File(this.resourcePackFile, p_191385_1_);
            if (file1.isFile() && FolderResourcePack.validatePath(file1, p_191385_1_)) {
                return file1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Set<String> getResourceDomains() {
        HashSet set = Sets.newHashSet();
        File file1 = new File(this.resourcePackFile, "assets/");
        if (file1.isDirectory()) {
            for (File file2 : file1.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
                String s = FolderResourcePack.getRelativeName(file1, file2);
                if (s.equals(s.toLowerCase(Locale.ROOT))) {
                    set.add(s.substring(0, s.length() - 1));
                    continue;
                }
                this.logNameNotLowercase(s);
            }
        }
        return set;
    }
}

