/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelVex;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderVex
extends RenderBiped<EntityVex> {
    private static final ResourceLocation VEX_TEXTURE = new ResourceLocation("textures/entity/illager/vex.png");
    private static final ResourceLocation VEX_CHARGING_TEXTURE = new ResourceLocation("textures/entity/illager/vex_charging.png");
    private int modelVersion;

    public RenderVex(RenderManager renderManagerIn) {
        super(renderManagerIn, new ModelVex(), 0.3f);
        this.modelVersion = ((ModelVex)this.mainModel).getModelVersion();
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityVex entity) {
        return entity.isCharging() ? VEX_CHARGING_TEXTURE : VEX_TEXTURE;
    }

    @Override
    public void doRender(EntityVex entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int i = ((ModelVex)this.mainModel).getModelVersion();
        if (i != this.modelVersion) {
            this.mainModel = new ModelVex();
            this.modelVersion = i;
        }
        super.doRender(entity, x, y, z, entityYaw, partialTicks);
    }

    @Override
    protected void preRenderCallback(EntityVex entitylivingbaseIn, float partialTickTime) {
        GlStateManager.scale(0.4f, 0.4f, 0.4f);
    }
}

