/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import net.minecraft.client.model.ModelBat;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderBat
extends RenderLiving<EntityBat> {
    private static final ResourceLocation BAT_TEXTURES = new ResourceLocation("textures/entity/bat.png");

    public RenderBat(RenderManager renderManagerIn) {
        super(renderManagerIn, new ModelBat(), 0.25f);
    }

    @Override
    protected ResourceLocation getEntityTexture(EntityBat entity) {
        return BAT_TEXTURES;
    }

    @Override
    protected void preRenderCallback(EntityBat entitylivingbaseIn, float partialTickTime) {
        GlStateManager.scale(0.35f, 0.35f, 0.35f);
    }

    @Override
    protected void applyRotations(EntityBat entityLiving, float ageInTicks, float rotationYaw, float partialTicks) {
        if (entityLiving.getIsBatHanging()) {
            GlStateManager.translate(0.0f, -0.1f, 0.0f);
        } else {
            GlStateManager.translate(0.0f, MathHelper.cos(ageInTicks * 0.3f) * 0.1f, 0.0f);
        }
        super.applyRotations(entityLiving, ageInTicks, rotationYaw, partialTicks);
    }
}

