/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.cleanroommc.client.BreakIteratorHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiUtilRenderComponents {
    public static String removeTextColorsIfConfigured(String text, boolean forceColor) {
        return !forceColor && !Minecraft.getMinecraft().gameSettings.chatColours ? TextFormatting.getTextWithoutFormattingCodes(text) : text;
    }

    public static List<ITextComponent> splitText(ITextComponent textComponent, int maxTextLenght, FontRenderer fontRendererIn, boolean p_178908_3_, boolean forceTextColor) {
        boolean wrapped;
        int j;
        int accumlateWidth = 0;
        ArrayList list = Lists.newArrayList();
        ArrayList cache = Lists.newArrayList();
        ArrayList styleCache = Lists.newArrayList();
        ArrayList newLineCache = Lists.newArrayList();
        ArrayList originList = Lists.newArrayList((Iterable)textComponent);
        for (j = 0; j < originList.size(); ++j) {
            ITextComponent originLine = (ITextComponent)originList.get(j);
            String unformattedOriginLine = originLine.getUnformattedComponentText();
            if (unformattedOriginLine.contains("\n")) {
                int k = unformattedOriginLine.indexOf(10);
                String stringAfter = unformattedOriginLine.substring(k + 1);
                unformattedOriginLine = unformattedOriginLine.substring(0, k + 1);
                TextComponentString textAfterN = new TextComponentString(stringAfter);
                textAfterN.setStyle(originLine.getStyle().createShallowCopy());
                originList.add(j + 1, textAfterN);
                wrapped = true;
            } else {
                wrapped = false;
            }
            String rebuiltOriginLine = GuiUtilRenderComponents.removeTextColorsIfConfigured(originLine.getStyle().getFormattingCode() + unformattedOriginLine, forceTextColor);
            String cleanedLine = rebuiltOriginLine.endsWith("\n") ? rebuiltOriginLine.substring(0, rebuiltOriginLine.length() - 1) : rebuiltOriginLine;
            cache.add(cleanedLine);
            styleCache.add(originLine.getStyle());
            newLineCache.add(wrapped);
        }
        BreakIteratorHolder.BREAK_ITERATOR.setText(String.join((CharSequence)"\n", cache));
        int fed = 0;
        TextComponentString lineToAdd = new TextComponentString("");
        for (j = 0; j < cache.size(); ++j) {
            String cleanedLine = (String)cache.get(j);
            Style style = (Style)styleCache.get(j);
            wrapped = (Boolean)newLineCache.get(j);
            int lineWidth = fontRendererIn.getStringWidth(cleanedLine);
            TextComponentString line = new TextComponentString(cleanedLine);
            line.setStyle(style.createShallowCopy());
            if (accumlateWidth + lineWidth > maxTextLenght) {
                Object secondHalf;
                String firstHalf = fontRendererIn.trimStringToWidth(cleanedLine, maxTextLenght - accumlateWidth, false);
                Object object = secondHalf = firstHalf.length() < cleanedLine.length() ? cleanedLine.substring(firstHalf.length()) : null;
                if (secondHalf != null) {
                    int l = BreakIteratorHolder.BREAK_ITERATOR.preceding(fed + firstHalf.length()) - fed;
                    if (l >= 0 && fontRendererIn.getStringWidth(cleanedLine.substring(0, l)) > 0) {
                        firstHalf = cleanedLine.substring(0, l);
                        if (p_178908_3_ && cleanedLine.charAt(l) == ' ') {
                            ++l;
                        }
                        secondHalf = cleanedLine.substring(l);
                    } else if (accumlateWidth > 0 && !cleanedLine.contains(" ")) {
                        firstHalf = "";
                        secondHalf = cleanedLine;
                    }
                    secondHalf = FontRenderer.getFormatFromString(firstHalf) + (String)secondHalf;
                    cache.set(j, secondHalf);
                    --j;
                }
                lineWidth = fontRendererIn.getStringWidth(firstHalf);
                line = new TextComponentString(firstHalf);
                line.setStyle(style.createShallowCopy());
                wrapped = true;
            }
            if (accumlateWidth + lineWidth <= maxTextLenght) {
                accumlateWidth += lineWidth;
                lineToAdd.appendSibling(line);
                fed += line.getText().length();
            } else {
                wrapped = true;
            }
            if (!wrapped) continue;
            list.add(lineToAdd);
            accumlateWidth = 0;
            lineToAdd = new TextComponentString("");
        }
        list.add(lineToAdd);
        return list;
    }
}

