/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBarrier;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockBone;
import net.minecraft.block.BlockBookshelf;
import net.minecraft.block.BlockBrewingStand;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockButtonStone;
import net.minecraft.block.BlockButtonWood;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.BlockChorusPlant;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockCompressedPowered;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDaylightDetector;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockDoubleStoneSlab;
import net.minecraft.block.BlockDoubleStoneSlabNew;
import net.minecraft.block.BlockDoubleWoodSlab;
import net.minecraft.block.BlockDragonEgg;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockEmptyDrops;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockFrostedIce;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGlazedTerracotta;
import net.minecraft.block.BlockGlowstone;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHalfStoneSlab;
import net.minecraft.block.BlockHalfStoneSlabNew;
import net.minecraft.block.BlockHalfWoodSlab;
import net.minecraft.block.BlockHardenedClay;
import net.minecraft.block.BlockHay;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLilyPad;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockNetherBrick;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockNetherrack;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockNote;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockObsidian;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.BlockPressurePlateWeighted;
import net.minecraft.block.BlockPrismarine;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockPurpurSlab;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailDetector;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedFlower;
import net.minecraft.block.BlockRedSandstone;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneOre;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSeaLantern;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSlime;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStainedHardenedClay;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.BlockStructureVoid;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWire;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.BlockYellowFlower;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespacedDefaultedByKey;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Block
extends IForgeRegistryEntry.Impl<Block> {
    private static final ResourceLocation AIR_ID = new ResourceLocation("air");
    public static final RegistryNamespacedDefaultedByKey<ResourceLocation, Block> REGISTRY = GameData.getWrapperDefaulted(Block.class);
    @Deprecated
    public static final ObjectIntIdentityMap<IBlockState> BLOCK_STATE_IDS = GameData.getBlockStateIDMap();
    public static final AxisAlignedBB FULL_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    @Nullable
    public static final AxisAlignedBB NULL_AABB = null;
    private CreativeTabs displayOnCreativeTab;
    protected boolean fullBlock;
    protected int lightOpacity;
    protected boolean translucent;
    protected int lightValue;
    protected boolean useNeighborBrightness;
    protected float blockHardness;
    protected float blockResistance;
    protected boolean enableStats = true;
    protected boolean needsRandomTick;
    protected boolean hasTileEntity;
    protected SoundType blockSoundType = SoundType.STONE;
    public float blockParticleGravity = 1.0f;
    protected final Material material;
    protected final MapColor blockMapColor;
    @Deprecated
    public float slipperiness = 0.6f;
    protected final BlockStateContainer blockState;
    private IBlockState defaultBlockState;
    private String translationKey;
    protected ThreadLocal<EntityPlayer> harvesters = new ThreadLocal();
    private ThreadLocal<IBlockState> silk_check_state = new ThreadLocal();
    protected static Random RANDOM = new Random();
    private boolean isTileProvider = this instanceof ITileEntityProvider;
    private String[] harvestTool = new String[16];
    private int[] harvestLevel = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    protected static ThreadLocal<Boolean> captureDrops = ThreadLocal.withInitial(() -> false);
    protected static ThreadLocal<NonNullList<ItemStack>> capturedDrops = ThreadLocal.withInitial(NonNullList::create);

    public static int getIdFromBlock(Block blockIn) {
        return REGISTRY.getIDForObject(blockIn);
    }

    public static int getStateId(IBlockState state) {
        Block block = state.getBlock();
        return Block.getIdFromBlock(block) + (block.getMetaFromState(state) << 12);
    }

    public static Block getBlockById(int id) {
        return REGISTRY.getObjectById(id);
    }

    public static IBlockState getStateById(int id) {
        int i = id & 0xFFF;
        int j = id >> 12 & 0xF;
        return Block.getBlockById(i).getStateFromMeta(j);
    }

    public static Block getBlockFromItem(@Nullable Item itemIn) {
        return itemIn instanceof ItemBlock ? ((ItemBlock)itemIn).getBlock() : Blocks.AIR;
    }

    @Nullable
    public static Block getBlockFromName(String name) {
        ResourceLocation resourcelocation = new ResourceLocation(name);
        if (REGISTRY.containsKey(resourcelocation)) {
            return REGISTRY.getObject(resourcelocation);
        }
        try {
            return REGISTRY.getObjectById(Integer.parseInt(name));
        }
        catch (NumberFormatException numberformatexception) {
            return null;
        }
    }

    @Deprecated
    public boolean isTopSolid(IBlockState state) {
        return state.getMaterial().isOpaque() && state.isFullCube();
    }

    @Deprecated
    public boolean isFullBlock(IBlockState state) {
        return this.fullBlock;
    }

    @Deprecated
    public boolean canEntitySpawn(IBlockState state, Entity entityIn) {
        return true;
    }

    @Deprecated
    public int getLightOpacity(IBlockState state) {
        return this.lightOpacity;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean isTranslucent(IBlockState state) {
        return this.translucent;
    }

    @Deprecated
    public int getLightValue(IBlockState state) {
        return this.lightValue;
    }

    @Deprecated
    public boolean getUseNeighborBrightness(IBlockState state) {
        return this.useNeighborBrightness;
    }

    @Deprecated
    public Material getMaterial(IBlockState state) {
        return this.material;
    }

    @Deprecated
    public MapColor getMapColor(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.blockMapColor;
    }

    @Deprecated
    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState();
    }

    public int getMetaFromState(IBlockState state) {
        if (state.getPropertyKeys().isEmpty()) {
            return 0;
        }
        throw new IllegalArgumentException("Don't know how to convert " + String.valueOf(state) + " back into data...");
    }

    @Deprecated
    public IBlockState getActualState(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    @Deprecated
    public IBlockState withRotation(IBlockState state, Rotation rot) {
        return state;
    }

    @Deprecated
    public IBlockState withMirror(IBlockState state, Mirror mirrorIn) {
        return state;
    }

    public Block(Material blockMaterialIn, MapColor blockMapColorIn) {
        this.material = blockMaterialIn;
        this.blockMapColor = blockMapColorIn;
        this.blockState = this.createBlockState();
        this.setDefaultState(this.blockState.getBaseState());
        this.fullBlock = this.getDefaultState().isOpaqueCube();
        this.lightOpacity = this.fullBlock ? 255 : 0;
        this.translucent = !blockMaterialIn.blocksLight();
    }

    public Block(Material materialIn) {
        this(materialIn, materialIn.getMaterialMapColor());
    }

    protected Block setSoundType(SoundType sound) {
        this.blockSoundType = sound;
        return this;
    }

    public Block setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
        return this;
    }

    public Block setLightLevel(float value) {
        this.lightValue = (int)(15.0f * value);
        return this;
    }

    public Block setResistance(float resistance) {
        this.blockResistance = resistance * 3.0f;
        return this;
    }

    protected static boolean isExceptionBlockForAttaching(Block attachBlock) {
        return attachBlock instanceof BlockShulkerBox || attachBlock instanceof BlockLeaves || attachBlock instanceof BlockTrapDoor || attachBlock == Blocks.BEACON || attachBlock == Blocks.CAULDRON || attachBlock == Blocks.GLASS || attachBlock == Blocks.GLOWSTONE || attachBlock == Blocks.ICE || attachBlock == Blocks.SEA_LANTERN || attachBlock == Blocks.STAINED_GLASS;
    }

    protected static boolean isExceptBlockForAttachWithPiston(Block attachBlock) {
        return Block.isExceptionBlockForAttaching(attachBlock) || attachBlock == Blocks.PISTON || attachBlock == Blocks.STICKY_PISTON || attachBlock == Blocks.PISTON_HEAD;
    }

    @Deprecated
    public boolean isBlockNormalCube(IBlockState state) {
        return state.getMaterial().blocksMovement() && state.isFullCube();
    }

    @Deprecated
    public boolean isNormalCube(IBlockState state) {
        return state.getMaterial().isOpaque() && state.isFullCube() && !state.canProvidePower();
    }

    @Deprecated
    public boolean causesSuffocation(IBlockState state) {
        return this.material.blocksMovement() && this.getDefaultState().isFullCube();
    }

    @Deprecated
    public boolean isFullCube(IBlockState state) {
        return true;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean hasCustomBreakingProgress(IBlockState state) {
        return false;
    }

    public boolean isPassable(IBlockAccess worldIn, BlockPos pos) {
        return !this.material.blocksMovement();
    }

    @Deprecated
    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean isReplaceable(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos).getMaterial().isReplaceable();
    }

    public Block setHardness(float hardness) {
        this.blockHardness = hardness;
        if (this.blockResistance < hardness * 5.0f) {
            this.blockResistance = hardness * 5.0f;
        }
        return this;
    }

    public Block setBlockUnbreakable() {
        this.setHardness(-1.0f);
        return this;
    }

    @Deprecated
    public float getBlockHardness(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.blockHardness;
    }

    public Block setTickRandomly(boolean shouldTick) {
        this.needsRandomTick = shouldTick;
        return this;
    }

    public boolean getTickRandomly() {
        return this.needsRandomTick;
    }

    @Deprecated
    public boolean hasTileEntity() {
        return this.hasTileEntity(this.getDefaultState());
    }

    @Deprecated
    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FULL_BLOCK_AABB;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public int getPackedLightmapCoords(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = source.getCombinedLight(pos, state.getLightValue(source, pos));
        if (i == 0 && state.getBlock() instanceof BlockSlab) {
            pos = pos.down();
            state = source.getBlockState(pos);
            return source.getCombinedLight(pos, state.getLightValue(source, pos));
        }
        return i;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        AxisAlignedBB axisalignedbb = blockState.getBoundingBox(blockAccess, pos);
        switch (side) {
            case DOWN: {
                if (!(axisalignedbb.minY > 0.0)) break;
                return true;
            }
            case UP: {
                if (!(axisalignedbb.maxY < 1.0)) break;
                return true;
            }
            case NORTH: {
                if (!(axisalignedbb.minZ > 0.0)) break;
                return true;
            }
            case SOUTH: {
                if (!(axisalignedbb.maxZ < 1.0)) break;
                return true;
            }
            case WEST: {
                if (!(axisalignedbb.minX > 0.0)) break;
                return true;
            }
            case EAST: {
                if (!(axisalignedbb.maxX < 1.0)) break;
                return true;
            }
        }
        return !blockAccess.getBlockState(pos.offset(side)).doesSideBlockRendering(blockAccess, pos.offset(side), side.getOpposite());
    }

    @Deprecated
    public BlockFaceShape getBlockFaceShape(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getSelectedBoundingBox(IBlockState state, World worldIn, BlockPos pos) {
        return state.getBoundingBox(worldIn, pos).offset(pos);
    }

    @Deprecated
    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        Block.addCollisionBoxToList(pos, entityBox, collidingBoxes, state.getCollisionBoundingBox(worldIn, pos));
    }

    protected static void addCollisionBoxToList(BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable AxisAlignedBB blockBox) {
        AxisAlignedBB axisalignedbb;
        if (blockBox != NULL_AABB && entityBox.intersects(axisalignedbb = blockBox.offset(pos))) {
            collidingBoxes.add(axisalignedbb);
        }
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return blockState.getBoundingBox(worldIn, pos);
    }

    @Deprecated
    public boolean isOpaqueCube(IBlockState state) {
        return true;
    }

    public boolean canCollideCheck(IBlockState state, boolean hitIfLiquid) {
        return this.isCollidable();
    }

    public boolean isCollidable() {
        return true;
    }

    public void randomTick(World worldIn, BlockPos pos, IBlockState state, Random random) {
        this.updateTick(worldIn, pos, state, random);
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public void onPlayerDestroy(World worldIn, BlockPos pos, IBlockState state) {
    }

    @Deprecated
    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public int tickRate(World worldIn) {
        return 10;
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.hasTileEntity(state) && !(this instanceof BlockContainer)) {
            worldIn.removeTileEntity(pos);
        }
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock(this);
    }

    @Deprecated
    public float getPlayerRelativeBlockHardness(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        return ForgeHooks.blockStrength(state, player, worldIn, pos);
    }

    public final void dropBlockAsItem(World worldIn, BlockPos pos, IBlockState state, int fortune) {
        this.dropBlockAsItemWithChance(worldIn, pos, state, 1.0f, fortune);
    }

    public void dropBlockAsItemWithChance(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.isRemote && !worldIn.restoringBlockSnapshots) {
            List<ItemStack> drops = this.getDrops(worldIn, pos, state, fortune);
            chance = ForgeEventFactory.fireBlockHarvesting(drops, worldIn, pos, state, fortune, chance, false, this.harvesters.get());
            for (ItemStack drop : drops) {
                if (!(worldIn.rand.nextFloat() <= chance)) continue;
                Block.spawnAsEntity(worldIn, pos, drop);
            }
        }
    }

    public static void spawnAsEntity(World worldIn, BlockPos pos, ItemStack stack) {
        if (!worldIn.isRemote && !stack.isEmpty() && worldIn.getGameRules().getBoolean("doTileDrops") && !worldIn.restoringBlockSnapshots) {
            if (captureDrops.get().booleanValue()) {
                capturedDrops.get().add(stack);
                return;
            }
            float f = 0.5f;
            double d0 = (double)(worldIn.rand.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.rand.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.rand.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, stack);
            entityitem.setDefaultPickupDelay();
            worldIn.spawnEntity(entityitem);
        }
    }

    public void dropXpOnBlockBreak(World worldIn, BlockPos pos, int amount) {
        if (!worldIn.isRemote && worldIn.getGameRules().getBoolean("doTileDrops")) {
            while (amount > 0) {
                int i = EntityXPOrb.getXPSplit(amount);
                amount -= i;
                worldIn.spawnEntity(new EntityXPOrb(worldIn, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, i));
            }
        }
    }

    public int damageDropped(IBlockState state) {
        return 0;
    }

    @Deprecated
    public float getExplosionResistance(Entity exploder) {
        return this.blockResistance / 5.0f;
    }

    @Deprecated
    @Nullable
    public RayTraceResult collisionRayTrace(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return this.rayTrace(pos, start, end, blockState.getBoundingBox(worldIn, pos));
    }

    @Nullable
    protected RayTraceResult rayTrace(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB boundingBox) {
        Vec3d vec3d1;
        Vec3d vec3d = start.subtract(pos.getX(), pos.getY(), pos.getZ());
        RayTraceResult raytraceresult = boundingBox.calculateIntercept(vec3d, vec3d1 = end.subtract(pos.getX(), pos.getY(), pos.getZ()));
        return raytraceresult == null ? null : new RayTraceResult(raytraceresult.hitVec.add(pos.getX(), pos.getY(), pos.getZ()), raytraceresult.sideHit, pos);
    }

    public void onExplosionDestroy(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.SOLID;
    }

    public boolean canPlaceBlockOnSide(World worldIn, BlockPos pos, EnumFacing side) {
        return this.canPlaceBlockAt(worldIn, pos);
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos).getBlock().isReplaceable(worldIn, pos);
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onEntityWalk(World worldIn, BlockPos pos, Entity entityIn) {
    }

    @Deprecated
    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.getStateFromMeta(meta);
    }

    public void onBlockClicked(World worldIn, BlockPos pos, EntityPlayer playerIn) {
    }

    public Vec3d modifyAcceleration(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        return motion;
    }

    @Deprecated
    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    @Deprecated
    public boolean canProvidePower(IBlockState state) {
        return false;
    }

    public void onEntityCollision(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    @Deprecated
    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    public void harvestBlock(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.addStat(StatList.getBlockStats(this));
        player.addExhaustion(0.005f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.getEnchantmentLevel(Enchantments.SILK_TOUCH, stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.getSilkTouchDrop(state);
            if (!itemstack.isEmpty()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, worldIn, pos, state, 0, 1.0f, true, player);
            for (ItemStack item : items) {
                Block.spawnAsEntity(worldIn, pos, item);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.FORTUNE, stack);
            this.dropBlockAsItem(worldIn, pos, state, i);
            this.harvesters.set(null);
        }
    }

    @Deprecated
    protected boolean canSilkHarvest() {
        return this.getDefaultState().isFullCube() && !this.hasTileEntity(this.silk_check_state.get());
    }

    protected ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.getItemFromBlock(this);
        int i = 0;
        if (item.getHasSubtypes()) {
            i = this.getMetaFromState(state);
        }
        return new ItemStack(item, 1, i);
    }

    public int quantityDroppedWithBonus(int fortune, Random random) {
        return this.quantityDropped(random);
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    }

    public boolean canSpawnInBlock() {
        return !this.material.isSolid() && !this.material.isLiquid();
    }

    public Block setTranslationKey(String key) {
        this.translationKey = key;
        return this;
    }

    public String getLocalizedName() {
        return I18n.translateToLocal(this.getTranslationKey() + ".name");
    }

    public String getTranslationKey() {
        return "tile." + this.translationKey;
    }

    @Deprecated
    public boolean eventReceived(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        return false;
    }

    public boolean getEnableStats() {
        return this.enableStats;
    }

    protected Block disableStats() {
        this.enableStats = false;
        return this;
    }

    @Deprecated
    public EnumPushReaction getPushReaction(IBlockState state) {
        return this.material.getPushReaction();
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public float getAmbientOcclusionLightValue(IBlockState state) {
        return state.isBlockNormalCube() ? 0.2f : 1.0f;
    }

    public void onFallenUpon(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.fall(fallDistance, 1.0f);
    }

    public void onLanded(World worldIn, Entity entityIn) {
        entityIn.motionY = 0.0;
    }

    @Deprecated
    public ItemStack getItem(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.getItemFromBlock(this), 1, this.damageDropped(state));
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add(new ItemStack(this));
    }

    public CreativeTabs getCreativeTab() {
        return this.displayOnCreativeTab;
    }

    public Block setCreativeTab(CreativeTabs tab) {
        this.displayOnCreativeTab = tab;
        return this;
    }

    public void onBlockHarvested(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public void fillWithRain(World worldIn, BlockPos pos) {
    }

    public boolean requiresUpdates() {
        return true;
    }

    public boolean canDropFromExplosion(Explosion explosionIn) {
        return true;
    }

    public boolean isAssociatedBlock(Block other) {
        return this == other;
    }

    public static boolean isEqualTo(Block blockIn, Block other) {
        if (blockIn == null || other == null) {
            return false;
        }
        return blockIn == other ? true : blockIn.isAssociatedBlock(other);
    }

    @Deprecated
    public boolean hasComparatorInputOverride(IBlockState state) {
        return false;
    }

    @Deprecated
    public int getComparatorInputOverride(IBlockState blockState, World worldIn, BlockPos pos) {
        return 0;
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer(this, new IProperty[0]);
    }

    public BlockStateContainer getBlockState() {
        return this.blockState;
    }

    protected final void setDefaultState(IBlockState state) {
        this.defaultBlockState = state;
    }

    public final IBlockState getDefaultState() {
        return this.defaultBlockState;
    }

    public EnumOffsetType getOffsetType() {
        return EnumOffsetType.NONE;
    }

    @Deprecated
    public Vec3d getOffset(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumOffsetType block$enumoffsettype = this.getOffsetType();
        if (block$enumoffsettype == EnumOffsetType.NONE) {
            return Vec3d.ZERO;
        }
        long i = MathHelper.getCoordinateRandom(pos.getX(), 0, pos.getZ());
        return new Vec3d(((double)((float)(i >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5, block$enumoffsettype == EnumOffsetType.XYZ ? ((double)((float)(i >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(i >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5);
    }

    @Deprecated
    public SoundType getSoundType() {
        return this.blockSoundType;
    }

    public String toString() {
        return "Block{" + String.valueOf(REGISTRY.getNameForObject(this)) + "}";
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    public float getSlipperiness(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity entity) {
        return this.slipperiness;
    }

    public void setDefaultSlipperiness(float slipperiness) {
        this.slipperiness = slipperiness;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.getLightValue();
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.isNormalCube();
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return state.isOpaqueCube();
    }

    @Deprecated
    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (base_state.isTopSolid() && side == EnumFacing.UP) {
            return true;
        }
        if (this instanceof BlockSlab) {
            IBlockState state = this.getActualState(base_state, world, pos);
            return base_state.isFullBlock() || state.getValue(BlockSlab.HALF) == BlockSlab.EnumBlockHalf.TOP && side == EnumFacing.UP || state.getValue(BlockSlab.HALF) == BlockSlab.EnumBlockHalf.BOTTOM && side == EnumFacing.DOWN;
        }
        if (this instanceof BlockFarmland) {
            return side != EnumFacing.DOWN && side != EnumFacing.UP;
        }
        if (this instanceof BlockStairs) {
            IBlockState state = this.getActualState(base_state, world, pos);
            boolean flipped = state.getValue(BlockStairs.HALF) == BlockStairs.EnumHalf.TOP;
            BlockStairs.EnumShape shape = state.getValue(BlockStairs.SHAPE);
            EnumFacing facing = state.getValue(BlockStairs.FACING);
            if (side == EnumFacing.UP) {
                return flipped;
            }
            if (side == EnumFacing.DOWN) {
                return !flipped;
            }
            if (facing == side) {
                return true;
            }
            if (flipped) {
                if (shape == BlockStairs.EnumShape.INNER_LEFT) {
                    return side == facing.rotateYCCW();
                }
                if (shape == BlockStairs.EnumShape.INNER_RIGHT) {
                    return side == facing.rotateY();
                }
            } else {
                if (shape == BlockStairs.EnumShape.INNER_LEFT) {
                    return side == facing.rotateY();
                }
                if (shape == BlockStairs.EnumShape.INNER_RIGHT) {
                    return side == facing.rotateYCCW();
                }
            }
            return false;
        }
        if (this instanceof BlockSnow) {
            IBlockState state = this.getActualState(base_state, world, pos);
            return state.getValue(BlockSnow.LAYERS) >= 8;
        }
        if (this instanceof BlockHopper && side == EnumFacing.UP) {
            return true;
        }
        if (this instanceof BlockCompressedPowered) {
            return true;
        }
        return this.isNormalCube(base_state, world, pos);
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isAir(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.getMaterial() == Material.AIR;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return ForgeHooks.canHarvestBlock(this, player, world, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.onBlockHarvested(world, pos, state, player);
        return world.setBlockState(pos, Blocks.AIR.getDefaultState(), world.isRemote ? 11 : 3);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return Blocks.FIRE.getFlammability(this);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.getFlammability(world, pos, face) > 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return Blocks.FIRE.getEncouragement(this);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP) {
            return false;
        }
        if (this == Blocks.NETHERRACK || this == Blocks.MAGMA) {
            return true;
        }
        return world.provider instanceof WorldProviderEnd && this == Blocks.BEDROCK;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.isTileProvider;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.isTileProvider) {
            return ((ITileEntityProvider)((Object)this)).createNewTileEntity(world, this.getMetaFromState(state));
        }
        return null;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.quantityDroppedWithBonus(fortune, random);
    }

    @Deprecated
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList<ItemStack> ret = NonNullList.create();
        this.getDrops(ret, world, pos, state, fortune);
        return ret;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).rand : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.getItemDropped(state, rand, fortune);
            if (item == Items.AIR) continue;
            drops.add(new ItemStack(item, 1, this.damageDropped(state)));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.silk_check_state.set(state);
        boolean ret = this.canSilkHarvest();
        this.silk_check_state.set(null);
        return ret;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return this.isSideSolid(state, world, pos, EnumFacing.UP);
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        return this == Blocks.BED;
    }

    @Nullable
    public BlockPos getBedSpawnPosition(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityPlayer player) {
        if (world instanceof World) {
            return BlockBed.getSafeExitLocation((World)world, pos, 0);
        }
        return null;
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
        if (world instanceof World) {
            IBlockState state = world.getBlockState(pos);
            state = state.getBlock().getActualState(state, world, pos);
            state = state.withProperty(BlockBed.OCCUPIED, occupied);
            ((World)world).setBlockState(pos, state, 4);
        }
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getActualState(state, world, pos).getValue(BlockHorizontal.FACING);
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return this.getActualState(world.getBlockState(pos), world, pos).getValue(BlockBed.PART) == BlockBed.EnumPartType.FOOT;
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.getMaterial() == Material.LEAVES;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isAir(state, world, pos) || this.isLeaves(state, world, pos);
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return target.apply((Object)state);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.getExplosionResistance(exploder);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        world.setBlockToAir(pos);
        this.onExplosionDestroy(world, pos, explosion);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return state.canProvidePower() && side != null;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this == Blocks.END_GATEWAY || this == Blocks.LIT_PUMPKIN) {
            return false;
        }
        if (state.isTopSolid() || this instanceof BlockFence || this == Blocks.GLASS || this == Blocks.COBBLESTONE_WALL || this == Blocks.STAINED_GLASS) {
            return true;
        }
        BlockFaceShape shape = state.getBlockFaceShape(world, pos, EnumFacing.UP);
        return (shape == BlockFaceShape.SOLID || shape == BlockFaceShape.CENTER || shape == BlockFaceShape.CENTER_BIG) && !Block.isExceptionBlockForAttaching(this);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getItem(world, pos, state);
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        return false;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.offset(direction));
        EnumPlantType plantType = plantable.getPlantType(world, pos.offset(direction));
        if (plant.getBlock() == Blocks.CACTUS) {
            return this == Blocks.CACTUS || this == Blocks.SAND;
        }
        if (plant.getBlock() == Blocks.REEDS && this == Blocks.REEDS) {
            return true;
        }
        if (plantable instanceof BlockBush && ((BlockBush)plantable).canSustainBush(state)) {
            return true;
        }
        switch (plantType) {
            case Desert: {
                return this == Blocks.SAND || this == Blocks.HARDENED_CLAY || this == Blocks.STAINED_HARDENED_CLAY;
            }
            case Nether: {
                return this == Blocks.SOUL_SAND;
            }
            case Crop: {
                return this == Blocks.FARMLAND;
            }
            case Cave: {
                return state.isSideSolid(world, pos, EnumFacing.UP);
            }
            case Plains: {
                return this == Blocks.GRASS || this == Blocks.DIRT || this == Blocks.FARMLAND;
            }
            case Water: {
                return state.getMaterial() == Material.WATER && state.getValue(BlockLiquid.LEVEL) == 0;
            }
            case Beach: {
                boolean isBeach = this == Blocks.GRASS || this == Blocks.DIRT || this == Blocks.SAND;
                boolean hasWater = world.getBlockState(pos.east()).getMaterial() == Material.WATER || world.getBlockState(pos.west()).getMaterial() == Material.WATER || world.getBlockState(pos.north()).getMaterial() == Material.WATER || world.getBlockState(pos.south()).getMaterial() == Material.WATER;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public void onPlantGrow(IBlockState state, World world, BlockPos pos, BlockPos source) {
        if (this == Blocks.GRASS || this == Blocks.FARMLAND) {
            world.setBlockState(pos, Blocks.DIRT.getDefaultState(), 2);
        }
    }

    public boolean isFertile(World world, BlockPos pos) {
        if (this == Blocks.FARMLAND) {
            return world.getBlockState(pos).getValue(BlockFarmland.MOISTURE) > 0;
        }
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.getLightOpacity();
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityDragon) {
            return this != Blocks.BARRIER && this != Blocks.OBSIDIAN && this != Blocks.END_STONE && this != Blocks.BEDROCK && this != Blocks.END_PORTAL && this != Blocks.END_PORTAL_FRAME && this != Blocks.COMMAND_BLOCK && this != Blocks.REPEATING_COMMAND_BLOCK && this != Blocks.CHAIN_COMMAND_BLOCK && this != Blocks.IRON_BARS && this != Blocks.END_GATEWAY;
        }
        if (entity instanceof EntityWither || entity instanceof EntityWitherSkull) {
            return EntityWither.canDestroyBlock(this);
        }
        return true;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return this == Blocks.EMERALD_BLOCK || this == Blocks.GOLD_BLOCK || this == Blocks.DIAMOND_BLOCK || this == Blocks.IRON_BLOCK;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.getBlockState(pos);
        for (IProperty prop : state.getProperties().keySet()) {
            EnumFacing rotatedFacing;
            Block block;
            if (!prop.getName().equals("facing") && !prop.getName().equals("rotation") || prop.getValueClass() != EnumFacing.class || (block = state.getBlock()) instanceof BlockBed || block instanceof BlockPistonExtension) continue;
            IProperty facingProperty = prop;
            EnumFacing facing = (EnumFacing)state.getValue(facingProperty);
            Collection validFacings = facingProperty.getAllowedValues();
            IBlockState newState = validFacings.size() == 4 && !validFacings.contains(EnumFacing.UP) && !validFacings.contains(EnumFacing.DOWN) ? state.withProperty(facingProperty, facing.rotateY()) : (validFacings.contains(rotatedFacing = facing.rotateAround(axis.getAxis())) ? state.withProperty(facingProperty, rotatedFacing) : state.cycleProperty(facingProperty));
            world.setBlockState(pos, newState);
            return true;
        }
        return false;
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        for (IProperty prop : state.getProperties().keySet()) {
            if (!prop.getName().equals("facing") && !prop.getName().equals("rotation") || prop.getValueClass() != EnumFacing.class) continue;
            Collection<EnumFacing> values = prop.getAllowedValues();
            return values.toArray(new EnumFacing[values.size()]);
        }
        return null;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this == Blocks.BOOKSHELF ? 1.0f : 0.0f;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        IBlockState state = world.getBlockState(pos);
        for (IProperty prop : state.getProperties().keySet()) {
            EnumDyeColor current;
            if (!prop.getName().equals("color") || prop.getValueClass() != EnumDyeColor.class || (current = (EnumDyeColor)state.getValue(prop)) == color || !prop.getAllowedValues().contains(color)) continue;
            world.setBlockState(pos, state.withProperty(prop, color));
            return true;
        }
        return false;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return 0;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return state.isNormalCube();
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public void setHarvestLevel(String toolClass, int level) {
        UnmodifiableIterator itr = this.getBlockState().getValidStates().iterator();
        while (itr.hasNext()) {
            this.setHarvestLevel(toolClass, level, (IBlockState)itr.next());
        }
    }

    public void setHarvestLevel(String toolClass, int level, IBlockState state) {
        int idx = this.getMetaFromState(state);
        this.harvestTool[idx] = toolClass;
        this.harvestLevel[idx] = level;
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return this.harvestTool[this.getMetaFromState(state)];
    }

    public int getHarvestLevel(IBlockState state) {
        return this.harvestLevel[this.getMetaFromState(state)];
    }

    public boolean isToolEffective(String type, IBlockState state) {
        if ("pickaxe".equals(type) && (this == Blocks.REDSTONE_ORE || this == Blocks.LIT_REDSTONE_ORE || this == Blocks.OBSIDIAN)) {
            return false;
        }
        return type != null && type.equals(this.getHarvestTool(state));
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        return null;
    }

    @Nullable
    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB boundingBox, Material materialIn) {
        return null;
    }

    @Nullable
    public Boolean isAABBInsideLiquid(World world, BlockPos pos, AxisAlignedBB boundingBox) {
        return null;
    }

    public float getBlockLiquidHeight(World world, BlockPos pos, IBlockState state, Material material) {
        return 0.0f;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return this.getRenderLayer() == layer;
    }

    protected NonNullList<ItemStack> captureDrops(boolean start) {
        if (start) {
            captureDrops.set(true);
            capturedDrops.get().clear();
            return NonNullList.create();
        }
        captureDrops.set(false);
        return capturedDrops.get();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.getSoundType();
    }

    @Nullable
    public float[] getBeaconColorMultiplier(IBlockState state, World world, BlockPos pos, BlockPos beaconPos) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        if (state.getMaterial() == Material.WATER) {
            float f12 = 0.0f;
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase ent = (EntityLivingBase)entity;
                f12 = (float)EnchantmentHelper.getRespirationModifier(ent) * 0.2f;
                if (ent.isPotionActive(MobEffects.WATER_BREATHING)) {
                    f12 = f12 * 0.3f + 0.6f;
                }
            }
            return new Vec3d(0.02f + f12, 0.02f + f12, 0.2f + f12);
        }
        if (state.getMaterial() == Material.LAVA) {
            return new Vec3d(0.6f, 0.1f, 0.0);
        }
        return originalColor;
    }

    public IBlockState getStateAtViewpoint(IBlockState state, IBlockAccess world, BlockPos pos, Vec3d viewpoint) {
        return state;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return false;
    }

    @Nullable
    @Deprecated
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isBurning(world, pos) ? PathNodeType.DAMAGE_FIRE : null;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityLiving entity) {
        return this.getAiPathNodeType(state, world, pos);
    }

    public boolean doesSideBlockChestOpening(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null && "minecraft".equals(registryName.getNamespace())) {
            return this.isNormalCube(blockState, world, pos);
        }
        return this.isSideSolid(blockState, world, pos, side);
    }

    public boolean isStickyBlock(IBlockState state) {
        return state.getBlock() == Blocks.SLIME_BLOCK;
    }

    public static void registerBlocks() {
        Block.registerBlock(0, AIR_ID, new BlockAir().setTranslationKey("air"));
        Block.registerBlock(1, "stone", new BlockStone().setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("stone"));
        Block.registerBlock(2, "grass", new BlockGrass().setHardness(0.6f).setSoundType(SoundType.PLANT).setTranslationKey("grass"));
        Block.registerBlock(3, "dirt", new BlockDirt().setHardness(0.5f).setSoundType(SoundType.GROUND).setTranslationKey("dirt"));
        Block block = new Block(Material.ROCK).setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("stonebrick").setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
        Block.registerBlock(4, "cobblestone", block);
        Block block1 = new BlockPlanks().setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("wood");
        Block.registerBlock(5, "planks", block1);
        Block.registerBlock(6, "sapling", new BlockSapling().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("sapling"));
        Block.registerBlock(7, "bedrock", new BlockEmptyDrops(Material.ROCK).setBlockUnbreakable().setResistance(6000000.0f).setSoundType(SoundType.STONE).setTranslationKey("bedrock").disableStats().setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(8, "flowing_water", new BlockDynamicLiquid(Material.WATER).setHardness(100.0f).setLightOpacity(3).setTranslationKey("water").disableStats());
        Block.registerBlock(9, "water", new BlockStaticLiquid(Material.WATER).setHardness(100.0f).setLightOpacity(3).setTranslationKey("water").disableStats());
        Block.registerBlock(10, "flowing_lava", new BlockDynamicLiquid(Material.LAVA).setHardness(100.0f).setLightLevel(1.0f).setTranslationKey("lava").disableStats());
        Block.registerBlock(11, "lava", new BlockStaticLiquid(Material.LAVA).setHardness(100.0f).setLightLevel(1.0f).setTranslationKey("lava").disableStats());
        Block.registerBlock(12, "sand", new BlockSand().setHardness(0.5f).setSoundType(SoundType.SAND).setTranslationKey("sand"));
        Block.registerBlock(13, "gravel", new BlockGravel().setHardness(0.6f).setSoundType(SoundType.GROUND).setTranslationKey("gravel"));
        Block.registerBlock(14, "gold_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("oreGold"));
        Block.registerBlock(15, "iron_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("oreIron"));
        Block.registerBlock(16, "coal_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("oreCoal"));
        Block.registerBlock(17, "log", new BlockOldLog().setTranslationKey("log"));
        Block.registerBlock(18, "leaves", new BlockOldLeaf().setTranslationKey("leaves"));
        Block.registerBlock(19, "sponge", new BlockSponge().setHardness(0.6f).setSoundType(SoundType.PLANT).setTranslationKey("sponge"));
        Block.registerBlock(20, "glass", new BlockGlass(Material.GLASS, false).setHardness(0.3f).setSoundType(SoundType.GLASS).setTranslationKey("glass"));
        Block.registerBlock(21, "lapis_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("oreLapis"));
        Block.registerBlock(22, "lapis_block", new Block(Material.IRON, MapColor.LAPIS).setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("blockLapis").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(23, "dispenser", new BlockDispenser().setHardness(3.5f).setSoundType(SoundType.STONE).setTranslationKey("dispenser"));
        Block block2 = new BlockSandStone().setSoundType(SoundType.STONE).setHardness(0.8f).setTranslationKey("sandStone");
        Block.registerBlock(24, "sandstone", block2);
        Block.registerBlock(25, "noteblock", new BlockNote().setSoundType(SoundType.WOOD).setHardness(0.8f).setTranslationKey("musicBlock"));
        Block.registerBlock(26, "bed", new BlockBed().setSoundType(SoundType.WOOD).setHardness(0.2f).setTranslationKey("bed").disableStats());
        Block.registerBlock(27, "golden_rail", new BlockRailPowered().setHardness(0.7f).setSoundType(SoundType.METAL).setTranslationKey("goldenRail"));
        Block.registerBlock(28, "detector_rail", new BlockRailDetector().setHardness(0.7f).setSoundType(SoundType.METAL).setTranslationKey("detectorRail"));
        Block.registerBlock(29, "sticky_piston", new BlockPistonBase(true).setTranslationKey("pistonStickyBase"));
        Block.registerBlock(30, "web", new BlockWeb().setLightOpacity(1).setHardness(4.0f).setTranslationKey("web"));
        Block.registerBlock(31, "tallgrass", new BlockTallGrass().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("tallgrass"));
        Block.registerBlock(32, "deadbush", new BlockDeadBush().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("deadbush"));
        Block.registerBlock(33, "piston", new BlockPistonBase(false).setTranslationKey("pistonBase"));
        Block.registerBlock(34, "piston_head", new BlockPistonExtension().setTranslationKey("pistonBase"));
        Block.registerBlock(35, "wool", new BlockColored(Material.CLOTH).setHardness(0.8f).setSoundType(SoundType.CLOTH).setTranslationKey("cloth"));
        Block.registerBlock(36, "piston_extension", (Block)new BlockPistonMoving());
        Block.registerBlock(37, "yellow_flower", new BlockYellowFlower().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("flower1"));
        Block.registerBlock(38, "red_flower", new BlockRedFlower().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("flower2"));
        Block block3 = new BlockMushroom().setHardness(0.0f).setSoundType(SoundType.PLANT).setLightLevel(0.125f).setTranslationKey("mushroom");
        Block.registerBlock(39, "brown_mushroom", block3);
        Block block4 = new BlockMushroom().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("mushroom");
        Block.registerBlock(40, "red_mushroom", block4);
        Block.registerBlock(41, "gold_block", new Block(Material.IRON, MapColor.GOLD).setHardness(3.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setTranslationKey("blockGold").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(42, "iron_block", new Block(Material.IRON, MapColor.IRON).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setTranslationKey("blockIron").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(43, "double_stone_slab", new BlockDoubleStoneSlab().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("stoneSlab"));
        Block.registerBlock(44, "stone_slab", new BlockHalfStoneSlab().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("stoneSlab"));
        Block block5 = new Block(Material.ROCK, MapColor.RED).setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("brick").setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
        Block.registerBlock(45, "brick_block", block5);
        Block.registerBlock(46, "tnt", new BlockTNT().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("tnt"));
        Block.registerBlock(47, "bookshelf", new BlockBookshelf().setHardness(1.5f).setSoundType(SoundType.WOOD).setTranslationKey("bookshelf"));
        Block.registerBlock(48, "mossy_cobblestone", new Block(Material.ROCK).setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("stoneMoss").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(49, "obsidian", new BlockObsidian().setHardness(50.0f).setResistance(2000.0f).setSoundType(SoundType.STONE).setTranslationKey("obsidian"));
        Block.registerBlock(50, "torch", new BlockTorch().setHardness(0.0f).setLightLevel(0.9375f).setSoundType(SoundType.WOOD).setTranslationKey("torch"));
        Block.registerBlock(51, "fire", new BlockFire().setHardness(0.0f).setLightLevel(1.0f).setSoundType(SoundType.CLOTH).setTranslationKey("fire").disableStats());
        Block.registerBlock(52, "mob_spawner", new BlockMobSpawner().setHardness(5.0f).setSoundType(SoundType.METAL).setTranslationKey("mobSpawner").disableStats());
        Block.registerBlock(53, "oak_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.OAK)).setTranslationKey("stairsWood"));
        Block.registerBlock(54, "chest", new BlockChest(BlockChest.Type.BASIC).setHardness(2.5f).setSoundType(SoundType.WOOD).setTranslationKey("chest"));
        Block.registerBlock(55, "redstone_wire", new BlockRedstoneWire().setHardness(0.0f).setSoundType(SoundType.STONE).setTranslationKey("redstoneDust").disableStats());
        Block.registerBlock(56, "diamond_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("oreDiamond"));
        Block.registerBlock(57, "diamond_block", new Block(Material.IRON, MapColor.DIAMOND).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setTranslationKey("blockDiamond").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(58, "crafting_table", new BlockWorkbench().setHardness(2.5f).setSoundType(SoundType.WOOD).setTranslationKey("workbench"));
        Block.registerBlock(59, "wheat", new BlockCrops().setTranslationKey("crops"));
        Block block6 = new BlockFarmland().setHardness(0.6f).setSoundType(SoundType.GROUND).setTranslationKey("farmland");
        Block.registerBlock(60, "farmland", block6);
        Block.registerBlock(61, "furnace", new BlockFurnace(false).setHardness(3.5f).setSoundType(SoundType.STONE).setTranslationKey("furnace").setCreativeTab(CreativeTabs.DECORATIONS));
        Block.registerBlock(62, "lit_furnace", new BlockFurnace(true).setHardness(3.5f).setSoundType(SoundType.STONE).setLightLevel(0.875f).setTranslationKey("furnace"));
        Block.registerBlock(63, "standing_sign", new BlockStandingSign().setHardness(1.0f).setSoundType(SoundType.WOOD).setTranslationKey("sign").disableStats());
        Block.registerBlock(64, "wooden_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setTranslationKey("doorOak").disableStats());
        Block.registerBlock(65, "ladder", new BlockLadder().setHardness(0.4f).setSoundType(SoundType.LADDER).setTranslationKey("ladder"));
        Block.registerBlock(66, "rail", new BlockRail().setHardness(0.7f).setSoundType(SoundType.METAL).setTranslationKey("rail"));
        Block.registerBlock(67, "stone_stairs", new BlockStairs(block.getDefaultState()).setTranslationKey("stairsStone"));
        Block.registerBlock(68, "wall_sign", new BlockWallSign().setHardness(1.0f).setSoundType(SoundType.WOOD).setTranslationKey("sign").disableStats());
        Block.registerBlock(69, "lever", new BlockLever().setHardness(0.5f).setSoundType(SoundType.WOOD).setTranslationKey("lever"));
        Block.registerBlock(70, "stone_pressure_plate", new BlockPressurePlate(Material.ROCK, BlockPressurePlate.Sensitivity.MOBS).setHardness(0.5f).setSoundType(SoundType.STONE).setTranslationKey("pressurePlateStone"));
        Block.registerBlock(71, "iron_door", new BlockDoor(Material.IRON).setHardness(5.0f).setSoundType(SoundType.METAL).setTranslationKey("doorIron").disableStats());
        Block.registerBlock(72, "wooden_pressure_plate", new BlockPressurePlate(Material.WOOD, BlockPressurePlate.Sensitivity.EVERYTHING).setHardness(0.5f).setSoundType(SoundType.WOOD).setTranslationKey("pressurePlateWood"));
        Block.registerBlock(73, "redstone_ore", new BlockRedstoneOre(false).setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("oreRedstone").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(74, "lit_redstone_ore", new BlockRedstoneOre(true).setLightLevel(0.625f).setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("oreRedstone"));
        Block.registerBlock(75, "unlit_redstone_torch", new BlockRedstoneTorch(false).setHardness(0.0f).setSoundType(SoundType.WOOD).setTranslationKey("notGate"));
        Block.registerBlock(76, "redstone_torch", new BlockRedstoneTorch(true).setHardness(0.0f).setLightLevel(0.5f).setSoundType(SoundType.WOOD).setTranslationKey("notGate").setCreativeTab(CreativeTabs.REDSTONE));
        Block.registerBlock(77, "stone_button", new BlockButtonStone().setHardness(0.5f).setSoundType(SoundType.STONE).setTranslationKey("button"));
        Block.registerBlock(78, "snow_layer", new BlockSnow().setHardness(0.1f).setSoundType(SoundType.SNOW).setTranslationKey("snow").setLightOpacity(0));
        Block.registerBlock(79, "ice", new BlockIce().setHardness(0.5f).setLightOpacity(3).setSoundType(SoundType.GLASS).setTranslationKey("ice"));
        Block.registerBlock(80, "snow", new BlockSnowBlock().setHardness(0.2f).setSoundType(SoundType.SNOW).setTranslationKey("snow"));
        Block.registerBlock(81, "cactus", new BlockCactus().setHardness(0.4f).setSoundType(SoundType.CLOTH).setTranslationKey("cactus"));
        Block.registerBlock(82, "clay", new BlockClay().setHardness(0.6f).setSoundType(SoundType.GROUND).setTranslationKey("clay"));
        Block.registerBlock(83, "reeds", new BlockReed().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("reeds").disableStats());
        Block.registerBlock(84, "jukebox", new BlockJukebox().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("jukebox"));
        Block.registerBlock(85, "fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.OAK.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("fence"));
        Block block7 = new BlockPumpkin().setHardness(1.0f).setSoundType(SoundType.WOOD).setTranslationKey("pumpkin");
        Block.registerBlock(86, "pumpkin", block7);
        Block.registerBlock(87, "netherrack", new BlockNetherrack().setHardness(0.4f).setSoundType(SoundType.STONE).setTranslationKey("hellrock"));
        Block.registerBlock(88, "soul_sand", new BlockSoulSand().setHardness(0.5f).setSoundType(SoundType.SAND).setTranslationKey("hellsand"));
        Block.registerBlock(89, "glowstone", new BlockGlowstone(Material.GLASS).setHardness(0.3f).setSoundType(SoundType.GLASS).setLightLevel(1.0f).setTranslationKey("lightgem"));
        Block.registerBlock(90, "portal", new BlockPortal().setHardness(-1.0f).setSoundType(SoundType.GLASS).setLightLevel(0.75f).setTranslationKey("portal"));
        Block.registerBlock(91, "lit_pumpkin", new BlockPumpkin().setHardness(1.0f).setSoundType(SoundType.WOOD).setLightLevel(1.0f).setTranslationKey("litpumpkin"));
        Block.registerBlock(92, "cake", new BlockCake().setHardness(0.5f).setSoundType(SoundType.CLOTH).setTranslationKey("cake").disableStats());
        Block.registerBlock(93, "unpowered_repeater", new BlockRedstoneRepeater(false).setHardness(0.0f).setSoundType(SoundType.WOOD).setTranslationKey("diode").disableStats());
        Block.registerBlock(94, "powered_repeater", new BlockRedstoneRepeater(true).setHardness(0.0f).setSoundType(SoundType.WOOD).setTranslationKey("diode").disableStats());
        Block.registerBlock(95, "stained_glass", new BlockStainedGlass(Material.GLASS).setHardness(0.3f).setSoundType(SoundType.GLASS).setTranslationKey("stainedGlass"));
        Block.registerBlock(96, "trapdoor", new BlockTrapDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setTranslationKey("trapdoor").disableStats());
        Block.registerBlock(97, "monster_egg", new BlockSilverfish().setHardness(0.75f).setTranslationKey("monsterStoneEgg"));
        Block block8 = new BlockStoneBrick().setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("stonebricksmooth");
        Block.registerBlock(98, "stonebrick", block8);
        Block.registerBlock(99, "brown_mushroom_block", new BlockHugeMushroom(Material.WOOD, MapColor.DIRT, block3).setHardness(0.2f).setSoundType(SoundType.WOOD).setTranslationKey("mushroom"));
        Block.registerBlock(100, "red_mushroom_block", new BlockHugeMushroom(Material.WOOD, MapColor.RED, block4).setHardness(0.2f).setSoundType(SoundType.WOOD).setTranslationKey("mushroom"));
        Block.registerBlock(101, "iron_bars", new BlockPane(Material.IRON, true).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setTranslationKey("fenceIron"));
        Block.registerBlock(102, "glass_pane", new BlockPane(Material.GLASS, false).setHardness(0.3f).setSoundType(SoundType.GLASS).setTranslationKey("thinGlass"));
        Block block9 = new BlockMelon().setHardness(1.0f).setSoundType(SoundType.WOOD).setTranslationKey("melon");
        Block.registerBlock(103, "melon_block", block9);
        Block.registerBlock(104, "pumpkin_stem", new BlockStem(block7).setHardness(0.0f).setSoundType(SoundType.WOOD).setTranslationKey("pumpkinStem"));
        Block.registerBlock(105, "melon_stem", new BlockStem(block9).setHardness(0.0f).setSoundType(SoundType.WOOD).setTranslationKey("pumpkinStem"));
        Block.registerBlock(106, "vine", new BlockVine().setHardness(0.2f).setSoundType(SoundType.PLANT).setTranslationKey("vine"));
        Block.registerBlock(107, "fence_gate", new BlockFenceGate(BlockPlanks.EnumType.OAK).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("fenceGate"));
        Block.registerBlock(108, "brick_stairs", new BlockStairs(block5.getDefaultState()).setTranslationKey("stairsBrick"));
        Block.registerBlock(109, "stone_brick_stairs", new BlockStairs(block8.getDefaultState().withProperty(BlockStoneBrick.VARIANT, BlockStoneBrick.EnumType.DEFAULT)).setTranslationKey("stairsStoneBrickSmooth"));
        Block.registerBlock(110, "mycelium", new BlockMycelium().setHardness(0.6f).setSoundType(SoundType.PLANT).setTranslationKey("mycel"));
        Block.registerBlock(111, "waterlily", new BlockLilyPad().setHardness(0.0f).setSoundType(SoundType.PLANT).setTranslationKey("waterlily"));
        Block block10 = new BlockNetherBrick().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("netherBrick").setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
        Block.registerBlock(112, "nether_brick", block10);
        Block.registerBlock(113, "nether_brick_fence", new BlockFence(Material.ROCK, MapColor.NETHERRACK).setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("netherFence"));
        Block.registerBlock(114, "nether_brick_stairs", new BlockStairs(block10.getDefaultState()).setTranslationKey("stairsNetherBrick"));
        Block.registerBlock(115, "nether_wart", new BlockNetherWart().setTranslationKey("netherStalk"));
        Block.registerBlock(116, "enchanting_table", new BlockEnchantmentTable().setHardness(5.0f).setResistance(2000.0f).setTranslationKey("enchantmentTable"));
        Block.registerBlock(117, "brewing_stand", new BlockBrewingStand().setHardness(0.5f).setLightLevel(0.125f).setTranslationKey("brewingStand"));
        Block.registerBlock(118, "cauldron", new BlockCauldron().setHardness(2.0f).setTranslationKey("cauldron"));
        Block.registerBlock(119, "end_portal", new BlockEndPortal(Material.PORTAL).setHardness(-1.0f).setResistance(6000000.0f));
        Block.registerBlock(120, "end_portal_frame", new BlockEndPortalFrame().setSoundType(SoundType.GLASS).setLightLevel(0.125f).setHardness(-1.0f).setTranslationKey("endPortalFrame").setResistance(6000000.0f).setCreativeTab(CreativeTabs.DECORATIONS));
        Block.registerBlock(121, "end_stone", new Block(Material.ROCK, MapColor.SAND).setHardness(3.0f).setResistance(15.0f).setSoundType(SoundType.STONE).setTranslationKey("whiteStone").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(122, "dragon_egg", new BlockDragonEgg().setHardness(3.0f).setResistance(15.0f).setSoundType(SoundType.STONE).setLightLevel(0.125f).setTranslationKey("dragonEgg"));
        Block.registerBlock(123, "redstone_lamp", new BlockRedstoneLight(false).setHardness(0.3f).setSoundType(SoundType.GLASS).setTranslationKey("redstoneLight").setCreativeTab(CreativeTabs.REDSTONE));
        Block.registerBlock(124, "lit_redstone_lamp", new BlockRedstoneLight(true).setHardness(0.3f).setSoundType(SoundType.GLASS).setTranslationKey("redstoneLight"));
        Block.registerBlock(125, "double_wooden_slab", new BlockDoubleWoodSlab().setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("woodSlab"));
        Block.registerBlock(126, "wooden_slab", new BlockHalfWoodSlab().setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("woodSlab"));
        Block.registerBlock(127, "cocoa", new BlockCocoa().setHardness(0.2f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("cocoa"));
        Block.registerBlock(128, "sandstone_stairs", new BlockStairs(block2.getDefaultState().withProperty(BlockSandStone.TYPE, BlockSandStone.EnumType.SMOOTH)).setTranslationKey("stairsSandStone"));
        Block.registerBlock(129, "emerald_ore", new BlockOre().setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("oreEmerald"));
        Block.registerBlock(130, "ender_chest", new BlockEnderChest().setHardness(22.5f).setResistance(1000.0f).setSoundType(SoundType.STONE).setTranslationKey("enderChest").setLightLevel(0.5f));
        Block.registerBlock(131, "tripwire_hook", new BlockTripWireHook().setTranslationKey("tripWireSource"));
        Block.registerBlock(132, "tripwire", new BlockTripWire().setTranslationKey("tripWire"));
        Block.registerBlock(133, "emerald_block", new Block(Material.IRON, MapColor.EMERALD).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setTranslationKey("blockEmerald").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(134, "spruce_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.SPRUCE)).setTranslationKey("stairsWoodSpruce"));
        Block.registerBlock(135, "birch_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.BIRCH)).setTranslationKey("stairsWoodBirch"));
        Block.registerBlock(136, "jungle_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.JUNGLE)).setTranslationKey("stairsWoodJungle"));
        Block.registerBlock(137, "command_block", new BlockCommandBlock(MapColor.BROWN).setBlockUnbreakable().setResistance(6000000.0f).setTranslationKey("commandBlock"));
        Block.registerBlock(138, "beacon", new BlockBeacon().setTranslationKey("beacon").setLightLevel(1.0f));
        Block.registerBlock(139, "cobblestone_wall", new BlockWall(block).setTranslationKey("cobbleWall"));
        Block.registerBlock(140, "flower_pot", new BlockFlowerPot().setHardness(0.0f).setSoundType(SoundType.STONE).setTranslationKey("flowerPot"));
        Block.registerBlock(141, "carrots", new BlockCarrot().setTranslationKey("carrots"));
        Block.registerBlock(142, "potatoes", new BlockPotato().setTranslationKey("potatoes"));
        Block.registerBlock(143, "wooden_button", new BlockButtonWood().setHardness(0.5f).setSoundType(SoundType.WOOD).setTranslationKey("button"));
        Block.registerBlock(144, "skull", new BlockSkull().setHardness(1.0f).setSoundType(SoundType.STONE).setTranslationKey("skull"));
        Block.registerBlock(145, "anvil", new BlockAnvil().setHardness(5.0f).setSoundType(SoundType.ANVIL).setResistance(2000.0f).setTranslationKey("anvil"));
        Block.registerBlock(146, "trapped_chest", new BlockChest(BlockChest.Type.TRAP).setHardness(2.5f).setSoundType(SoundType.WOOD).setTranslationKey("chestTrap"));
        Block.registerBlock(147, "light_weighted_pressure_plate", new BlockPressurePlateWeighted(Material.IRON, 15, MapColor.GOLD).setHardness(0.5f).setSoundType(SoundType.WOOD).setTranslationKey("weightedPlate_light"));
        Block.registerBlock(148, "heavy_weighted_pressure_plate", new BlockPressurePlateWeighted(Material.IRON, 150).setHardness(0.5f).setSoundType(SoundType.WOOD).setTranslationKey("weightedPlate_heavy"));
        Block.registerBlock(149, "unpowered_comparator", new BlockRedstoneComparator(false).setHardness(0.0f).setSoundType(SoundType.WOOD).setTranslationKey("comparator").disableStats());
        Block.registerBlock(150, "powered_comparator", new BlockRedstoneComparator(true).setHardness(0.0f).setLightLevel(0.625f).setSoundType(SoundType.WOOD).setTranslationKey("comparator").disableStats());
        Block.registerBlock(151, "daylight_detector", (Block)new BlockDaylightDetector(false));
        Block.registerBlock(152, "redstone_block", new BlockCompressedPowered(Material.IRON, MapColor.TNT).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.METAL).setTranslationKey("blockRedstone").setCreativeTab(CreativeTabs.REDSTONE));
        Block.registerBlock(153, "quartz_ore", new BlockOre(MapColor.NETHERRACK).setHardness(3.0f).setResistance(5.0f).setSoundType(SoundType.STONE).setTranslationKey("netherquartz"));
        Block.registerBlock(154, "hopper", new BlockHopper().setHardness(3.0f).setResistance(8.0f).setSoundType(SoundType.METAL).setTranslationKey("hopper"));
        Block block11 = new BlockQuartz().setSoundType(SoundType.STONE).setHardness(0.8f).setTranslationKey("quartzBlock");
        Block.registerBlock(155, "quartz_block", block11);
        Block.registerBlock(156, "quartz_stairs", new BlockStairs(block11.getDefaultState().withProperty(BlockQuartz.VARIANT, BlockQuartz.EnumType.DEFAULT)).setTranslationKey("stairsQuartz"));
        Block.registerBlock(157, "activator_rail", new BlockRailPowered(true).setHardness(0.7f).setSoundType(SoundType.METAL).setTranslationKey("activatorRail"));
        Block.registerBlock(158, "dropper", new BlockDropper().setHardness(3.5f).setSoundType(SoundType.STONE).setTranslationKey("dropper"));
        Block.registerBlock(159, "stained_hardened_clay", new BlockStainedHardenedClay().setHardness(1.25f).setResistance(7.0f).setSoundType(SoundType.STONE).setTranslationKey("clayHardenedStained"));
        Block.registerBlock(160, "stained_glass_pane", new BlockStainedGlassPane().setHardness(0.3f).setSoundType(SoundType.GLASS).setTranslationKey("thinStainedGlass"));
        Block.registerBlock(161, "leaves2", new BlockNewLeaf().setTranslationKey("leaves"));
        Block.registerBlock(162, "log2", new BlockNewLog().setTranslationKey("log"));
        Block.registerBlock(163, "acacia_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.ACACIA)).setTranslationKey("stairsWoodAcacia"));
        Block.registerBlock(164, "dark_oak_stairs", new BlockStairs(block1.getDefaultState().withProperty(BlockPlanks.VARIANT, BlockPlanks.EnumType.DARK_OAK)).setTranslationKey("stairsWoodDarkOak"));
        Block.registerBlock(165, "slime", new BlockSlime().setTranslationKey("slime").setSoundType(SoundType.SLIME));
        Block.registerBlock(166, "barrier", new BlockBarrier().setTranslationKey("barrier"));
        Block.registerBlock(167, "iron_trapdoor", new BlockTrapDoor(Material.IRON).setHardness(5.0f).setSoundType(SoundType.METAL).setTranslationKey("ironTrapdoor").disableStats());
        Block.registerBlock(168, "prismarine", new BlockPrismarine().setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("prismarine"));
        Block.registerBlock(169, "sea_lantern", new BlockSeaLantern(Material.GLASS).setHardness(0.3f).setSoundType(SoundType.GLASS).setLightLevel(1.0f).setTranslationKey("seaLantern"));
        Block.registerBlock(170, "hay_block", new BlockHay().setHardness(0.5f).setSoundType(SoundType.PLANT).setTranslationKey("hayBlock").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(171, "carpet", new BlockCarpet().setHardness(0.1f).setSoundType(SoundType.CLOTH).setTranslationKey("woolCarpet").setLightOpacity(0));
        Block.registerBlock(172, "hardened_clay", new BlockHardenedClay().setHardness(1.25f).setResistance(7.0f).setSoundType(SoundType.STONE).setTranslationKey("clayHardened"));
        Block.registerBlock(173, "coal_block", new Block(Material.ROCK, MapColor.BLACK).setHardness(5.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("blockCoal").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(174, "packed_ice", new BlockPackedIce().setHardness(0.5f).setSoundType(SoundType.GLASS).setTranslationKey("icePacked"));
        Block.registerBlock(175, "double_plant", (Block)new BlockDoublePlant());
        Block.registerBlock(176, "standing_banner", new BlockBanner.BlockBannerStanding().setHardness(1.0f).setSoundType(SoundType.WOOD).setTranslationKey("banner").disableStats());
        Block.registerBlock(177, "wall_banner", new BlockBanner.BlockBannerHanging().setHardness(1.0f).setSoundType(SoundType.WOOD).setTranslationKey("banner").disableStats());
        Block.registerBlock(178, "daylight_detector_inverted", (Block)new BlockDaylightDetector(true));
        Block block12 = new BlockRedSandstone().setSoundType(SoundType.STONE).setHardness(0.8f).setTranslationKey("redSandStone");
        Block.registerBlock(179, "red_sandstone", block12);
        Block.registerBlock(180, "red_sandstone_stairs", new BlockStairs(block12.getDefaultState().withProperty(BlockRedSandstone.TYPE, BlockRedSandstone.EnumType.SMOOTH)).setTranslationKey("stairsRedSandStone"));
        Block.registerBlock(181, "double_stone_slab2", new BlockDoubleStoneSlabNew().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("stoneSlab2"));
        Block.registerBlock(182, "stone_slab2", new BlockHalfStoneSlabNew().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("stoneSlab2"));
        Block.registerBlock(183, "spruce_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.SPRUCE).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("spruceFenceGate"));
        Block.registerBlock(184, "birch_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.BIRCH).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("birchFenceGate"));
        Block.registerBlock(185, "jungle_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.JUNGLE).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("jungleFenceGate"));
        Block.registerBlock(186, "dark_oak_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.DARK_OAK).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("darkOakFenceGate"));
        Block.registerBlock(187, "acacia_fence_gate", new BlockFenceGate(BlockPlanks.EnumType.ACACIA).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("acaciaFenceGate"));
        Block.registerBlock(188, "spruce_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.SPRUCE.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("spruceFence"));
        Block.registerBlock(189, "birch_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.BIRCH.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("birchFence"));
        Block.registerBlock(190, "jungle_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.JUNGLE.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("jungleFence"));
        Block.registerBlock(191, "dark_oak_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.DARK_OAK.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("darkOakFence"));
        Block.registerBlock(192, "acacia_fence", new BlockFence(Material.WOOD, BlockPlanks.EnumType.ACACIA.getMapColor()).setHardness(2.0f).setResistance(5.0f).setSoundType(SoundType.WOOD).setTranslationKey("acaciaFence"));
        Block.registerBlock(193, "spruce_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setTranslationKey("doorSpruce").disableStats());
        Block.registerBlock(194, "birch_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setTranslationKey("doorBirch").disableStats());
        Block.registerBlock(195, "jungle_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setTranslationKey("doorJungle").disableStats());
        Block.registerBlock(196, "acacia_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setTranslationKey("doorAcacia").disableStats());
        Block.registerBlock(197, "dark_oak_door", new BlockDoor(Material.WOOD).setHardness(3.0f).setSoundType(SoundType.WOOD).setTranslationKey("doorDarkOak").disableStats());
        Block.registerBlock(198, "end_rod", new BlockEndRod().setHardness(0.0f).setLightLevel(0.9375f).setSoundType(SoundType.WOOD).setTranslationKey("endRod"));
        Block.registerBlock(199, "chorus_plant", new BlockChorusPlant().setHardness(0.4f).setSoundType(SoundType.WOOD).setTranslationKey("chorusPlant"));
        Block.registerBlock(200, "chorus_flower", new BlockChorusFlower().setHardness(0.4f).setSoundType(SoundType.WOOD).setTranslationKey("chorusFlower"));
        Block block13 = new Block(Material.ROCK, MapColor.MAGENTA).setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setCreativeTab(CreativeTabs.BUILDING_BLOCKS).setTranslationKey("purpurBlock");
        Block.registerBlock(201, "purpur_block", block13);
        Block.registerBlock(202, "purpur_pillar", new BlockRotatedPillar(Material.ROCK, MapColor.MAGENTA).setHardness(1.5f).setResistance(10.0f).setSoundType(SoundType.STONE).setCreativeTab(CreativeTabs.BUILDING_BLOCKS).setTranslationKey("purpurPillar"));
        Block.registerBlock(203, "purpur_stairs", new BlockStairs(block13.getDefaultState()).setTranslationKey("stairsPurpur"));
        Block.registerBlock(204, "purpur_double_slab", new BlockPurpurSlab.Double().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("purpurSlab"));
        Block.registerBlock(205, "purpur_slab", new BlockPurpurSlab.Half().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("purpurSlab"));
        Block.registerBlock(206, "end_bricks", new Block(Material.ROCK, MapColor.SAND).setSoundType(SoundType.STONE).setHardness(0.8f).setCreativeTab(CreativeTabs.BUILDING_BLOCKS).setTranslationKey("endBricks"));
        Block.registerBlock(207, "beetroots", new BlockBeetroot().setTranslationKey("beetroots"));
        Block block14 = new BlockGrassPath().setHardness(0.65f).setSoundType(SoundType.PLANT).setTranslationKey("grassPath").disableStats();
        Block.registerBlock(208, "grass_path", block14);
        Block.registerBlock(209, "end_gateway", new BlockEndGateway(Material.PORTAL).setHardness(-1.0f).setResistance(6000000.0f));
        Block.registerBlock(210, "repeating_command_block", new BlockCommandBlock(MapColor.PURPLE).setBlockUnbreakable().setResistance(6000000.0f).setTranslationKey("repeatingCommandBlock"));
        Block.registerBlock(211, "chain_command_block", new BlockCommandBlock(MapColor.GREEN).setBlockUnbreakable().setResistance(6000000.0f).setTranslationKey("chainCommandBlock"));
        Block.registerBlock(212, "frosted_ice", new BlockFrostedIce().setHardness(0.5f).setLightOpacity(3).setSoundType(SoundType.GLASS).setTranslationKey("frostedIce"));
        Block.registerBlock(213, "magma", new BlockMagma().setHardness(0.5f).setSoundType(SoundType.STONE).setTranslationKey("magma"));
        Block.registerBlock(214, "nether_wart_block", new Block(Material.GRASS, MapColor.RED).setCreativeTab(CreativeTabs.BUILDING_BLOCKS).setHardness(1.0f).setSoundType(SoundType.WOOD).setTranslationKey("netherWartBlock"));
        Block.registerBlock(215, "red_nether_brick", new BlockNetherBrick().setHardness(2.0f).setResistance(10.0f).setSoundType(SoundType.STONE).setTranslationKey("redNetherBrick").setCreativeTab(CreativeTabs.BUILDING_BLOCKS));
        Block.registerBlock(216, "bone_block", new BlockBone().setTranslationKey("boneBlock"));
        Block.registerBlock(217, "structure_void", new BlockStructureVoid().setTranslationKey("structureVoid"));
        Block.registerBlock(218, "observer", new BlockObserver().setHardness(3.0f).setTranslationKey("observer"));
        Block.registerBlock(219, "white_shulker_box", new BlockShulkerBox(EnumDyeColor.WHITE).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxWhite"));
        Block.registerBlock(220, "orange_shulker_box", new BlockShulkerBox(EnumDyeColor.ORANGE).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxOrange"));
        Block.registerBlock(221, "magenta_shulker_box", new BlockShulkerBox(EnumDyeColor.MAGENTA).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxMagenta"));
        Block.registerBlock(222, "light_blue_shulker_box", new BlockShulkerBox(EnumDyeColor.LIGHT_BLUE).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxLightBlue"));
        Block.registerBlock(223, "yellow_shulker_box", new BlockShulkerBox(EnumDyeColor.YELLOW).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxYellow"));
        Block.registerBlock(224, "lime_shulker_box", new BlockShulkerBox(EnumDyeColor.LIME).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxLime"));
        Block.registerBlock(225, "pink_shulker_box", new BlockShulkerBox(EnumDyeColor.PINK).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxPink"));
        Block.registerBlock(226, "gray_shulker_box", new BlockShulkerBox(EnumDyeColor.GRAY).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxGray"));
        Block.registerBlock(227, "silver_shulker_box", new BlockShulkerBox(EnumDyeColor.SILVER).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxSilver"));
        Block.registerBlock(228, "cyan_shulker_box", new BlockShulkerBox(EnumDyeColor.CYAN).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxCyan"));
        Block.registerBlock(229, "purple_shulker_box", new BlockShulkerBox(EnumDyeColor.PURPLE).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxPurple"));
        Block.registerBlock(230, "blue_shulker_box", new BlockShulkerBox(EnumDyeColor.BLUE).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxBlue"));
        Block.registerBlock(231, "brown_shulker_box", new BlockShulkerBox(EnumDyeColor.BROWN).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxBrown"));
        Block.registerBlock(232, "green_shulker_box", new BlockShulkerBox(EnumDyeColor.GREEN).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxGreen"));
        Block.registerBlock(233, "red_shulker_box", new BlockShulkerBox(EnumDyeColor.RED).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxRed"));
        Block.registerBlock(234, "black_shulker_box", new BlockShulkerBox(EnumDyeColor.BLACK).setHardness(2.0f).setSoundType(SoundType.STONE).setTranslationKey("shulkerBoxBlack"));
        Block.registerBlock(235, "white_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.WHITE));
        Block.registerBlock(236, "orange_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.ORANGE));
        Block.registerBlock(237, "magenta_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.MAGENTA));
        Block.registerBlock(238, "light_blue_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.LIGHT_BLUE));
        Block.registerBlock(239, "yellow_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.YELLOW));
        Block.registerBlock(240, "lime_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.LIME));
        Block.registerBlock(241, "pink_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.PINK));
        Block.registerBlock(242, "gray_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.GRAY));
        Block.registerBlock(243, "silver_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.SILVER));
        Block.registerBlock(244, "cyan_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.CYAN));
        Block.registerBlock(245, "purple_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.PURPLE));
        Block.registerBlock(246, "blue_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.BLUE));
        Block.registerBlock(247, "brown_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.BROWN));
        Block.registerBlock(248, "green_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.GREEN));
        Block.registerBlock(249, "red_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.RED));
        Block.registerBlock(250, "black_glazed_terracotta", (Block)new BlockGlazedTerracotta(EnumDyeColor.BLACK));
        Block.registerBlock(251, "concrete", new BlockColored(Material.ROCK).setHardness(1.8f).setSoundType(SoundType.STONE).setTranslationKey("concrete"));
        Block.registerBlock(252, "concrete_powder", new BlockConcretePowder().setHardness(0.5f).setSoundType(SoundType.SAND).setTranslationKey("concretePowder"));
        Block.registerBlock(255, "structure_block", new BlockStructure().setBlockUnbreakable().setResistance(6000000.0f).setTranslationKey("structureBlock"));
        REGISTRY.validateKey();
        for (Block block15 : REGISTRY) {
            boolean flag5;
            if (block15.material == Material.AIR) {
                block15.useNeighborBrightness = false;
                continue;
            }
            boolean flag = false;
            boolean flag1 = block15 instanceof BlockStairs;
            boolean flag2 = block15 instanceof BlockSlab;
            boolean flag3 = block15 == block6 || block15 == block14;
            boolean flag4 = block15.translucent;
            boolean bl = flag5 = block15.lightOpacity == 0;
            if (flag1 || flag2 || flag3 || flag4 || flag5) {
                flag = true;
            }
            block15.useNeighborBrightness = flag;
        }
    }

    private static void registerBlock(int id, ResourceLocation textualID, Block block_) {
        REGISTRY.register(id, textualID, block_);
    }

    private static void registerBlock(int id, String textualID, Block block_) {
        Block.registerBlock(id, new ResourceLocation(textualID), block_);
    }

    public static enum EnumOffsetType {
        NONE,
        XZ,
        XYZ;

    }
}

