/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.JsonUtils;

public class NBTPredicate {
    public static final NBTPredicate ANY = new NBTPredicate(null);
    @Nullable
    private final NBTTagCompound tag;

    public NBTPredicate(@Nullable NBTTagCompound tag) {
        this.tag = tag;
    }

    public boolean test(ItemStack item) {
        return this == ANY ? true : this.test(item.getTagCompound());
    }

    public boolean test(Entity entityIn) {
        return this == ANY ? true : this.test(CommandBase.entityToNBT(entityIn));
    }

    public boolean test(@Nullable NBTBase nbt) {
        return nbt == null ? this == ANY : this.tag == null || NBTUtil.areNBTEquals(this.tag, nbt, true);
    }

    public static NBTPredicate deserialize(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            NBTTagCompound nbttagcompound;
            try {
                nbttagcompound = JsonToNBT.getTagFromJson(JsonUtils.getString(json, "nbt"));
            }
            catch (NBTException nbtexception) {
                throw new JsonSyntaxException("Invalid nbt tag: " + nbtexception.getMessage());
            }
            return new NBTPredicate(nbttagcompound);
        }
        return ANY;
    }
}

