/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;

public class MinMaxBounds {
    public static final MinMaxBounds UNBOUNDED = new MinMaxBounds(null, null);
    private final Float min;
    private final Float max;

    public MinMaxBounds(@Nullable Float min, @Nullable Float max) {
        this.min = min;
        this.max = max;
    }

    public boolean test(float value) {
        return this.min != null && this.min.floatValue() > value ? false : this.max == null || !(this.max.floatValue() < value);
    }

    public boolean testSquare(double value) {
        return this.min != null && (double)(this.min.floatValue() * this.min.floatValue()) > value ? false : this.max == null || !((double)(this.max.floatValue() * this.max.floatValue()) < value);
    }

    public static MinMaxBounds deserialize(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return UNBOUNDED;
        }
        if (JsonUtils.isNumber(element)) {
            float f2 = JsonUtils.getFloat(element, "value");
            return new MinMaxBounds(Float.valueOf(f2), Float.valueOf(f2));
        }
        JsonObject jsonobject = JsonUtils.getJsonObject(element, "value");
        Float f = jsonobject.has("min") ? Float.valueOf(JsonUtils.getFloat(jsonobject, "min")) : null;
        Float f1 = jsonobject.has("max") ? Float.valueOf(JsonUtils.getFloat(jsonobject, "max")) : null;
        return new MinMaxBounds(f, f1);
    }
}

