/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemDurabilityTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("item_durability_changed");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void addListener(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners itemdurabilitytrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (itemdurabilitytrigger$listeners == null) {
            itemdurabilitytrigger$listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, itemdurabilitytrigger$listeners);
        }
        itemdurabilitytrigger$listeners.add(listener);
    }

    @Override
    public void removeListener(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners itemdurabilitytrigger$listeners = this.listeners.get(playerAdvancementsIn);
        if (itemdurabilitytrigger$listeners != null) {
            itemdurabilitytrigger$listeners.remove(listener);
            if (itemdurabilitytrigger$listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    @Override
    public void removeAllListeners(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    @Override
    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        ItemPredicate itempredicate = ItemPredicate.deserialize(json.get("item"));
        MinMaxBounds minmaxbounds = MinMaxBounds.deserialize(json.get("durability"));
        MinMaxBounds minmaxbounds1 = MinMaxBounds.deserialize(json.get("delta"));
        return new Instance(itempredicate, minmaxbounds, minmaxbounds1);
    }

    public void trigger(EntityPlayerMP player, ItemStack itemIn, int newDurability) {
        Listeners itemdurabilitytrigger$listeners = this.listeners.get(player.getAdvancements());
        if (itemdurabilitytrigger$listeners != null) {
            itemdurabilitytrigger$listeners.trigger(itemIn, newDurability);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(ItemStack item, int newDurability) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!listener.getCriterionInstance().test(item, newDurability)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener<Instance> listener1 : list) {
                    listener1.grantCriterion(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ItemPredicate item;
        private final MinMaxBounds durability;
        private final MinMaxBounds delta;

        public Instance(ItemPredicate item, MinMaxBounds durability, MinMaxBounds delta) {
            super(ID);
            this.item = item;
            this.durability = durability;
            this.delta = delta;
        }

        public boolean test(ItemStack item, int p_193197_2_) {
            if (!this.item.test(item)) {
                return false;
            }
            return !this.durability.test(item.getMaxDamage() - p_193197_2_) ? false : this.delta.test(item.getItemDamage() - p_193197_2_);
        }
    }
}

