/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.FunctionObject;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionManager
implements ITickable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final File functionDir;
    private final MinecraftServer server;
    private final Map<ResourceLocation, FunctionObject> functions = Maps.newHashMap();
    private String currentGameLoopFunctionId = "-";
    private FunctionObject gameLoopFunction;
    private final ArrayDeque<QueuedCommand> commandQueue = new ArrayDeque();
    private boolean isExecuting = false;
    private final ICommandSender gameLoopFunctionSender = new ICommandSender(){

        @Override
        public String getName() {
            return FunctionManager.this.currentGameLoopFunctionId;
        }

        @Override
        public boolean canUseCommand(int permLevel, String commandName) {
            return permLevel <= 2;
        }

        @Override
        public World getEntityWorld() {
            return FunctionManager.this.server.worlds[0];
        }

        @Override
        public MinecraftServer getServer() {
            return FunctionManager.this.server;
        }
    };

    public FunctionManager(@Nullable File functionDirIn, MinecraftServer serverIn) {
        this.functionDir = functionDirIn;
        this.server = serverIn;
        this.reload();
    }

    @Nullable
    public FunctionObject getFunction(ResourceLocation id) {
        return this.functions.get(id);
    }

    public ICommandManager getCommandManager() {
        return this.server.getCommandManager();
    }

    public int getMaxCommandChainLength() {
        return this.server.worlds[0].getGameRules().getInt("maxCommandChainLength");
    }

    public Map<ResourceLocation, FunctionObject> getFunctions() {
        return this.functions;
    }

    @Override
    public void update() {
        String s = this.server.worlds[0].getGameRules().getString("gameLoopFunction");
        if (!s.equals(this.currentGameLoopFunctionId)) {
            this.currentGameLoopFunctionId = s;
            this.gameLoopFunction = this.getFunction(new ResourceLocation(s));
        }
        if (this.gameLoopFunction != null) {
            this.execute(this.gameLoopFunction, this.gameLoopFunctionSender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(FunctionObject function, ICommandSender sender) {
        int l;
        int i = this.getMaxCommandChainLength();
        if (this.isExecuting) {
            if (this.commandQueue.size() < i) {
                this.commandQueue.addFirst(new QueuedCommand(this, sender, new FunctionObject.FunctionEntry(function)));
            }
            return 0;
        }
        try {
            this.isExecuting = true;
            int j = 0;
            FunctionObject.Entry[] afunctionobject$entry = function.getEntries();
            for (int k = afunctionobject$entry.length - 1; k >= 0; --k) {
                this.commandQueue.push(new QueuedCommand(this, sender, afunctionobject$entry[k]));
            }
            do {
                if (this.commandQueue.isEmpty()) {
                    int n = j;
                    return n;
                }
                this.commandQueue.removeFirst().execute(this.commandQueue, i);
            } while (++j < i);
            l = j;
        }
        finally {
            this.commandQueue.clear();
            this.isExecuting = false;
        }
        return l;
    }

    public void reload() {
        this.functions.clear();
        this.gameLoopFunction = null;
        this.currentGameLoopFunctionId = "-";
        this.loadFunctions();
    }

    private void loadFunctions() {
        if (this.functionDir != null) {
            this.functionDir.mkdirs();
            for (File file1 : FileUtils.listFiles((File)this.functionDir, (String[])new String[]{"mcfunction"}, (boolean)true)) {
                String s = FilenameUtils.removeExtension((String)this.functionDir.toURI().relativize(file1.toURI()).toString());
                String[] astring = s.split("/", 2);
                if (astring.length != 2) continue;
                ResourceLocation resourcelocation = new ResourceLocation(astring[0], astring[1]);
                try {
                    this.functions.put(resourcelocation, FunctionObject.create(this, Files.readLines((File)file1, (Charset)StandardCharsets.UTF_8)));
                }
                catch (Throwable throwable) {
                    LOGGER.error("Couldn't read custom function " + String.valueOf(resourcelocation) + " from " + String.valueOf(file1), throwable);
                }
            }
            if (!this.functions.isEmpty()) {
                LOGGER.info("Loaded " + this.functions.size() + " custom command functions");
            }
        }
    }

    public static class QueuedCommand {
        private final FunctionManager functionManager;
        private final ICommandSender sender;
        private final FunctionObject.Entry entry;

        public QueuedCommand(FunctionManager functionManagerIn, ICommandSender senderIn, FunctionObject.Entry entryIn) {
            this.functionManager = functionManagerIn;
            this.sender = senderIn;
            this.entry = entryIn;
        }

        public void execute(ArrayDeque<QueuedCommand> commandQueue, int maxCommandChainLength) {
            this.entry.execute(this.functionManager, this.sender, commandQueue, maxCommandChainLength);
        }

        public String toString() {
            return this.entry.toString();
        }
    }
}

