/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class Criterion {
    private final ICriterionInstance criterionInstance;

    public Criterion(ICriterionInstance p_i47470_1_) {
        this.criterionInstance = p_i47470_1_;
    }

    public Criterion() {
        this.criterionInstance = null;
    }

    public void serializeToNetwork(PacketBuffer p_192140_1_) {
    }

    public static Criterion criterionFromJson(JsonObject json, JsonDeserializationContext context) {
        ResourceLocation resourcelocation = new ResourceLocation(JsonUtils.getString(json, "trigger"));
        ICriterionTrigger icriteriontrigger = CriteriaTriggers.get(resourcelocation);
        if (icriteriontrigger == null) {
            throw new JsonSyntaxException("Invalid criterion trigger: " + String.valueOf(resourcelocation));
        }
        Object icriterioninstance = icriteriontrigger.deserializeInstance(JsonUtils.getJsonObject(json, "conditions", new JsonObject()), context);
        return new Criterion((ICriterionInstance)icriterioninstance);
    }

    public static Criterion criterionFromNetwork(PacketBuffer p_192146_0_) {
        return new Criterion();
    }

    public static Map<String, Criterion> criteriaFromJson(JsonObject json, JsonDeserializationContext context) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            map.put((String)entry.getKey(), Criterion.criterionFromJson(JsonUtils.getJsonObject((JsonElement)entry.getValue(), "criterion"), context));
        }
        return map;
    }

    public static Map<String, Criterion> criteriaFromNetwork(PacketBuffer bus) {
        HashMap map = Maps.newHashMap();
        int i = bus.readVarInt();
        for (int j = 0; j < i; ++j) {
            map.put(bus.readString(Short.MAX_VALUE), Criterion.criterionFromNetwork(bus));
        }
        return map;
    }

    public static void serializeToNetwork(Map<String, Criterion> criteria, PacketBuffer buf) {
        buf.writeVarInt(criteria.size());
        for (Map.Entry<String, Criterion> entry : criteria.entrySet()) {
            buf.writeString(entry.getKey());
            entry.getValue().serializeToNetwork(buf);
        }
    }

    @Nullable
    public ICriterionInstance getCriterionInstance() {
        return this.criterionInstance;
    }
}

