/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementList {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, Advancement> advancements = Maps.newHashMap();
    private final Set<Advancement> roots = Sets.newLinkedHashSet();
    private final Set<Advancement> nonRoots = Sets.newLinkedHashSet();
    private Listener listener;

    @SideOnly(value=Side.CLIENT)
    private void remove(Advancement advancementIn) {
        for (Advancement advancement : advancementIn.getChildren()) {
            this.remove(advancement);
        }
        LOGGER.info("Forgot about advancement " + String.valueOf(advancementIn.getId()));
        this.advancements.remove(advancementIn.getId());
        if (advancementIn.getParent() == null) {
            this.roots.remove(advancementIn);
            if (this.listener != null) {
                this.listener.rootAdvancementRemoved(advancementIn);
            }
        } else {
            this.nonRoots.remove(advancementIn);
            if (this.listener != null) {
                this.listener.nonRootAdvancementRemoved(advancementIn);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void removeAll(Set<ResourceLocation> ids) {
        for (ResourceLocation resourcelocation : ids) {
            Advancement advancement = this.advancements.get(resourcelocation);
            if (advancement == null) {
                LOGGER.warn("Told to remove advancement " + String.valueOf(resourcelocation) + " but I don't know what that is");
                continue;
            }
            this.remove(advancement);
        }
    }

    public void loadAdvancements(Map<ResourceLocation, Advancement.Builder> advancementsIn) {
        Function function = Functions.forMap(this.advancements, null);
        while (!advancementsIn.isEmpty()) {
            boolean flag = false;
            Iterator<Map.Entry<ResourceLocation, Advancement.Builder>> iterator = advancementsIn.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ResourceLocation, Advancement.Builder> entry = iterator.next();
                ResourceLocation resourcelocation = entry.getKey();
                Advancement.Builder advancement$builder = entry.getValue();
                if (!advancement$builder.resolveParent((java.util.function.Function<ResourceLocation, Advancement>)function)) continue;
                Advancement advancement = advancement$builder.build(resourcelocation);
                this.advancements.put(resourcelocation, advancement);
                flag = true;
                iterator.remove();
                if (advancement.getParent() == null) {
                    this.roots.add(advancement);
                    if (this.listener == null) continue;
                    this.listener.rootAdvancementAdded(advancement);
                    continue;
                }
                this.nonRoots.add(advancement);
                if (this.listener == null) continue;
                this.listener.nonRootAdvancementAdded(advancement);
            }
            if (flag) continue;
            for (Map.Entry<ResourceLocation, Advancement.Builder> entry1 : advancementsIn.entrySet()) {
                LOGGER.error("Couldn't load advancement " + String.valueOf(entry1.getKey()) + ": " + String.valueOf(entry1.getValue()));
            }
        }
        LOGGER.info("Loaded " + this.advancements.size() + " advancements");
    }

    public void clear() {
        this.advancements.clear();
        this.roots.clear();
        this.nonRoots.clear();
        if (this.listener != null) {
            this.listener.advancementsCleared();
        }
    }

    public Iterable<Advancement> getRoots() {
        return this.roots;
    }

    public Iterable<Advancement> getAdvancements() {
        return this.advancements.values();
    }

    @Nullable
    public Advancement getAdvancement(ResourceLocation id) {
        return this.advancements.get(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void setListener(@Nullable Listener listenerIn) {
        this.listener = listenerIn;
        if (listenerIn != null) {
            for (Advancement advancement : this.roots) {
                listenerIn.rootAdvancementAdded(advancement);
            }
            for (Advancement advancement1 : this.nonRoots) {
                listenerIn.nonRootAdvancementAdded(advancement1);
            }
        }
    }

    public static interface Listener {
        public void rootAdvancementAdded(Advancement var1);

        @SideOnly(value=Side.CLIENT)
        public void rootAdvancementRemoved(Advancement var1);

        public void nonRootAdvancementAdded(Advancement var1);

        @SideOnly(value=Side.CLIENT)
        public void nonRootAdvancementRemoved(Advancement var1);

        public void advancementsCleared();
    }
}

