/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.loader.javafix;

import java.util.UUID;
import net.minecraftforge.fml.common.FMLLog;

public class UUIDFix {
    public static UUID fromString(String uuid) {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            if ("UUID string too large".equals(e.getMessage())) {
                return UUIDFix.oldFromString(uuid);
            }
            throw e;
        }
    }

    private static UUID oldFromString(String uuid) {
        String[] components = uuid.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + uuid);
        }
        FMLLog.log.error("UUID [{}] is being processed with the approach from Java 8 for compatibility's sake. This UUID is malformed!", (Object)uuid);
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }

    private UUIDFix() {
    }
}

