export type Dict<T = any, K extends string | symbol = string> = {
    [key in K]: T;
};
export type Get<T extends {}, K> = K extends keyof T ? T[K] : never;
export type Extract<S, T, U = S> = S extends T ? U : never;
export type MaybeArray<T> = [T] extends [unknown[]] ? T : T | T[];
export type Promisify<T> = Promise<T extends Promise<infer S> ? S : T>;
export type Awaitable<T> = [T] extends [Promise<unknown>] ? T : T | Promise<T>;
export type Intersect<U> = (U extends any ? (arg: U) => void : never) extends ((arg: infer I) => void) ? I : never;
export function noop(): any;
export function isNullable(value: any): value is null | undefined | void;
export function isNonNullable<T>(value: T): value is NonNullable<T>;
export function isPlainObject(data: any): any;
export function filterKeys<T, K extends string, U extends K>(object: Dict<T, K>, filter: (key: K, value: T) => key is U): Dict<T, U>;
export function filterKeys<T, K extends string>(object: Dict<T, K>, filter: (key: K, value: T) => boolean): Dict<T, K>;
export function mapValues<U, T, K extends string>(object: Dict<T, K>, transform: (value: T, key: K) => U): Dict<U, K>;
export { mapValues as valueMap };
export function pick<T extends object, K extends keyof T>(source: T, keys?: Iterable<K>, forced?: boolean): Pick<T, K>;
export function omit<T, K extends keyof T>(source: T, keys?: Iterable<K>): Omit<T, K>;
export function defineProperty<T, K extends keyof T>(object: T, key: K, value: T[K]): T;
export function defineProperty<T, K extends keyof any>(object: T, key: K, value: any): T;
export function contain(array1: readonly any[], array2: readonly any[]): boolean;
export function intersection<T>(array1: readonly T[], array2: readonly T[]): T[];
export function difference<S>(array1: readonly S[], array2: readonly any[]): S[];
export function union<T>(array1: readonly T[], array2: readonly T[]): T[];
export function deduplicate<T>(array: readonly T[]): T[];
export function remove<T>(list: T[], item: T): boolean;
export function makeArray<T>(source: null | undefined | T | T[]): T[];
type GlobalConstructorNames = keyof {
    [K in keyof typeof globalThis as typeof globalThis[K] extends abstract new (...args: any) => any ? K : never]: K;
};
export function is<K extends GlobalConstructorNames>(type: K): (value: any) => value is InstanceType<typeof globalThis[K]>;
export function is<K extends GlobalConstructorNames>(type: K, value: any): value is InstanceType<typeof globalThis[K]>;
declare function isArrayBufferLike(value: any): value is ArrayBufferLike;
declare function isArrayBufferSource(value: any): value is Binary.Source;
export namespace Binary {
    type Source<T extends ArrayBufferLike = ArrayBufferLike> = T | ArrayBufferView<T>;
    const is: typeof isArrayBufferLike;
    const isSource: typeof isArrayBufferSource;
    function fromSource<T extends ArrayBufferLike>(source: Source<T>): T;
    function toBase64(source: Source): string;
    function fromBase64(source: string): ArrayBuffer | Uint8Array<ArrayBuffer>;
    function toHex(source: Source): string;
    function fromHex(source: string): ArrayBuffer;
}
export const base64ToArrayBuffer: typeof Binary.fromBase64;
export const arrayBufferToBase64: typeof Binary.toBase64;
export const hexToArrayBuffer: typeof Binary.fromHex;
export const arrayBufferToHex: typeof Binary.toHex;
export function clone<T>(source: T): T;
export function deepEqual(a: any, b: any, strict?: boolean): boolean;
export function capitalize(source: string): string;
export function uncapitalize(source: string): string;
export function camelCase(source: string): string;
export function paramCase(source: string): string;
export function snakeCase(source: string): string;
export const camelize: typeof camelCase;
export const hyphenate: typeof paramCase;
declare namespace Letter {
    interface LowerToUpper {
        a: 'A';
        b: 'B';
        c: 'C';
        d: 'D';
        e: 'E';
        f: 'F';
        g: 'G';
        h: 'H';
        i: 'I';
        j: 'J';
        k: 'K';
        l: 'L';
        m: 'M';
        n: 'N';
        o: 'O';
        p: 'P';
        q: 'Q';
        r: 'R';
        s: 'S';
        t: 'T';
        u: 'U';
        v: 'V';
        w: 'W';
        x: 'X';
        y: 'Y';
        z: 'Z';
    }
    interface UpperToLower {
        A: 'a';
        B: 'b';
        C: 'c';
        D: 'd';
        E: 'e';
        F: 'f';
        G: 'g';
        H: 'h';
        I: 'i';
        J: 'j';
        K: 'k';
        L: 'l';
        M: 'm';
        N: 'n';
        O: 'o';
        P: 'p';
        Q: 'q';
        R: 'r';
        S: 's';
        T: 't';
        U: 'u';
        V: 'v';
        W: 'w';
        X: 'x';
        Y: 'y';
        Z: 'z';
    }
    export type Upper = keyof UpperToLower;
    export type Lower = keyof LowerToUpper;
    export type ToUpper<S extends string> = S extends Lower ? LowerToUpper[S] : S;
    export type ToLower<S extends string, P extends string = ''> = S extends Upper ? `${P}${UpperToLower[S]}` : S;
}
export type camelize<S extends string> = S extends `${infer L}-${infer M}${infer R}` ? `${L}${Letter.ToUpper<M>}${camelize<R>}` : S;
export type hyphenate<S extends string> = S extends `${infer L}${infer R}` ? `${Letter.ToLower<L, '-'>}${hyphenate<R>}` : S;
export function formatProperty(key: keyof any): string;
export function trimSlash(source: string): string;
export function sanitize(source: string): string;
export namespace Time {
    const millisecond = 1;
    const second = 1000;
    const minute: number;
    const hour: number;
    const day: number;
    const week: number;
    function setTimezoneOffset(offset: number): void;
    function getTimezoneOffset(): number;
    function getDateNumber(date?: number | Date, offset?: number): number;
    function fromDateNumber(value: number, offset?: number): Date;
    function parseTime(source: string): number;
    function parseDate(date: string): Date;
    function format(ms: number): string;
    function toDigits(source: number, length?: number): string;
    function template(template: string, time?: Date): string;
}
