# 知识库与知识图谱

项目中的知识库与知识图谱，即是知识管理组织的方式，同时会被封装为工具供 AgenticRAG 系统调用。

## 创建知识库

系统支持多种知识库存储形式，满足不同场景需求：

| 存储类型 | 特点 | 适用场景 |
|----------|------|----------|
| **Chroma** | 轻量级向量数据库 | 已弃用，建议使用 Milvus |
| **Milvus** | 高性能向量数据库 | 大规模生产环境、高性能查询 |
| **LightRAG** | 图增强检索 | 复杂知识关系，构建成本较高 |

访问 Web 界面：`http://localhost:5173`，进入"知识库管理"页面，点击"新建知识库"，填写知识库信息。

这里需要**注意**的是，这里的知识库的标题和描述都会作为智能体选择工具的依据，因此尽量详尽的描述该知识库。


### LightRAG 知识库说明

在本项目中，系统支持基于 [LightRAG](https://github.com/HKUDS/LightRAG) 的知识图谱自动构建，能够从文档中自动提取实体和关系，构建结构化知识图谱。

**LightRAG 图谱 vs 全局知识图谱的区别：**

- **LightRAG 图谱**（知识库专属）：针对单个知识库由 LightRAG 自动抽取实体/关系，用于该库内的图增强检索与可视化。通过特殊的 label（知识库ID）与全局图谱区分，不会混入全局数据。

- **全局知识图谱**（系统级）：通过三元组文件上传的图谱数据，提供系统级的知识图谱查询和可视化能力，会作为工具供 LLM 使用。

两者共享同一个 Neo4j 实例，但完全隔离，互不影响。

LightRAG 知识库可在知识库详情、知识图谱中可视化。由于免费版的 neo4j 只能创建一个图数据库，因此实际上 LightRAG 的节点和边依然是和知识图谱本身构建在了同一个 Neo4j 数据库中，但是使用了特殊的 label `{知识库ID}` 做区分。

同时项目支持原 LightRAG 的所有环境变量，只需要在项目的 `.env` 文件中配置即可。比如当本地计算资源有限时，可以配置 `EMBEDDING_TIMEOUT=60`, `LLM_TIMEOUT=180` 增加超时时间。

## 文档管理

本系统的“上传 → 解析入库 → 检索/可视化”流程既可通过 Web 界面完成，也可使用 API/脚本批量处理。详见[文档解析](../advanced/document-processing.md)

接口查询：`GET /api/knowledge/files/supported-types`

**上传与入库**

1) 上传文件（返回服务端保存路径）
- `POST /api/knowledge/files/upload?db_id=<可选>`
- 成功返回：`file_path`（后续入库使用）、`content_hash`（内容去重）

2) 解析并入库（异步任务）
- `POST /api/knowledge/databases/{db_id}/documents`
- 返回：`status=queued` 与 `task_id`，可在任务中心查看进度

去重策略：系统按“内容哈希”判断是否已存在相同文件，避免重复入库。

## 知识图谱

本项目存在两类“图谱相关”能力：

- 上传的知识图谱（Neo4j）：提供三元组检索和系统级可视化。会作为工具供 LLM 使用。
- LightRAG 知识库内图谱：针对某个知识库由 LightRAG 自动抽取实体/关系，用于该库内的图增强检索与可视化；与上传的图谱共享同一 Neo4j 实例，但通过特殊 label 区分，不作为全局图谱使用。


### 1. 以三元组形式导入

系统支持通过网页导入 `jsonl` 格式的知识图谱数据，支持**简单三元组**和**带属性三元组**两种格式。

**简单格式（兼容旧版）**：

```jsonl
{"h": "北京", "t": "中国", "r": "首都"}
{"h": "上海", "t": "中国", "r": "直辖市"}
```

**扩展格式（支持属性）**：

支持 `h`（头节点）、`t`（尾节点）和 `r`（关系）为对象结构，其中：
- 节点对象必须包含 `name` 字段。
- 关系对象必须包含 `type` 字段。
- 其他字段将作为**属性**存储在 Neo4j 中。

```jsonl
{"h": {"name": "孙悟空", "title": "齐天大圣", "weapon": "如意金箍棒"}, "t": {"name": "唐僧", "species": "人"}, "r": {"type": "徒弟", "order": 1}}
{"h": "猪八戒", "t": {"name": "唐僧"}, "r": {"type": "徒弟", "order": 2}}
```

**格式说明**：
- 每行一个数据项。
- 系统自动验证数据格式，并自动导入到 Neo4j 数据库。
- 自动添加 `Upload`、`Entity` 标签（节点）和 `RELATION` 类型（关系）。
- 自动处理重复实体和关系，并合并属性。

Neo4j 访问信息可以参考 `docker-compose.yml` 中配置对应的环境变量来覆盖。

- **默认账户**: `neo4j`
- **默认密码**: `0123456789`
- **管理界面**: `http://localhost:7474`
- **连接地址**: bolt://localhost:7687

::: tip 测试数据
可以使用以下文件进行测试导入：
- 简单格式：`test/data/A_Dream_of_Red_Mansions_tiny.jsonl`
- 扩展属性格式：`test/data/complex_graph_test.jsonl`
:::

### 2. 接入已有 Neo4j 实例

如需接入已有的 Neo4j 实例，可修改 `.env` 中的配置：

<<< @/../.env.template#neo4j{bash}

同时记得注释掉下面的 neo4j 服务：

<<< @/../docker-compose.yml#neo4j


::: warning 注意事项
确保每个节点都有 `Entity` 标签，每个关系都有 `RELATION` 类型，否则会影响图的检索与构建功能。
:::
